/***************************************************************************
 *   Copyright (C) 2006 by Sarah Michelle Bransdor   *
 *   sarah@spooky-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <kmainwindow.h>
#include <klocale.h>
#include <kdebug.h>
#include <kurl.h>
#include <kimageio.h>
#include <kmessagebox.h>

#include <qpaintdevicemetrics.h>
#include <qpainter.h>
#include "kopyshop.h"

KopyShop::KopyShop(QWidget* parent, const char* name, WFlags fl)
 : KopyShopWidget(parent,name,fl)
{
    if ( (sane = new KScanDevice ( this )) ) {
       QStrList devlst = sane->getDevices();
       PrefsDialog->addInputDevs(devlst);
       PrefsDialog->preview->slConnectScanner( sane );
     }
     else 
       setGUIEnabled( false );

     pPrinter = new KPrinter();
     resolution = 0;

     // init format filter for load/save dialogs
     QImage img;
     QStringList inputFormats = img.inputFormatList();
     QStringList outputFormats = img.outputFormatList();
     LoadFileDialog = new KFileDialog(QString::null, i18n("*|All files"), this, i18n("Open File..."),true);
     SaveFileDialog = new KFileDialog(QString::null, i18n("*|All files"), this, i18n("Save File..."),true);

    LoadFileDialog->setMode( KFile::ExistingOnly );
    SaveFileDialog->setMode( KFile::Files );

     connect(copyButton, SIGNAL(pressed()),this, SLOT(slCopy_clicked()));
     connect(scanButton, SIGNAL(pressed()),this, SLOT(slScan_clicked()));
     connect(printButton, SIGNAL(pressed()),this, SLOT(slPrint_clicked()));
     connect(saveButton, SIGNAL(pressed()),this, SLOT(slSaveImage()));
     connect(loadButton, SIGNAL(pressed()),this, SLOT(slLoadImage()));
     connect(sane,SIGNAL(sigNewImage(QImage*,ImgScanInfo*)),this,SLOT(slScanComplete(QImage*,ImgScanInfo*)));
 
    loadOptions();


}

KopyShop::~KopyShop()
{
    saveOptions();
   sane->slCloseDevice();
}


void KopyShop::slCopy_clicked()
{
    slScan_clicked();
    slPrint_clicked();
}

void KopyShop::slScan_clicked()
{
     setStatusText(i18n("aquirering image..."));
     setGUIEnabled( false );
     PrefsDialog->setEnabled( false );
     sane->openDevice(PrefsDialog->getInputDeviceName());

     saneopt_res = new KScanOption ( "resolution" );
     saneopt_res->set( PrefsDialog->inputResSB->value() );
     sane->apply( saneopt_res );

     saneopt_mode = new KScanOption ( "mode" );
     switch (PrefsDialog->getColorMode()) {
       case 0: saneopt_mode->set( QCString("Lineart") ); break;
       case 1: saneopt_mode->set( QCString("Grayscale") ); break;
       case 2:
       default: saneopt_mode->set( QCString("Color") ); break;
     }
     sane->apply( saneopt_mode );
     sane->acquire( );
     saneopt_res->get( &resolution );
     PrefsDialog->setInputRes(resolution);
     setGUIEnabled( true );
     PrefsDialog->setEnabled( true );
     setStatusText( QString::null );
     printButton->setEnabled( true );
     saveButton->setEnabled( true );
}


void KopyShop::slPrint_clicked()
{
    setStatusText(i18n( "prepare printing..." ));
    pPrinter->setFullPage( true );
    pPrinter->setResolution ( PrefsDialog->outputResSB->value() );

    if ( pPrinter->setup( this ) )
    {
        setStatusText(i18n( "printing..." ));
        if ( resolution > 0 && PrefsDialog->outputResSB->value() == PrefsDialog->inputResSB->value() )
          pPrinter->setResolution (resolution);
        else
          pPrinter->setResolution ( PrefsDialog->outputResSB->value() );

        pPrinter->setPageSize(KPrinter::A4);
        pPrinter->setColorMode(PrefsDialog->getColorMode()==2?KPrinter::Color : KPrinter::GrayScale);

        QPainter painter;
        QPaintDeviceMetrics pdev( pPrinter );

        int paperW = pdev.width();
        int paperH = pdev.height();

        QImage img_copy;
        QRect selection( PrefsDialog->preview->getImageCanvas()->sel() );

        if (selection.width() < 10 || selection.width() < 10)
            img_copy=img_data;
        else
            PrefsDialog->preview->getImageCanvas()->selectedImage(&img_copy);

        if ( PrefsDialog->scaleEnabled() )
          img_copy = img_copy.smoothScale(paperW, paperH, QImage::ScaleMin);
        else if ( PrefsDialog->outputResSB->value() != PrefsDialog->inputResSB->value() ) 
        {
          img_copy = img_copy.smoothScale(
              img_copy.width() * PrefsDialog->outputResSB->value() / PrefsDialog->inputResSB->value(),
              img_copy.height() * PrefsDialog->outputResSB->value() / PrefsDialog->inputResSB->value() , QImage::ScaleMin);
        }
        painter.begin( pPrinter );

        if ( PrefsDialog->centerEnabled() )
          painter.drawImage( (paperW-img_copy.width()) / 2, (paperH-img_copy.height()) / 2, img_copy);
        else
          painter.drawImage( 0, 0, img_copy);

        painter.end();
   }
   setStatusText( QString::null );
}

void KopyShop::slScanComplete(QImage* p_img,ImgScanInfo*)
{
    img_data = p_img->copy();
    PrefsDialog->updatePreview( p_img );
}

void KopyShop::slSaveImage()
{
  setStatusText(i18n( "save to file..." ));
  KURL url=SaveFileDialog->getSaveURL(QDir::currentDirPath(),  KImageIO::pattern(KImageIO::Writing), this, i18n("Save as..."));

  if( !url.isEmpty() && !SaveFileDialog->currentFilter().isEmpty() )
  {

      QString file = url.path();
      QString handler=file.right(file.length()-file.findRev('.')-1).upper();
      if (handler=="JPG")
         handler="JPEG";

        QImage img_copy;
        QRect selection( PrefsDialog->preview->getImageCanvas()->sel() );

        if (selection.width() < 10 || selection.width() < 10)
            img_copy=img_data;
        else
            PrefsDialog->preview->getImageCanvas()->selectedImage(&img_copy);

      if (!img_copy.save( url.isLocalFile()? file : url.url() , handler ) )
          KMessageBox::error (this,i18n("Could not save image!"), i18n("I/O Error !"));
  }
  setStatusText( QString::null );
}

void KopyShop::slLoadImage()
{
  setStatusText(i18n( "load from file..." ));
  KURL url=LoadFileDialog->getOpenURL(QDir::currentDirPath(), KImageIO::pattern(KImageIO::Reading), this, i18n("Open File..."));
  if(!url.isEmpty())
  {
     if (!img_data.load( url.isLocalFile()? url.path() : url.url() ) )
         KMessageBox::error (this,i18n("Could not open image!"), i18n("I/O Error !"));
     else
         PrefsDialog->updatePreview( &img_data );
  }
  setStatusText( QString::null );
}



#include "kopyshop.moc"
