/***************************************************************************
 *   Copyright (C) 2006 by Sarah Michelle Bransdor   *
 *   sarah@spooky-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <klocale.h>
#include "ksprefswidget.h"

KsPrefsWidget::KsPrefsWidget(QWidget* parent, const char* name, WFlags fl)
 : KsPrefsWidgetBase(parent,name,fl)
{
   selection = QRect(0,0,0,0);
   connect( preview,SIGNAL(newRect(QRect)),this, SLOT(slNewRect(QRect)) );
   connect( preview,SIGNAL(noRect()),this, SLOT(slNoRect()) );
}


KsPrefsWidget::~KsPrefsWidget()
{
}

void KsPrefsWidget::addInputDevs(QStrList &devlst)
{
    inputCombo->clear();
    inputCombo->insertStrList(devlst);
}

void KsPrefsWidget::updatePreview(QImage *p_img,uint prev_width)
{
//  preview->setPixmap( KImageEffect::sample(*p_img,
//      prev_width, (p_img->height() * prev_width) / p_img->width() )
//  );
  preview->newImage( p_img );
  preview->setPreviewImage( *p_img );
}

void KsPrefsWidget::slNewRect( QRect sel)
{
   selection=sel;
}

void KsPrefsWidget::slNoRect( void )
{
  selection.rect(0,0,0,0);
}
