/***************************************************************************
 *   Copyright (C) 2006 by Sarah Michelle Bransdor   *
 *   sarah@spooky-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KSPREFSWIDGET_H
#define KSPREFSWIDGET_H

#include <qwidget.h>
#include <qdialog.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qstrlist.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qtoolbox.h>
#include <qpushbutton.h>
#include <qspinbox.h>

#include "libkscan.h"
#include "ksprefswidgetbase.h"

/**
	@author Sarah Michelle Bransdor <sarah@spooky-online.de>
*/
class KsPrefsWidget : public KsPrefsWidgetBase
{

    Q_OBJECT

public:
    KsPrefsWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );

    ~KsPrefsWidget();

    void updatePreview(QImage *p_img,uint prev_width=300);
    void addInputDevs(QStrList &devlst);
    QCString getInputDeviceName() { return inputCombo->currentText().latin1(); }
    bool scaleEnabled() { return scaleCB->isChecked(); }
    bool centerEnabled() { return centerCB->isChecked(); }
    uint getColorMode() { return colorCombo->currentItem(); }
    void setScale( bool state ) { scaleCB->setChecked(state); }
    void setCenter( bool state ) { centerCB->setChecked(state); }
    void setInputRes( int val ) { inputResSB->setValue(val); }
    void setOutputRes( int val ) { outputResSB->setValue(val); }
    void setColorMode( int val ) { colorCombo->setCurrentItem(val); }
    void setInputDev( QString val ) { if ( val != QString::null ) inputCombo->setCurrentText(val); }
    QRect getSelection() { return selection; }

public slots:
    virtual void slNewRect( QRect );
    virtual void slNoRect( void );

private:
    QRect selection;
};

#endif
