#include "FTPListDialog.h"

#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <qlistbox.h>

static int f = 0;      

FTPListDialog::FTPListDialog( QWidget * parent , const char * name ,QStringList *strList ,int function ) :
      QDialog(parent, name, FALSE)
     
  {
    f = function;
    stringList = strList;   
      init();
      
  }
  

  
  FTPListDialog::~FTPListDialog()
  {
      
  }
  
  
 void FTPListDialog::init()
 {
    
     QVBoxLayout *contentPane;
     
      QGridLayout *buttonPane; 
     
     contentPane  = new QVBoxLayout(this);
     
     contentPane->setMargin( 0 );
      listGrp = new QGroupBox(0, Qt::Vertical, "List", this);
     
     listLayout = new QGridLayout(listGrp->layout());
      
     
 
    
     listBox = new QListBox(this,"List");
     listBox->insertStringList (*stringList,-1);
     listBox->setFixedWidth(300);     
    
   
     listLayout->addMultiCellWidget(listBox, 0, 3, 0, 3);
      
     contentPane->addWidget(listGrp);
 
    
     
     // buttonPane = new QHBoxLayout(contentPane->layout());
     buttonPane = new QGridLayout(contentPane->layout());
    
     QPushButton *Open, *quit;
     if (f == 1)
       Open = new QPushButton( "Open", this );
     if (f == 2)
       Open = new QPushButton( "Delete", this );
     if (f == 3)
       Open = new QPushButton( "Download", this );
        quit = new QPushButton( "Quit", this );
	if (f == 1)
	  connect( listBox, SIGNAL(selected(const QString &)),parent(), SLOT(ftp_open_get(const QString &)) );
        if (f == 2)
	  connect( listBox, SIGNAL(selected(const QString &)),parent(), SLOT(ftp_remove(const QString &)) );
        if (f == 3)
	  connect( listBox, SIGNAL(selected(const QString &)),parent(), SLOT(ftp_download(const QString &)) );
        //connect( listBox, SIGNAL(selected(int)),this, SLOT(slotQuit(int)) );
        connect( quit, SIGNAL(clicked()), SLOT(slotQuit()) );
	if (f == 1)
          connect( Open, SIGNAL(clicked()),parent(), SLOT(ftp_open_get()) );
        if (f == 2) 
          connect( Open, SIGNAL(clicked()),parent(), SLOT(ftp_remove()) );
        if (f == 3) 
          connect( Open, SIGNAL(clicked()),parent(), SLOT(ftp_download()) );
	buttonPane->addWidget(Open,0,2);
        buttonPane->addWidget(quit,0,3);   
       
    
 }

 

 
void FTPListDialog::slotQuit() {
  close();
}

void FTPListDialog::Quit() {
close();
}

void FTPListDialog::closeEvent( QCloseEvent *event ) {
  event->accept();
}

QString FTPListDialog::getCurrentText() {
  return listBox->currentText();
}











