#include "SMTPSettingsDialog.h"
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>


SMTPSettingsDialog::SMTPSettingsDialog( QWidget * parent , const char * name ) :
      QDialog(parent, name, FALSE)
     
  {
     
      init();
     
  }
  

  
  SMTPSettingsDialog::~SMTPSettingsDialog()
  {
      
  }
  
  
 void SMTPSettingsDialog::init()
 {
     
   
  

     QVBoxLayout *contentPane;
      
      QGridLayout *fromPane;
      QGridLayout *buttonPane; 
      QGridLayout *serverPane;
      QGridLayout *replyPane;

     contentPane  = new QVBoxLayout(this);
     
     contentPane->setMargin( 0 );
      serverGrp = new  QGroupBox(0, Qt::Vertical, "Remote MTA Host address", this);
     
     serverPane = new  QGridLayout(serverGrp->layout());
      
     
 
     serverLabel = new  QLabel("Remote Host Name:", serverGrp);
     server = new QLineEdit(serverGrp);
     
     
     serverPane->addWidget(serverLabel, 3, 0);
   
     serverPane->addMultiCellWidget(server, 3, 3, 1, 2);
      
     contentPane->addWidget(serverGrp);
 
    
     
     fromGrp = new QGroupBox(0, Qt::Vertical,"From Addr for remote MTA", this);
    
     fromPane = new  QGridLayout(fromGrp->layout());
      
     
 
     fromLabel = new  QLabel("From Address:", fromGrp);
     from = new  QLineEdit(fromGrp);
     
     
     fromPane->addWidget(fromLabel, 3, 0);
     
       fromPane->addMultiCellWidget(from, 3, 3, 1, 2);
      
        contentPane->addWidget(fromGrp);

     replyGrp = new QGroupBox(0, Qt::Vertical,"ReplyTo Addr used by both local and remote MTA", this);
    
     replyPane = new  QGridLayout(replyGrp->layout());
      
     
 
     replyLabel = new  QLabel("Reply To:", replyGrp);
     reply = new  QLineEdit(replyGrp);
     
     
     replyPane->addWidget(replyLabel, 3, 0);
     
       replyPane->addMultiCellWidget(reply, 3, 3, 1, 2);
      
        contentPane->addWidget(replyGrp);

       buttonGrp = new QGroupBox(0, Qt::Vertical,0,this);
    
     buttonPane = new QGridLayout(buttonGrp->layout());
    
     QPushButton *save, *quit;
     save = new QPushButton( "Save", buttonGrp );
    
     
        quit = new QPushButton( "Quit", buttonGrp );
       
        connect( save, SIGNAL(clicked()),parent(), SLOT(SMTP_SETTINGS()) );
        connect( quit, SIGNAL(clicked()), SLOT(slotQuit()) );
        
	buttonPane->addWidget(save,0,2);
        buttonPane->addWidget(quit,0,3);   
        contentPane->addWidget(buttonGrp);      
    
 }

 


QString SMTPSettingsDialog::getServerName() 
 {
   QString line = server->text(); 
    return line;
 }
 

QString SMTPSettingsDialog::getFromAddress() 
 {
   QString str = from->text(); 
    return str;
 } 

QString SMTPSettingsDialog::getReplyAddress() 
 {
   QString st = reply->text(); 
    return st;
 } 


void SMTPSettingsDialog::setServerName(QString line) 
 {
    server->setText(line); 
    
 }
 

void SMTPSettingsDialog::setFromAddress(QString str) 
 {
    from->setText(str); 
   
 } 

void SMTPSettingsDialog::setReplyAddress(QString st) 
 {
    reply->setText(st); 
    
 } 
 
 
 
void SMTPSettingsDialog::slotQuit() {
  close();
}

void SMTPSettingsDialog::Quit() {
  close();
}

void SMTPSettingsDialog::closeEvent( QCloseEvent *event ) {
  event->accept();
}













