
#include "kpad.h"
#include <pthread.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/sendfile.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <kapp.h>
#include <kmainwindow.h>
#include <kconfig.h>
#include <kstdaccel.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <qtextedit.h>
#include <qtimer.h>
//#include <qcolor.h>
//#include <qpalette.h>
#include <kaction.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <qpopupmenu.h>
//#include <qtoolbar.h>
#include <qtabwidget.h>
#include <qfontinfo.h>
//#include <qcursor.h>
//#include <qfontdatabase.h>
//#include <qcombobox.h>
#include <qmessagebox.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qfont.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpaintdevicemetrics.h>
#include <qsimplerichtext.h>
//#include <qfontdialog.h>
#include <kfontdialog.h>
//#include <qcolordialog.h>
#include <qpainter.h>
#include <qtextcodec.h>
#include <kglobalsettings.h>
#include <qcstring.h>
#include <qdir.h>
#include <qinputdialog.h>
#include <kspell.h>
#include <ksconfig.h>
#include <qtabdialog.h>
#include <qstringlist.h>
#include <qdatetime.h>
#include <klocale.h>
#include <iostream>
using namespace std;

static const char *pE[37] = {"utf16","utf8","ISO8859-1","ISO8859-2","ISO8859-3","ISO8859-4", "ISO8859-5","ISO8859-6","ISO8859-7","ISO8859-8","ISO8859-8-i","ISO8859-9","ISO8859-10","ISO8859-13","ISO8859-14","CP850","CP874","CP1250", "CP1251", "CP1252","CP1253", "CP1254","CP1255","CP1256","CP1257","CP1258","Apple Roman","TIS-620","Big5","eucJP","eucKR","GBK","JIS7","Shift-JIS","TSCII","KOI8-R","KOI8-U" };
	  
static int defaultEncoding = 1;
static int isBackup = 1;
static int isHighlight = 1;
static int makeOut = 1;
static int showHiddenFiles = 1;
static int showTB = 1;
static int mailTo = 1;

static  QMap<QTextEdit*,int> thisEncoding;
static QTimer *threadTimer;
static QPopupMenu *setEncoding;
static QPopupMenu *highlightPolicy;
static QPopupMenu *wrapMode;

static QPopupMenu *wrapPolicy;

static QPopupMenu *backupPolicy;

static QPopupMenu *recentFiles;

static QPopupMenu *hiddenFilesPolicy;

static QPopupMenu *showToolBar;
 
static QPopupMenu *displayMake;

static QPopupMenu *mailPolicy;
static bool isFTPOpen = false;

QString recentNames[5] = {"One","Two","Three","Four","Five"};

int recentNamesCount = 0;
int threadFlag = 0;

QString fileType("All Files (*);;"
              "Plain Text (*.txt);;"
              "c++ (*.cpp *.c++ *.cxx);;"
              "c (*.c);;"
              "c/c++ headers (*.h *.hh *.hpp *.h++ *.hxx);;"
              "Java (*.java);;"
              "Python (*.py *.pyw);;"
              "Perl (*.pl);;"
              "Shell script (*.sh);;"
              "laText (*.tex);;"
              "Java script (*.js *.jsp);;"
              "HTML (*.html *.htm *.dtml);;"
              "sql (*.sql);;"
              "xml (*.xml);;"
              "Texis sql (*.tsql);;"
              "php (*.php);;"
              "Patch (*.diff);;"
              "Java Properties (*.properties);;");
                  

Kpad::Kpad( MyWidget *parent, const char *name )
    : KMainWindow( parent, name )
{
    
    
    
         
    readSettings(); 
    
    createFileMenu();
    createEditMenu();
    createViewMenu();
    createOptionsMenu();
    createFTPMenu();
    createEmailMenu();
    createSpellingMenu();
    createToolsMenu();
    createStatusBar();
    createToolBar();    
    
    tabWidget = new QTabWidget( this );
    connect( tabWidget, SIGNAL( currentChanged( QWidget * ) ),
	     this, SLOT( editorChanged( QWidget * ) ) );
    
    setCentralWidget( tabWidget );

    if ( qApp->argc() == 1 ) {
       QTextEdit *edit = new QTextEdit( tabWidget );
	
	connect(edit,SIGNAL(cursorPositionChanged(int,int)),this,SLOT(updateStatusBar()));
        edit->setTextFormat( PlainText );
	//****************************************
	// edit->setPalette(readColorSettings());
	//****************************************
        int i = readWordWrap();
        if (i == 1) {
          edit->setWordWrap(QTextEdit::WidgetWidth);
          wrapMode->setItemChecked(1,TRUE);
          wrapMode->setItemChecked(2,FALSE);
	}else{
	  if (i == 2) {
          edit->setWordWrap(QTextEdit::NoWrap);
          wrapMode->setItemChecked(1,FALSE);
          wrapMode->setItemChecked(2,TRUE);
	  }
	}
        int j = readWrapPolicy();
        if (j == 1) {
          edit->setWrapPolicy(QTextEdit::AtWordBoundary);
          wrapPolicy->setItemChecked(1,TRUE);
          wrapPolicy->setItemChecked(2,FALSE);
	}else{
	  if (j == 2) {
          edit->setWrapPolicy(QTextEdit::Anywhere);
          wrapPolicy->setItemChecked(1,FALSE);
          wrapPolicy->setItemChecked(2,TRUE);
	  }
	}
        tabWidget->addTab( edit, tr( "untitled" ) );
        tabWidget->showPage( edit );
	QFont tempFont = getThisFont();
        
	edit->setFont( tempFont );

        edit->viewport()->setFocus();
        setCaption("untitled");
	
    } else {
	for ( int i = 1; i < qApp->argc(); ++i )
  
     load( qApp->argv()[ i ] );
        
    }
}

Kpad::~Kpad(){
}

void Kpad::_replace() {
  QString s = rd->pattern();
  QString sr = rd->replacePattern();
 again:
  int  result = doReplace(s,sr, rd->case_sensitive(), rd->word_only(), rd->search_backwards(), rd->_prompt());
     int flag = 0;
     
     if (result == 1) 
       goto again;
       
       
    if(result == 0) {
      switch( QMessageBox::information( rd, "Kpad",
        "End of document reached.\n"
        "Continue from the beginning?",
        "Replace",
     "Quit", 0, 0, 1 ) ) {
    case 0: // The user clicked the Retry again button or pressed Enter
     
      flag = 1;
        break;
    case 1: // The user clicked the Quit or pressed Escape
        // exit
        break;
      
      }// end of switch
      if (flag == 1) {
        if (rd->search_backwards()) {
  int p =  currentEditor()->paragraphs();
  //cout << "para = " << p << "\n";
         int pl = currentEditor()->paragraphLength(p-1);
         //cout << "index = " << pl << "\n";
         currentEditor()->setCursorPosition(p-1,pl);
 }
        else
 currentEditor()->setCursorPosition(0,0);
        goto again;
      }
    }
    
}


void Kpad::_find(){
  
  QString s = fd->pattern();
  
 again:
  int  result = doSearch(s, fd->case_sensitive(), fd->word_only(), fd->search_backwards());
     int flag = 0;
    if(result == 0) {
      switch( QMessageBox::information( fd, "Kpad",
        "End of document reached.\n"
        "Continue from the beginning?",
        "Find",
     "Quit", 0, 0, 1 ) ) {
    case 0: // The user clicked the Retry again button or pressed Enter
     
      flag = 1;
        break;
    case 1: // The user clicked the Quit or pressed Escape
        // exit
        break;
      
      }
      if (flag == 1) {
        if (fd->search_backwards()) {
  int p =  currentEditor()->paragraphs();
  //cout << "para = " << p << "\n";
         int pl = currentEditor()->paragraphLength(p-1);
         //cout << "index = " << pl << "\n";
         currentEditor()->setCursorPosition(p-1,pl);
	}
        else
	currentEditor()->setCursorPosition(0,0);
        goto again;
    }
    }
    
}

int Kpad::doSearch(QString search_pattern, bool case_sensitive, bool word_only, bool search_backwards) {
    int para;
    int index;
      int  length;
      // i made the variable backward when the needed param is forward ** OOPS **
      bool f = true;
      if (search_backwards == true)
        f = false;
      // what a lame fix !
   
  bool r =  currentEditor()->find(search_pattern,case_sensitive,word_only,f,0,0);
  if (r == true) {
    currentEditor()->getCursorPosition(&para,&index);
   
    length = search_pattern.length();
    if (f == false) { // searching backwards
    currentEditor()->setSelection(para,index,para,index-length,0);
    currentEditor()->setCursorPosition(para,index-length);
    } else {
      currentEditor()->setSelection(para,index,para,index+length,0);
      currentEditor()->setCursorPosition(para,index+length);
    }
    
    return 1;
  }
  return 0;
}


int Kpad::doReplace(QString search_pattern,QString replace_pattern, bool case_sensitive, bool word_only, bool search_backwards, bool _prompt) {
    int para;
    int index;
      int  length;
int rflag = 0;
      // i made the variable backward when the needed param is forward ** OOPS **
      bool f = true;
      if (search_backwards == true)
        f = false;
      // what a lame fix !
   
  bool r =  currentEditor()->find(search_pattern,case_sensitive,word_only,f,0,0);
  if (r == true) {
    currentEditor()->getCursorPosition(&para,&index);
   
    length = search_pattern.length();
    if (f == false) { // searching backwards
    currentEditor()->setSelection(para,index,para,index-length,0);
    //currentEditor()->setCursorPosition(para,index-length);
    } else {
      currentEditor()->setSelection(para,index,para,index+length,0);
      // currentEditor()->setCursorPosition(para,index+length);
    }
if (_prompt == true) {
 switch( QMessageBox::information( rd, "Kpad",
        "Want to replace this one?",
        "Yes",
					"No", 0, 0, 1 ) ) {
    case 0: // The user clicked the Retry again button or pressed Enter
     
      rflag = 1;
        break;
    case 1: // The user clicked the Quit or pressed Escape
    return 1;// this should get us on to the next one without changing this one
        break;
      
      }
if (rflag == 1) { //if the user says yes replace
currentEditor()->cut();
currentEditor()->insertAt(replace_pattern,para,index);
length = replace_pattern.length();
if (f == false) { // searching backwards
    currentEditor()->setCursorPosition(para,index-length);
    } else {
      currentEditor()->setCursorPosition(para,index+length);
    }
}// end if rflag
} // end if _promt == true
else {
currentEditor()->cut();
currentEditor()->insertAt(replace_pattern,para,index);
length = replace_pattern.length();
if (f == false) { // searching backwards
    currentEditor()->setCursorPosition(para,index-length);
    } else {
      currentEditor()->setCursorPosition(para,index+length);
    }
}
    
    return 1;
}
  return 0;
}


 

void Kpad::createStatusBar() {
  statusBar()->insertItem("",2,10);
  statusBar()->insertFixedItem("Line:000000 Col: 000",1);
  statusBar()->insertFixedItem("FTP:OFF",3);
  statusBar()->setItemAlignment(2,AlignLeft|AlignVCenter);
  statusBar()->setItemAlignment(1,AlignLeft|AlignVCenter);
  statusBar()->setItemAlignment(3,AlignLeft|AlignVCenter);
  statusBar()->changeItem("Line: 1  Col: 1",1);
}

void Kpad::setMessage(const QString &string) {
  QTimer *statusBarTimer = new QTimer(this);
  
  connect(statusBarTimer,SIGNAL(timeout()),this,SLOT(timer())); 
  statusBarTimer->stop();
  statusBar()->changeItem(string,2);
  statusBarTimer->start(6000,TRUE);
  
}

void Kpad::timer() {
  statusBar()->changeItem("",2);
  
}

  void Kpad::updateStatusBar(){
  
    int para,index;
    QString l;
    currentEditor()->getCursorPosition(&para,&index);
    
    l = QString("Line: %1 Col: %2").arg(QString::number(para+1,10))
      .arg(QString::number(index+1,10));
    statusBar()->changeItem(l,1);
  }

void Kpad::createToolBar() {
    KAction *action;
   QPixmap icon;
   
   KIconLoader *loader = KGlobal::iconLoader();
   icon = loader->loadIcon("filenew",KIcon::MainToolbar);
   action = new KAction( tr( "New" ),icon, KStdAccel::New, this,SLOT(fileNew()),actionCollection(),"newToolBar");
    action->plug(toolBar());
   icon = loader->loadIcon("fileopen",KIcon::MainToolbar);
   
    action = new KAction( tr( "Open" ),icon, KStdAccel::Open, this,SLOT(fileOpen()),actionCollection(),"openToolBar");
   
    action->plug(toolBar());
    icon = loader->loadIcon("filesave",KIcon::MainToolbar);
   action = new KAction( tr( "Save" ),icon, KStdAccel::Save, this,SLOT(fileSave()),actionCollection(),"saveToolBar");
    action->plug(toolBar());
   icon = loader->loadIcon("fileprint",KIcon::MainToolbar);
   action = new KAction( tr( "Print" ),icon, KStdAccel::Print, this,SLOT(filePrint()),actionCollection(),"printToolBar");
    action->plug(toolBar());
   icon = loader->loadIcon("fileclose",KIcon::MainToolbar);
   action = new KAction( tr( "Close" ),icon, KStdAccel::Close, this,SLOT(fileClose()),actionCollection(),"closeToolBar");
    action->plug(toolBar());
    icon = loader->loadIcon("undo",KIcon::MainToolbar);
   action = new KAction( tr( "Undo" ),icon, KStdAccel::Undo, this,SLOT(editUndo()),actionCollection(),"undoToolBar");
    action->plug(toolBar());
    icon = loader->loadIcon("redo",KIcon::MainToolbar);
   action = new KAction( tr( "Redo" ),icon, KStdAccel::Redo, this,SLOT(editRedo()),actionCollection(),"redoToolBar");
    action->plug(toolBar());
icon = loader->loadIcon("editcut",KIcon::MainToolbar);
   action = new KAction( tr( "Cut" ),icon, KStdAccel::Cut, this,SLOT(editCut()),actionCollection(),"cutToolBar");
    action->plug(toolBar());
    icon = loader->loadIcon("editcopy",KIcon::MainToolbar);
   action = new KAction( tr( "Copy" ),icon, KStdAccel::Copy, this,SLOT(editCopy()),actionCollection(),"copyToolBar");
    action->plug(toolBar());
icon = loader->loadIcon("editpaste",KIcon::MainToolbar);
   action = new KAction( tr( "Paste" ),icon, KStdAccel::Paste, this,SLOT(editPaste()),actionCollection(),"pasteToolBar");
    action->plug(toolBar());
icon = loader->loadIcon("exit",KIcon::MainToolbar);
   action = new KAction( tr( "Exit" ),icon, KStdAccel::Quit, this,SLOT(fileExit()),actionCollection(),"exitToolBar");
   //action->plug(toolBar());
icon = loader->loadIcon("viewmag+",KIcon::MainToolbar);
   action = new KAction( tr( "Zoom In" ),icon, KStdAccel::ZoomIn, this,SLOT(Zoom_In()),actionCollection(),"zoominToolBar");
    action->plug(toolBar());
icon = loader->loadIcon("viewmag-",KIcon::MainToolbar);
   action = new KAction( tr( "Zoom Out" ),icon, KStdAccel::ZoomOut, this,SLOT(Zoom_Out()),actionCollection(),"zoomoutToolBar");
    action->plug(toolBar());
   icon = loader->loadIcon("mail_send",KIcon::MainToolbar);
   action = new KAction( tr( "Mail Send" ),icon, 0, this,SLOT(_Email()),actionCollection(),"mailToolBar");
    action->plug(toolBar());
   if (showTB == 1)
     toolBar()->show();
   else
     toolBar()->hide();
}



void Kpad::createFileMenu()
{
  
   QPopupMenu *file = new QPopupMenu;
   
   
 
   KAction *action;
   QPixmap icon;
   KIconLoader *loader = KGlobal::iconLoader();
   icon = loader->loadIcon("filenew",KIcon::Small);
   action = new KAction( tr( "New" ),icon, KStdAccel::shortcut(KStdAccel::New), this,SLOT(fileNew()),actionCollection(),"new");
    action->plug( file );
   icon = loader->loadIcon("fileopen",KIcon::Small);
   action = new KAction( tr( "Open" ),icon, KStdAccel::shortcut(KStdAccel::Open), this,SLOT(fileOpen()),actionCollection(),"open");
    action->plug( file );
    //QPopupMenu *recentFiles = new QPopupMenu();
      recentFiles = new QPopupMenu();
      connect ( recentFiles , SIGNAL ( activated (int) ) , this , SLOT ( openRecentFile(int)) );

      for (int i = 0 ; i < 5 ; i++)
      recentFiles->insertItem((readRecentFile(i)), i,i+1 );
       //use recentFiles->clear() to reset

      
	
     file->insertItem("&Open Recent",recentFiles);

    file->insertSeparator();
    icon = loader->loadIcon("filesave",KIcon::Small);
    action = new KAction( tr( "Save" ),icon, KStdAccel::shortcut(KStdAccel::Save), this,SLOT(fileSave()),actionCollection(),"save");
    action->plug( file );
    action = new KAction( tr( "Save As" ),0 , this,SLOT(fileSaveAs()),actionCollection(),"saveAs");
    action->plug( file );
    file->insertSeparator();
    QPopupMenu *openAsEncoding = new QPopupMenu();
      connect ( openAsEncoding , SIGNAL ( activated (int) ) , this , SLOT ( open_as(int)) );

      for (int i = 0 ; i < 37 ; i++)
           openAsEncoding->insertItem(QString( pE[i] ), i,i+1 );

      
	
     file->insertItem("&Open_As",openAsEncoding);
      


    QPopupMenu *saveAsEncoding = new QPopupMenu();
      connect ( saveAsEncoding , SIGNAL ( activated (int) ) , this , SLOT ( save_as(int)) );
      
            for (int i = 0 ; i < 37 ; i++)
           saveAsEncoding->insertItem(QString( pE[i] ), i,i+1 );
      
       
      
      file->insertItem("&Save_As",saveAsEncoding);
      file->insertSeparator();
      action = new KAction("Open via HTTP",0 , this,SLOT(HTTP_Open()),actionCollection(),"http_open");
    action->plug( file );
      
      file->insertSeparator();
    icon = loader->loadIcon("fileprint",KIcon::Small);
     action = new KAction( tr( "Print" ),icon, KStdAccel::shortcut(KStdAccel::Print), this,SLOT(filePrint()),actionCollection(),"print");
     action->plug( file );
    file->insertSeparator();
    icon = loader->loadIcon("fileclose",KIcon::Small);
    action = new KAction( tr( "Close" ),icon, KStdAccel::shortcut(KStdAccel::Close), this,SLOT(fileClose()),actionCollection(),"_close");
    action->plug( file );
    icon = loader->loadIcon("exit",KIcon::Small);
    action = new KAction( tr( "Exit" ),icon, KStdAccel::shortcut(KStdAccel::Quit), this,SLOT(fileExit()),actionCollection(),"exit");
    action->plug( file );
    menuBar()->insertItem("&File",file);
    
}

void Kpad::HTTP_Open() {
  bool ok;
    QString text = QInputDialog::getText(
            "Kpad", "Enter the URL to open \n leave off the http://  at the beginning", QLineEdit::Normal,
            QString::null, &ok, this );
    if ( ok && !text.isEmpty() ) {
        // user entered something and pressed OK
  QStringList lst = QStringList::split('/', text, TRUE);
  //QString test = lst.join(",");
  QString qurl = lst[0];
  QString qpage;
  unsigned int c = lst.count();
  if (c != 1) {
  for(unsigned int i=1; i<c; i++) {
    QString t = lst[i];
    if (!t.isEmpty() && !t.isNull())
    qpage = qpage +  "/" + t;
  }
  } else
    qpage = "/";
  if ((qpage.isEmpty()) || (qpage.isNull()))
    qpage = "/";
  // find the last token and use it as the filename
  QString nm;
  if (c != 1) {
    QString q = lst[c-1];
  if (!q.isEmpty() && !q.isNull())
    nm = q;
  }
  else
    nm = "index.html";
  if (!nm.isEmpty() && !nm.isNull())
  nm = "/" + nm;
 if (nm.isEmpty() || nm.isNull())
   nm = "/index.html";
  QCString qcname = nm.utf8();
  char *name = qcname.data();
  QCString qcurl = qurl.utf8();
  char *url = qcurl.data();
  QCString qcpage = qpage.utf8();
  char *page = qcpage.data();
  http_session = new myHTTP();
  
  // now open up the page
  int k = http_session->DoHTTP(url,page,name);
  if (k == 0) {
        char *_home = getenv("HOME");
        char _f[] = "/.kpad";
        char *_dnm = _f;
        const size_t _length = strlen(_home) + strlen(_dnm) + strlen(name) + 1;
        //char _g[_length];
        //char *_x_file = _g;
        char *_x_file;
        _x_file = new char[_length];
        strcpy(_x_file,_home);
        strcat(_x_file,_dnm);
        strcat(_x_file,name);
        QString _s = QString(_x_file); 
        isFTPOpen = true;
        load(_s);
  } else {
    QString str = QString("that didn't work");
    setMessage(str);
  }
    } else {
      // dialog canceled -- do nothing
    }
}

void Kpad::createEditMenu()
{
  
      QPopupMenu *edit = new QPopupMenu( this );

      KAction *action;
      QPixmap icon;
      KIconLoader *loader = KGlobal::iconLoader();
      icon = loader->loadIcon("undo",KIcon::Small);
      action = new KAction( tr( "Undo" ),icon, KStdAccel::shortcut(KStdAccel::Undo), this,SLOT(editUndo()),actionCollection(),"undo");
    action->plug( edit );
      icon = loader->loadIcon("redo",KIcon::Small);
      action = new KAction( tr( "Redo" ),icon, KStdAccel::shortcut(KStdAccel::Redo), this,SLOT(editRedo()),actionCollection(),"redo");
    action->plug( edit );
    edit->insertSeparator();
      icon = loader->loadIcon("editcut",KIcon::Small);
      action = new KAction( tr( "Cut" ),icon, KStdAccel::shortcut(KStdAccel::Cut), this,SLOT(editCut()),actionCollection(),"cut");
    action->plug( edit );
      icon = loader->loadIcon("editcopy",KIcon::Small);
      action = new KAction( tr( "Copy" ),icon, KStdAccel::shortcut(KStdAccel::Copy), this,SLOT(editCopy()),actionCollection(),"copy");
    action->plug( edit );
      icon = loader->loadIcon("editpaste",KIcon::Small);
      action = new KAction( tr( "Paste" ),icon, KStdAccel::shortcut(KStdAccel::Paste), this,SLOT(editPaste()),actionCollection(),"paste");
    action->plug( edit );
    edit->insertSeparator();
    
      action = new KAction( tr( "Select All" ),0, this,SLOT(selectAll()),actionCollection(),"selectall");
    action->plug( edit );
      menuBar()->insertItem("&Edit",edit);

}

void Kpad::createViewMenu() {
  QPopupMenu *view = new QPopupMenu(this);
  KAction *action;
   QPixmap icon;
   KIconLoader *loader = KGlobal::iconLoader();
   icon = loader->loadIcon("viewmag+",KIcon::Small);
      action = new KAction( tr( "Zoom In" ),icon,KStdAccel::shortcut(KStdAccel::ZoomIn), this,SLOT(Zoom_In()),actionCollection(),"zoomin");
    action->plug( view );
    icon = loader->loadIcon("viewmag-",KIcon::Small);
      action = new KAction( tr( "Zoom out" ),icon,KStdAccel::shortcut(KStdAccel::ZoomOut), this,SLOT(Zoom_Out()),actionCollection(),"zoomout");
    action->plug( view );
    action = new KAction("Rehighlight",0 , this,SLOT(rehighlight_this()),actionCollection(),"rehighlight");
    action->plug( view );
  menuBar()->insertItem("&View",view);
}


void Kpad::rehighlight_this() {
  if (isHighlight == 1) {
        QFile file( *filenames.find( currentEditor() ) );
        QString fn = QFileInfo(file).fileName();
        if ((fn.endsWith(".cpp")) || (fn.endsWith(".h")) || (fn.endsWith(".c")) || (fn.endsWith(".hh")) || (fn.endsWith(".c++"))   || (fn.endsWith(".cxx")) || (fn.endsWith(".hpp")) || (fn.endsWith(".h++")) || (fn.endsWith(".hxx")))
             cppsyntaxHighlighter->rehighlight();
        else if (fn.endsWith(".java"))   
             javasyntaxHighlighter->rehighlight();
        else if ((fn.endsWith(".py")) || (fn.endsWith(".pyw"))) 
             pythonsyntaxHighlighter->rehighlight();
        else if ((fn.endsWith(".htm")) || (fn.endsWith(".html")) || (fn.endsWith(".dhtml"))) 
             htmlsyntaxHighlighter->rehighlight();
  }

    
}


void Kpad::createOptionsMenu() {

      QPopupMenu *options = new QPopupMenu( this );
      
      KAction *action;
      
      action = new KAction( tr( "Set Font" ),0, this,SLOT(setFontDialog()),actionCollection(),"font");
    action->plug( options );
      
    setEncoding = new QPopupMenu();
       setEncoding->setCheckable(TRUE);
      connect ( setEncoding , SIGNAL ( activated (int) ) , this , SLOT ( setDefaultEncoding(int)) );
      
            for (int i = 0 ; i < 37 ; i++)
           setEncoding->insertItem(QString( pE[i] ), i,i+1 );
      
       
      
      options->insertItem("&Set Default Encoding",setEncoding);
      wrapMode = new QPopupMenu();
      wrapMode->setCheckable(TRUE);   
      connect ( wrapMode , SIGNAL ( activated (int) ) , this , SLOT ( setWrapMode(int)) );
      wrapMode->insertItem(QString("On"),1,1);
      wrapPolicy = new QPopupMenu();
      wrapPolicy->setCheckable(TRUE);   
      connect ( wrapPolicy , SIGNAL ( activated (int) ) , this , SLOT ( setThisWrapPolicy(int)) );
      wrapPolicy->insertItem(QString("Yes"),1,1);
      wrapPolicy->insertItem(QString("No"),2,2);
      wrapMode->insertItem("At Word Breaks?",wrapPolicy);
      wrapMode->insertItem(QString("Off"),2,2);
      options->insertItem("&Word Wrap",wrapMode);
       menuBar()->insertItem("&Options",options);
       setEncoding->setItemChecked(defaultEncoding,TRUE);
       backupPolicy = new QPopupMenu();
       backupPolicy->setCheckable(TRUE);
       connect ( backupPolicy , SIGNAL ( activated ( int ) ) , this , SLOT (setBackupPolicy(int)) );
       backupPolicy->insertItem(QString("On"),1,1);
       backupPolicy->insertItem(QString("Of"),2,2);
       options->insertItem("&Set Backup Policy",backupPolicy);
       if (isBackup == 1) {
          backupPolicy->setItemChecked(1,TRUE);
          backupPolicy->setItemChecked(2,FALSE);
       }
       if (isBackup == 2) {
          backupPolicy->setItemChecked(1,FALSE);
          backupPolicy->setItemChecked(2,TRUE);
       }    
       hiddenFilesPolicy = new QPopupMenu;
       hiddenFilesPolicy->setCheckable(TRUE);
       connect ( hiddenFilesPolicy , SIGNAL ( activated ( int ) ) , this , SLOT (setHiddenFilesPolicy(int)) );
       hiddenFilesPolicy->insertItem(QString("Yes"),1,1);
       hiddenFilesPolicy->insertItem(QString("No"),2,2);
       options->insertItem("&Show Hidden Files",hiddenFilesPolicy);
       if (showHiddenFiles == 1) {
           hiddenFilesPolicy->setItemChecked(1,TRUE);
           hiddenFilesPolicy->setItemChecked(2,FALSE);
       }
       if (showHiddenFiles == 2) {
           hiddenFilesPolicy->setItemChecked(1,FALSE);
           hiddenFilesPolicy->setItemChecked(2,TRUE);
       }
       showToolBar  = new QPopupMenu;
       showToolBar->setCheckable(TRUE);
       connect ( showToolBar , SIGNAL ( activated ( int ) ) , this , SLOT (ToolBarPolicy(int)) );
       showToolBar->insertItem(QString("Yes"),1,1);
       showToolBar->insertItem(QString("No"),2,2);
       options->insertItem("&Show Tool Bar",showToolBar);
       if (showTB == 1) {
           showToolBar->setItemChecked(1,TRUE);
           showToolBar->setItemChecked(2,FALSE);
       }
       if (showTB == 2) {
           showToolBar->setItemChecked(1,FALSE);
           showToolBar->setItemChecked(2,TRUE);
       }
       displayMake = new QPopupMenu();
       displayMake->setCheckable(TRUE);
       connect ( displayMake , SIGNAL ( activated ( int ) ) , this , SLOT (setMakePolicy(int)) );
       displayMake->insertItem(QString("Eterm"),1,1);
       displayMake->insertItem(QString("Editor Tab"),2,2);
       options->insertItem("&Show Make output in",displayMake);
       if (makeOut == 1) {
          displayMake->setItemChecked(1,TRUE);
          displayMake->setItemChecked(2,FALSE);
       }
       if (makeOut == 2) {
          displayMake->setItemChecked(1,FALSE);
          displayMake->setItemChecked(2,TRUE);
       }
       mailPolicy  = new QPopupMenu();
       mailPolicy->setCheckable(TRUE);
       connect ( mailPolicy , SIGNAL ( activated ( int ) ) , this , SLOT (setMailPolicy(int)) );
       mailPolicy->insertItem(QString("Local MTA"),1,1);
       mailPolicy->insertItem(QString("Remote MTA"),2,2);
       options->insertItem("&Mail to  what server?",mailPolicy);
       if (mailTo == 1) {
          mailPolicy->setItemChecked(1,TRUE);
          mailPolicy->setItemChecked(2,FALSE);
       }
       if (mailTo == 2) {
          mailPolicy->setItemChecked(1,FALSE);
          mailPolicy->setItemChecked(2,TRUE);
       }
       //*********************************************************
      //   action = new KAction( tr( "Set Background Color" ),0, this,SLOT(setBKColorDialog()),actionCollection(),"bkcolor");
//      action->plug( options );
//         action = new KAction( tr( "Set Foreground Color" ),0, this,SLOT(setFGColorDialog()),actionCollection(),"fgcolor");
//      action->plug( options );
       //***********************************************************************
       highlightPolicy  = new QPopupMenu();
       highlightPolicy->setCheckable(TRUE);
       connect ( highlightPolicy , SIGNAL ( activated ( int ) ) , this , SLOT (setHighlightPolicy(int)) );
       highlightPolicy->insertItem(QString("On"),1,1);
       highlightPolicy->insertItem(QString("Off"),2,2);
       options->insertItem("&Highlighting",highlightPolicy);
       if (isHighlight == 1) {
          highlightPolicy->setItemChecked(1,TRUE);
          highlightPolicy->setItemChecked(2,FALSE);
       }
       if (isHighlight == 2) {
          highlightPolicy->setItemChecked(1,FALSE);
          highlightPolicy->setItemChecked(2,TRUE);
       }

}

void Kpad::createFTPMenu() {
  QPopupMenu *ftp = new QPopupMenu( this );
  KAction *action;
  action = new KAction( "Log On",0, this,SLOT(FTP_DoLogon()),actionCollection(),"log on");
    action->plug( ftp );
  action = new KAction( "List Files (ls -l)",0, this,SLOT(FTP_DoList()),actionCollection(),"list");
    action->plug( ftp );
  action = new KAction( "Open File",0, this,SLOT(FTP_OpenFile()),actionCollection(),"ftp_open");
    action->plug( ftp );
  action = new KAction( "Save to server",0, this,SLOT(FTP_SaveFile()),actionCollection(),"ftp_save");
    action->plug( ftp );
  action = new KAction( "Save_As....to server",0, this,SLOT(FTP_SaveFileAs()),actionCollection(),"ftp_save_as");
    action->plug( ftp );
  action = new KAction( "Change remote directory",0, this,SLOT(FTP_CD()),actionCollection(),"ftp_cd");
    action->plug( ftp );
  action = new KAction( "Where am I now ?",0, this,SLOT(FTP_PWD()),actionCollection(),"ftp_pwd");
    action->plug( ftp );
    // this returns a rather meaningless string -- no need for it
    //  action = new KAction( "What's the servers OS ?",0, this,SLOT(FTP_OS()),actionCollection(),"ftp_os");
    // action->plug( ftp );
  action = new KAction( "Delete a remote file",0, this,SLOT(FTP_RM()),actionCollection(),"ftp_rm");
    action->plug( ftp );
  action = new KAction( "Rename a remote file or directory",0, this,SLOT(do_ftp_mv()),actionCollection(),"ftp_mv");
    action->plug( ftp );
  action = new KAction( "Delete an empty remote directory",0, this,SLOT(FTP_RMDIR()),actionCollection(),"ftp_rmdir");
    action->plug( ftp );
  action = new KAction( "Create a remote directory",0, this,SLOT(FTP_MKDIR()),actionCollection(),"ftp_mkdir");
    action->plug( ftp );
  action = new KAction( "Download a file",0, this,SLOT(FTP_DOWNLOAD()),actionCollection(),"ftp_download");
    action->plug( ftp );
  action = new KAction( "Upload a file",0, this,SLOT(FTP_UPLOAD()),actionCollection(),"ftp_upload");
    action->plug( ftp );
  action = new KAction( "Log Off",0, this,SLOT(FTP_DoLogoff()),actionCollection(),"log off");
    action->plug( ftp );
  action = new KAction( "FTP Settings",0, this,SLOT(FTP_Settings()),actionCollection(),"ftp_settings");
    action->plug( ftp );
    menuBar()->insertItem("&FTP",ftp);

}

void Kpad::FTP_DOWNLOAD() {
  QStringList s = ftp_session->DoOpenList();
  QStringList *stringList = &s;
  listDialog = new FTPListDialog(this,"Find",stringList,3);
  listDialog->show();
}

void Kpad::FTP_UPLOAD() {
  QFileDialog *fileDialog = new QFileDialog( dir, fileType, this, "Open" , TRUE );
  fileDialog->setMode ( QFileDialog::ExistingFile );
  if (showHiddenFiles == 2)
    fileDialog->setShowHiddenFiles(FALSE);
  else
  fileDialog->setShowHiddenFiles(TRUE);
  fileDialog->setViewMode ( QFileDialog::List );
  QString fn;
  if( fileDialog->exec() == QDialog::Accepted ) {
    fn = fileDialog->selectedFile();
    if ( !fn.isEmpty() ) {
       QFileInfo(fn).convertToAbs();
       QString path  = QFileInfo(fn).filePath();
       int size = QFileInfo(fn).size();
       QCString cpath = QFile::encodeName(path);
       char *fullPath = cpath.data();
       QString fileName = QFileInfo(fn).fileName();
       QCString cfn = QFile::encodeName(fileName);
       char *fName = cfn.data();
       dir = QFileInfo(fn).dirPath();
       // statusBar()->changeItem("Working",2);
       int i = ftp_session->PutFile(fName ,fullPath, size);
       if (i == 0) {
      QString str = QString("upload finished");
      setMessage(str);
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
    }
  }
}

void Kpad::do_ftp_mv() {
 renameDialog = new myRenameDialog(this,"Rename");
 renameDialog->show();
}

void Kpad::FTP_Settings() {
 settingsDialog = new FTPSettingsDialog(this,"Settings");
 readFTPSettings();
 settingsDialog->setServerName(server);
 settingsDialog->setUserName(user);
 settingsDialog->setPassword(password);
 settingsDialog->show();

}
// signal comming back from dialog
void Kpad::FTP_SETTINGS() {
  QString s = settingsDialog->getServerName();
  QString u = settingsDialog->getUserName();
  QString p = settingsDialog->getPassword();
  settingsDialog->Quit();
  writeFTPSettings(s,u,p);
}

void Kpad::FTP_OpenFile() {
  QStringList s = ftp_session->DoOpenList();
  QStringList *stringList = &s;
  listDialog = new FTPListDialog(this,"Find",stringList,1);
  listDialog->show();
}

void Kpad::FTP_SaveFile() {
  fileSave();
  QFile q_file( *filenames.find( currentEditor() ) );
  QFileInfo(q_file).convertToAbs();
  // this one is the full local path
  QString path  = QFileInfo(q_file).filePath();
  int size = QFileInfo(q_file).size();
  QCString cpath = QFile::encodeName(path);
  char *fullPath = cpath.data();
  // this one is just the name
  QString fn = QFileInfo(q_file).fileName();
  QCString cfn = QFile::encodeName(fn);
  char *fName = cfn.data();
  int i = ftp_session->PutFile(fName ,fullPath, size);
  if (i == 0) {
      QString str = QString("save sucessfull");
      setMessage(str);
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
}

void Kpad::FTP_SaveFileAs() {
    bool ok;
    QString text = QInputDialog::getText(
            "Kpad", "Save File As:", QLineEdit::Normal,
            QString::null, &ok, this );
    if ( ok && !text.isEmpty() ) {
        // user entered something and pressed OK
        QCString qcstring = text.utf8();
        char *fname = qcstring.data();
        char *_home = getenv("HOME");
        char _f[] = "/.kpad/";
        char *_dnm = _f;
        const size_t _length = strlen(_home) + strlen(_dnm) + strlen(fname) + 1;
        //char _g[_length];
	// char *fullpath = _g;
        char *fullpath;
        fullpath = new char[_length];
        strcpy(fullpath,_home);
        strcat(fullpath,_dnm);
        strcat(fullpath,fname);
        QString fn = QString(fullpath);
	filenames.replace( currentEditor(), fn );
        fileSave(defaultEncoding,TRUE);
        int size = QFileInfo(fn).size();
	tabWidget->setTabLabel( currentEditor(), QFileInfo( fn ).fileName() );
        int i = ftp_session->PutFile(fname ,fullpath, size);
        if (i == 0) {
      QString str = QString("save_as sucessfull");
      setMessage(str);
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
        if (isHighlight == 1) {
        if ((fn.endsWith(".cpp")) || (fn.endsWith(".h")) || (fn.endsWith(".c")) || (fn.endsWith(".hh")) || (fn.endsWith(".c++"))   || (fn.endsWith(".cxx")) || (fn.endsWith(".hpp")) || (fn.endsWith(".h++")) || (fn.endsWith(".hxx")))
             cppsyntaxHighlighter = new cppSyntaxHighlighter(currentEditor());
        else if (fn.endsWith(".java"))   
             javasyntaxHighlighter = new javaSyntaxHighlighter(currentEditor());
        else if ((fn.endsWith(".py")) || (fn.endsWith(".pyw"))) 
             pythonsyntaxHighlighter = new pythonSyntaxHighlighter(currentEditor());
        else if ((fn.endsWith(".htm")) || (fn.endsWith(".html")) || (fn.endsWith(".dhtml"))) 
             htmlsyntaxHighlighter = new htmlSyntaxHighlighter(currentEditor());
	}

    } else {
        // user entered nothing or pressed Cancel
    }

}

void Kpad::FTP_CD() {
    bool ok;
    QString text = QInputDialog::getText(
            "Kpad", "Enter directory name to change to \n or use .. to move up:", QLineEdit::Normal,
            QString::null, &ok, this );
    if ( ok && !text.isEmpty() ) {
        // user entered something and pressed OK
       QCString qcstring = text.utf8();
        char *_dr = qcstring.data();
        int i = ftp_session->DoCD(_dr);
        if (i == 0) {
      QString str = QString("cd sucessfull");
      setMessage(str);
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
    } else {
        // user entered nothing or pressed Cancel
    }
}

void Kpad::FTP_RM() {

  QStringList s = ftp_session->DoOpenList();
  QStringList *stringList = &s;
  listDialog = new FTPListDialog(this,"Delete",stringList,2);
  listDialog->show();

}

void Kpad::FTP_PWD() {
 const QString msg =  ftp_session->DoPWD();
 const QString app = "Kpad";
QMessageBox::information( this, app, msg,0 ,0, 0 );
}



void Kpad::FTP_MV() {
  QString s = renameDialog->getOriginalFileName();
  QString sr = renameDialog->getNewFileName();
  renameDialog->Quit();
  QCString qcstring = s.utf8();
  char *_ofn = qcstring.data();
  QCString qcstr = sr.utf8();
  char *_nfn = qcstr.data();
  int i = ftp_session->DoMV(_ofn,_nfn);
  if (i == 0) {
      QString str = QString("rename sucessfull");
      setMessage(str);
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
}

void Kpad::FTP_RMDIR() {
  bool ok;
    QString text = QInputDialog::getText(
            "Kpad", "Enter directory to delete:", QLineEdit::Normal,
            QString::null, &ok, this );
    if ( ok && !text.isEmpty() ) {
        // user entered something and pressed OK
       QCString qcstring = text.utf8();
        char *_dir = qcstring.data();
       int i = ftp_session->DoRMDIR(_dir);
       if (i == 0) {
      QString str = QString("remove sucessfull");
      setMessage(str);
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
    } else {
        // user entered nothing or pressed Cancel
    }
}

void Kpad::FTP_MKDIR() {
  bool ok;
    QString text = QInputDialog::getText(
            "Kpad", "Enter directory to create:", QLineEdit::Normal,
            QString::null, &ok, this );
    if ( ok && !text.isEmpty() ) {
        // user entered something and pressed OK
       QCString qcstring = text.utf8();
        char *_dir = qcstring.data();
       int i = ftp_session->DoMKDIR(_dir);
       if (i == 0) {
      QString str = QString("remote directory created");
      setMessage(str);
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
    } else {
        // user entered nothing or pressed Cancel
    }
}

void Kpad::ftp_open_get(const QString &qstring) {
  
    QCString qcstring = qstring.utf8();
    char *fname = qcstring.data();
    listDialog->Quit();
    if ((ftp_session->GetFile(fname)) == 0) {
        char *_home = getenv("HOME");
        char _f[] = "/.kpad/";
        char *_dnm = _f;
        const size_t _length = strlen(_home) + strlen(_dnm) + strlen(fname) + 1;
        //char _g[_length];
        //char *_x_file = _g;
        char *_x_file;
        _x_file = new char[_length];
        strcpy(_x_file,_home);
        strcat(_x_file,_dnm);
        strcat(_x_file,fname);
        QString _s = QString(_x_file);
        isFTPOpen = true;
        load(_s);
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
}

void Kpad::ftp_open_get() {
  QString qstring = listDialog->getCurrentText();
    QCString qcstring = qstring.utf8();
    char *fname = qcstring.data();
    listDialog->Quit();
    if ((ftp_session->GetFile(fname)) == 0) {
        char *_home = getenv("HOME");
        char _f[] = "/.kpad/";
        char *_dnm = _f;
        const size_t _length = strlen(_home) + strlen(_dnm) + strlen(fname) + 1;
        //char _g[_length];
        //char *_x_file = _g;
        char *_x_file;
        _x_file = new char[_length];
        strcpy(_x_file,_home);
        strcat(_x_file,_dnm);
        strcat(_x_file,fname);
        QString _s = QString(_x_file);
        isFTPOpen = true;
        load(_s);
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
}

void Kpad::ftp_remove(const QString &qstring) {
  
    QCString qcstring = qstring.utf8();
    char *fname = qcstring.data();
    listDialog->Quit();
    int i = ftp_session->DoRM(fname);
    if (i == 0) {
      QString str = QString("remove sucessfull");
      setMessage(str);
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
}

void Kpad::ftp_remove() {
  QString qstring = listDialog->getCurrentText();
    QCString qcstring = qstring.utf8();
    char *fname = qcstring.data();
    listDialog->Quit();
    int i = ftp_session->DoRM(fname);
    if (i == 0) {
      QString str = QString("remove sucessfull");
      setMessage(str);
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
}

void Kpad::ftp_download(const QString &qstring) {
  
    QCString qcstring = qstring.utf8();
    char *fname = qcstring.data();
    listDialog->Quit();
    QString d = dir;
    QString sep = "/";
    QString start = d + sep + qstring;
    //cout << start << "\n"; 
    QString fileNm = QFileDialog::getSaveFileName( start, fileType, this );
    if ( QFileInfo(fileNm).exists() ) {
      QString s = QFileInfo(fileNm).fileName();
      QString m = " already exists -- Overwrite? ";
      QString msg = s.append(m);
       switch ( QMessageBox::warning( this, "KPad",
     msg,
     tr("&Yes"),
     
     tr("&No"),
          0,
     0,1) ) {
 case 0: // yes
   // cout << "you just chose yes to overwrite \n";
     if ( !fileNm.isEmpty() ) {
    QFileInfo(fileNm).convertToAbs();
    QString path  = QFileInfo(fileNm).filePath();
    QCString cpath = QFile::encodeName(path);
    char *fullPath = cpath.data();
    statusBar()->changeItem("Working",2);
    if ((ftp_session->DownloadFile(fname,fullPath)) == 0) {
    QString str = QString("Download Finished");
    setMessage(str);
    dir = QFileInfo(fileNm).dirPath();
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
     }
        break;
 case 1: // no
         
     break;
       }
    }
   else  if ( !fileNm.isEmpty() ) {
    QFileInfo(fileNm).convertToAbs();
    QString path  = QFileInfo(fileNm).filePath();
    QCString cpath = QFile::encodeName(path);
    char *fullPath = cpath.data();
    statusBar()->changeItem("Working",2);
    if (( ftp_session->DownloadFile(fname,fullPath)) == 0) {
    QString str = QString("Download Finished");
    setMessage(str);
    dir = QFileInfo(fileNm).dirPath();
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
   }

}

void Kpad::ftp_download() {
  QString qstring = listDialog->getCurrentText();
    QCString qcstring = qstring.utf8();
    char *fname = qcstring.data();
    listDialog->Quit();
    QString d = dir;
    QString sep = "/";
    QString start = d + sep + qstring;
    //cout << start << "\n"; 
    QString fileNm  = QFileDialog::getSaveFileName( start, fileType, this );
    if ( QFileInfo(fileNm).exists() ) {
      QString s = QFileInfo(fileNm).fileName();
      QString m = " already exists -- Overwrite? ";
      QString msg = s.append(m);
       switch ( QMessageBox::warning( this, "KPad",
     msg,
     tr("&Yes"),
     
     tr("&No"),
          0,
     0,1) ) {
 case 0: // yes
   // cout << "you just chose yes to overwrite \n";
     if ( !fileNm.isEmpty() ) {
    QFileInfo(fileNm).convertToAbs();
    QString path  = QFileInfo(fileNm).filePath();
    QCString cpath = QFile::encodeName(path);
    char *fullPath = cpath.data();
    statusBar()->changeItem("Working",2);
    if ((ftp_session->DownloadFile(fname,fullPath)) == 0) {
    QString str = QString("Download Finished");
    setMessage(str);
    dir = QFileInfo(fileNm).dirPath();
    } else {
      QString str = QString("an error occured");
      setMessage(str);
    }
	    }
        break;
	case 1: // no
	    				
	    break;
       }
    }
   else  if ( !fileNm.isEmpty() ) {
    QFileInfo(fileNm).convertToAbs();
    QString path  = QFileInfo(fileNm).filePath();
    QCString cpath = QFile::encodeName(path);
    char *fullPath = cpath.data();
    statusBar()->changeItem("Working",2);
    if (( ftp_session->DownloadFile(fname,fullPath)) == 0) {
    QString str = QString("Download Finished");
    setMessage(str);
    dir = QFileInfo(fileNm).dirPath();
    }
    else {
      QString str = QString("an error occured");
      setMessage(str);
    }
   }

}



void Kpad::FTP_DoLogoff() {
  ftp_session->DoClose();
  statusBar()->changeItem("FTP:OFF",3);
}

void Kpad::FTP_DoLogon() {
  readFTPSettings();
  QCString qcstring = server.utf8();
  char *host = qcstring.data();
  QCString qcstr = user.utf8();
  char *usr = qcstr.data();
  QCString qcst = password.utf8();
  char *pass = qcst.data();
 ftp_session = new myFTP(this,"myFTP");
 if ((ftp_session->FTPOpen(usr, pass, host)) == 0) {
   statusBar()->changeItem("FTP:ON",3);
} else {
   QString str = QString("an error occured");
      setMessage(str);
}
}

void Kpad::FTP_DoList() {
  if (( ftp_session->DoList() ) == 0) {
      char *_home = getenv("HOME");
      char _f[] = "/.kpad/FTP.list";
      char *_fnm = _f;
      const size_t _length = strlen(_home) + strlen(_fnm) + 1;
      //char _g[_length];
      //char *_x_file = _g;
      char *_x_file;
      _x_file = new char[_length];
      strcpy(_x_file,_home);
      strcat(_x_file,_fnm);
      QString _s = QString(_x_file);
      isFTPOpen = true;
      load(_s);
  } else {
    QString str = QString("an error occured");
      setMessage(str);
  }
      
}

void Kpad::createEmailMenu() {
      QPopupMenu *email = new QPopupMenu( this );
      
      KAction *action;
      QPixmap icon;
      KIconLoader *loader = KGlobal::iconLoader();
      icon = loader->loadIcon("mail_send",KIcon::Small);
      action = new KAction( tr( "Send Email (utf8)" ),icon,0, this,SLOT(_Email()),actionCollection(),"mail_send");
      // action = new KAction( tr( "Send as Email" ),0, this,SLOT(_Email()),actionCollection(),"email");
      action->plug( email );
      action = new KAction("Email Settings",0, this,SLOT(EmailSettings()),actionCollection(),"email_settings");
    action->plug( email );
      
      menuBar()->insertItem("&Email",email);
}

 void Kpad::EmailSettings() {
 mailSettingsDialog = new SMTPSettingsDialog(this,"Settings");
 readSMTPSettings();
 mailSettingsDialog->setServerName(host);
 mailSettingsDialog->setFromAddress(from);
 mailSettingsDialog->setReplyAddress(replyTo);
 mailSettingsDialog->show();

 }

// signal back from dialog
void Kpad::SMTP_SETTINGS() {
  QString s = mailSettingsDialog->getServerName();
  QString u = mailSettingsDialog->getFromAddress();
  QString p = mailSettingsDialog->getReplyAddress();
  mailSettingsDialog->Quit();
  writeSMTPSettings(s,u,p);
}

void Kpad::createSpellingMenu() {
      QPopupMenu *spelling = new QPopupMenu( this );
      
      KAction *action;
      QPixmap icon;
      KIconLoader *loader = KGlobal::iconLoader();
      icon = loader->loadIcon("spellcheck",KIcon::Small);
      action = new KAction( tr( "Check spelling" ),icon,0, this,SLOT(spellcheck()),actionCollection(),"spellcheck");
      action->plug( spelling );
      action = new KAction("Configure spellcheck" ,0, this,SLOT(spellcheckConfig()),actionCollection(),"make");
    action->plug( spelling );
      menuBar()->insertItem("&Spelling",spelling);

}
void Kpad::createToolsMenu() {

      QPopupMenu *tools = new QPopupMenu( this );
      
      KAction *action;
      // QPixmap icon;
      //KIconLoader *loader = KGlobal::iconLoader();
      //icon = loader->loadIcon("undo",KIcon::Small);
      //action = new KAction( tr( "Terminal" ),0, this,SLOT(_Term()),actionCollection(),"term");
      //action->plug( tools );
      
      action = new KAction( tr( "Make" ),0, this,SLOT(_Make()),actionCollection(),"make");
    action->plug( tools );
      action = new KAction( tr( "Search/Find" ),0, this,SLOT(_Find()),actionCollection(),"find");
    action->plug( tools );
      action = new KAction( tr( "Go To Line" ),0, this,SLOT(_GoTo()),actionCollection(),"goto");
    action->plug( tools );
      action = new KAction( tr( "Find/Replace" ),0, this,SLOT(_Replace()),actionCollection(),"replace");
    action->plug( tools );
      action = new KAction( tr( "Date/Time stamp" ),0, this,SLOT(Date_Time()),actionCollection(),"date_time");
    action->plug( tools );
     
    
      menuBar()->insertItem("&Tools",tools);
}


void Kpad::Date_Time() {
  int line, column;

  QString dateString,timeString,str;
  QDate dt = QDate::currentDate();
  QTime tm = QTime::currentTime();
  dateString = KGlobal::locale()->formatDate(dt);
  timeString = KGlobal::locale()->formatTime(tm,false);
  str = dateString + " " + timeString;
  currentEditor()->getCursorPosition(&line,&column);
  currentEditor()->insertAt(str,line,column);
  

  
}


void Kpad::spellcheck()
{
  if (!currentEditor()) return;
  //QString text (currentEditor()->text());
   kspell = new KSpell(this, i18n("Spellcheck"), this,
	SLOT( spell_check(KSpell *)), 0,FALSE,TRUE);

   //kspell->modalCheck(text);
  //KSpell::modalCheck(text);
  //currentEditor()->setText(text);
  //QString newText (currentEditor()->text());
  //currentEditor()->setText(newText);
  
  

  connect (kspell, SIGNAL (done(const QString&)),
   this, SLOT (spell_done(const QString&)));
  connect (kspell, SIGNAL (corrected (const QString &, const QString &, unsigned int)),
                 this, SLOT (spell_corrected (const QString &, const QString &, unsigned int)));
  
  

   
}

void Kpad::spell_check( KSpell *)
{
   QString text (currentEditor()->text());
   kspell->check(text);
   //currentEditor()->setText(text);
}

void Kpad::spell_done(const QString& newText) {
   bool test = currentEditor()->isModified();
   if (test == 1) {
   currentEditor()->setText( newText);
   currentEditor()->setModified(TRUE);
   }
   kspell->cleanUp();
   // just for debugging
  
     
}

void Kpad::spell_corrected(const QString& , const QString& , unsigned int ) {
  currentEditor()->setModified(TRUE);
  // bool test = currentEditor()->isModified();
  // cout << test << "\n";
}




void Kpad::spellcheckConfig() {
  QTabDialog qtabdialog (0, 0, true);
  qtabdialog.setCancelButton();
  KSpellConfig ksconfig (&qtabdialog);
  qtabdialog.addTab (&ksconfig, "&Spellchecker");
  if (qtabdialog.exec())
   ksconfig.writeGlobalSettings();
}

// this is called by the menu
void Kpad::_Email() {
 mailDialog = new myMailDialog(this,"Rename");
 mailDialog->setRecipientHistory(readMailRecipientHistory());
 mailDialog->show();
}
// this one is called by the dialog
void Kpad::SEND_MAIL() {
  int exitCode = 1;
  QString r = mailDialog->getRecipient();
  QString s = mailDialog->getSubject();
  writeMailRecipientHistory();
  mailDialog->Quit();
  QCString qcstring = r.utf8();
  char *_recip = qcstring.data();
  QCString qcstr = s.utf8();
  char *_subj = qcstr.data();
  QString body = currentEditor()->text();
  QCString qcs = body.utf8();
  char *_msg = qcs.data();
  if (mailTo == 1) {
    readSMTPSettings();
    QCString qcst = replyTo.utf8();
    char *_reply = qcst.data();
  smtp_session = new mySMTP();
  exitCode = smtp_session->DoMail(_recip, _subj, _msg, _reply);
  }
  else if (mailTo == 2) {
    readSMTPSettings();
    QCString q = host.utf8();
    char *_host = q.data();
    //cout << _host << " is the way it is before we send it over \n";
    QCString q_s = from.utf8();
    char *_from = q_s.data();
    QCString q_st = replyTo.utf8();
    char *_reply = q_st.data();
    smtp_session = new mySMTP();
    exitCode = smtp_session->DoMail(_recip, _subj, _msg, _host, _from, _reply);
  }
  if (exitCode == 0) {
    QString str = QString("Mail send sucessfull");
    setMessage(str);
  }
  else {
    QString str = QString("Mail not sent -- an error occured");
    setMessage(str);
  }

  
}

void Kpad::_Find() {
fd = new myFindDialog(this,"Find");
 readFindSettings();
 fd->setOptions();
 fd->show();
}

void Kpad::_Replace() {
rd = new myReplaceDialog(this,"Replace");
 readReplaceSettings();
 rd->setOptions();
 rd->show();
}

void Kpad::_GoTo() {
  gd = new myGoToDialog(this,"GoTo");
  gd->show();
}

void Kpad::_goto() {
  QString line = gd->line();
  bool ok;
  int l = line.toInt(&ok,10);
  currentEditor()->setCursorPosition(l-1,0);
  int li = currentEditor()->paragraphLength(l-1);
  currentEditor()->setSelection(l-1,0,l-1,li,0);
  
}

//  void Kpad::_Term() {
//    char  a[] = "Eterm";
//    char *ap = a;
//    char* arg_list[] = {a,NULL};
//    spawn (ap,arg_list);
//  }
void Kpad::_Make() {

    
  if (makeOut == 1) {
    QFile q_file( *filenames.find( currentEditor() ) );
    QFileInfo(q_file).convertToAbs();
    QString directory = QFileInfo(q_file).dirPath();
    
    QCString cdirectory = QFile::encodeName(directory);
    char *directoryName = cdirectory.data();
    // cout << directoryName << "\n";
    
    char  _a[] = "Eterm";
    char *_ap = _a;
    char  _b[] = "--pause";
    char *_bp = _b;
    char  _c[] = "-e";
    char *_cp = _c;
    char  _d[] = "make";
    char *_dp = _d;
    char  _e[] = "-C";
    char *_ep = _e;
    char* arg_list[] = {_ap,_bp,_cp,_dp,_ep,directoryName,NULL};
    spawn (_ap,arg_list);
  }
  else if (makeOut == 2) {
    struct thread_parameters parameters;
    QFile q_file( *filenames.find( currentEditor() ) );
    QFileInfo(q_file).convertToAbs();
    QString directory = QFileInfo(q_file).dirPath();
    parameters.drnm = directory;
    
    pthread_attr_t attributes;
    pthread_t thread_id;
    pthread_attr_init(&attributes);
    pthread_attr_setdetachstate(&attributes, PTHREAD_CREATE_DETACHED);
    pthread_create(&thread_id, &attributes, &doPipe, &parameters);
    threadTimer = new QTimer(this);
    connect(threadTimer,SIGNAL(timeout()),this,SLOT(threadListener())); 
    threadTimer->start(30000,FALSE);
    statusBar()->changeItem("running make - could take some time",2);
  
        
       
    
    
  }
}

void Kpad::threadListener() {
  if (threadFlag == 1) {
    threadTimer->stop();
    threadFlag = 0;
    statusBar()->changeItem("Done",2);
    char *home = getenv("HOME");
    char f[] = "/.kpad/Make.output";
    char *fnm = f;
    const size_t length = strlen(home) + strlen(fnm) + 1;
    //char g[length];
    //char *x_file = g;
    char *x_file;
    x_file = new char[length];
    strcpy(x_file,home);
    strcat(x_file,fnm);
    QString s = QString(x_file);
    load(s);
  }
}


void* doPipe (void* parameters) {
  struct thread_parameters *p = (struct thread_parameters*) parameters;
  QCString cdirectory = QFile::encodeName(p->drnm);
    char *_directoryName = cdirectory.data();
  
    char _t[] = "make -C "; 
    char *temp1 = _t;
    //cout << temp1 << "\n";
    char _tmp[] = " 2>&1";
      char *temp2 = _tmp;
      //cout << _directoryName << "\n";
      //cout << temp2 << "\n";
    const size_t totalLength = strlen(temp1) + strlen(_directoryName) + strlen(temp2) + 1;
    //char _h[totalLength];
    //char *_command = _h;
    char *_command;
    _command = new char[totalLength];
    strcpy(_command,temp1);
    strcat(_command,_directoryName);
    strcat(_command,temp2);
    //cout << _command << "\n";
    char buf[BUFSIZ];
    FILE *ptr;
    FILE *pFile;
    char *home = getenv("HOME");
    char h_dr[] = "/.kpad";
    char *h_d = h_dr;
    const size_t _len = strlen(home) +  strlen(h_d) + 1;
    //char _l[_len];
    //char *_hdir = _l;
    char *_hdir;
    _hdir = new char[_len];
    strcpy(_hdir,home);
    strcat(_hdir,h_d);
    QString str = QString(_hdir);
    QDir _d(str);
    if ( !_d.exists() ) {
        bool _b = _d.mkdir(str,TRUE);
	if ( _b == false)
          return NULL;
    }
    char f[] = "/.kpad/Make.output";
    char *fnm = f;
    const size_t _length = strlen(home) + strlen(fnm) + 1;
    //char d[_length];
    //char *m_file = d;
    char *m_file;
    m_file = new char[_length];
    strcpy(m_file,home);
    strcat(m_file,fnm);
    pFile = fopen (m_file , "w");
    if ((ptr = popen(_command, "r")) != NULL)
      while (fgets(buf, BUFSIZ, ptr) != NULL)
        fprintf(pFile,buf);
   
    pclose(ptr);
    fclose(pFile);
    threadFlag = 1;
    return NULL;
}

int Kpad::spawn (char* program, char** arg_list) {
  pid_t child_pid;
  child_pid = fork();
  if (child_pid != 0)
    return child_pid;
  else {
    execvp (program, arg_list);
    //will only return if an error occures
    abort();
  }
}

void Kpad::Zoom_Out() {
  currentEditor()->zoomOut(3);
}

void Kpad::Zoom_In() {
  currentEditor()->zoomIn(3);
}

void Kpad::setDefaultEncoding(int c) {
    setEncoding->setItemChecked(defaultEncoding,FALSE);
    defaultEncoding = c;
    setEncoding->setItemChecked(defaultEncoding,TRUE);
    QString str = QString("Default Encoding set to %1").arg(pE[defaultEncoding]);
    setMessage(str);
    
  
}

//  void Kpad::setBKColorDialog(){
//    QColor bkColor = QColorDialog::getColor();
//    int c = tabWidget->count();
//             int x = 0;
//             while (x<c) {
//                if ( !(QTextEdit *)tabWidget->page(x) )
//  	        return;

//               QPalette p = ((QTextEdit *)tabWidget->page(x))->palette();
//               p.setColor(QColorGroup::Base,bkColor);
//               ((QTextEdit *)tabWidget->page(x))->setPalette(p);
//                x++;
             
   
	      
//  	   }
//    KConfig *kconfig = KGlobal::config();
//    kconfig->setGroup("Colors");
//    QString s;
//    s.sprintf("#%02x%02x%02x",bkColor.red(),bkColor.green(),bkColor.blue());
//    kconfig->writeEntry("BG",s);
//    kconfig->sync();	   
//  }

//  void Kpad::setFGColorDialog(){
//    QColor fgColor = QColorDialog::getColor();
//    int c = tabWidget->count();
//             int x = 0;
//             while (x<c) {
//                if ( !(cppSyntaxHighlighter *)tabWidget->page(x) )
//  	        return;

//               QPalette p = ((QTextEdit *)tabWidget->page(x))->palette();
//               p.setColor(QColorGroup::Text,fgColor);
//               ((QTextEdit *)tabWidget->page(x))->setPalette(p);
//                x++;
             
   
	      
//  	   }
//KConfig *kconfig = KGlobal::config();
//kconfig->setGroup("Colors");
//QString s;
//s.sprintf("#%02x%02x%02x",fgColor.red(),fgColor.green(),fgColor.blue());
//kconfig->writeEntry("FG",s);
//kconfig->sync();
	   
//}

void Kpad::setBackupPolicy(int p) {
  if (p == 1) {
      isBackup = 1;
      backupPolicy->setItemChecked(1,TRUE);
      backupPolicy->setItemChecked(2,FALSE);
  }
  if (p == 2) {
        isBackup = 2;
        backupPolicy->setItemChecked(1,FALSE);
        backupPolicy->setItemChecked(2,TRUE);
  }    
  
       
}

void Kpad::setMakePolicy(int p) {
  if (p == 1) {
      makeOut = 1;
      displayMake->setItemChecked(1,TRUE);
      displayMake->setItemChecked(2,FALSE);
  }
  if (p == 2) {
        makeOut = 2;
        displayMake->setItemChecked(1,FALSE);
        displayMake->setItemChecked(2,TRUE);
  }    
  
       
}


void Kpad::setMailPolicy(int p) {
  if (p == 1) {
      mailTo = 1;
      mailPolicy->setItemChecked(1,TRUE);
      mailPolicy->setItemChecked(2,FALSE);
  }
  if (p == 2) {
        mailTo = 2;
        mailPolicy->setItemChecked(1,FALSE);
        mailPolicy->setItemChecked(2,TRUE);
  }    
  
       
}

void Kpad::setHighlightPolicy(int p) {
  if (p == 1) {
      isHighlight = 1;
      highlightPolicy->setItemChecked(1,TRUE);
      highlightPolicy->setItemChecked(2,FALSE);
  }
  if (p == 2) {
        isHighlight = 2;
        highlightPolicy->setItemChecked(1,FALSE);
        highlightPolicy->setItemChecked(2,TRUE);
  }    
  
       
}

void Kpad::setHiddenFilesPolicy(int p) {
  if (p == 1) {
      showHiddenFiles = 1;
      hiddenFilesPolicy->setItemChecked(1,TRUE);
      hiddenFilesPolicy->setItemChecked(2,FALSE);
  }
  if (p == 2) {
        showHiddenFiles = 2;
        hiddenFilesPolicy->setItemChecked(1,FALSE);
        hiddenFilesPolicy->setItemChecked(2,TRUE);
  }    
  
       
}

void Kpad::ToolBarPolicy(int p) {
  if (p == 1) {
      showTB = 1;
      toolBar()->show();
      showToolBar->setItemChecked(1,TRUE);
      showToolBar->setItemChecked(2,FALSE);
  }
  if (p == 2) {
        showTB = 2;
        toolBar()->hide();
        showToolBar->setItemChecked(1,FALSE);
        showToolBar->setItemChecked(2,TRUE);
  }    
  
       
}

void Kpad::openRecentFile(int f){
  load(readRecentFile(f));
}

void Kpad::setWrapMode(int w) {
    int c = tabWidget->count();
    int x = 0;
    if (w == 1) {
           while (x<c) {
              if ( !(QTextEdit *)tabWidget->page(x) )
	        return;

              ((QTextEdit *)tabWidget->page(x))->setWordWrap(QTextEdit::WidgetWidth);
              x++;
	   }
    wrapMode->setItemChecked(1,TRUE);
    wrapMode->setItemChecked(2,FALSE);
    QString s = "Word Wrap On";
    setMessage(s);
    writeWordWrap(w);
    }else{
    if (w == 2) {
        while (x<c) {
              if ( !(QTextEdit *)tabWidget->page(x) )
	        return;

              ((QTextEdit *)tabWidget->page(x))->setWordWrap(QTextEdit::NoWrap);
              x++;
	   }
    wrapMode->setItemChecked(1,FALSE);
    wrapMode->setItemChecked(2,TRUE);
    QString s = "Word Wrap Off";
    setMessage(s);
    writeWordWrap(w);
    }
    }
}


void Kpad::setThisWrapPolicy(int w) {
    int c = tabWidget->count();
    int x = 0;
    if (w == 1) {
           while (x<c) {
              if ( !(QTextEdit *)tabWidget->page(x) )
	        return;

              ((QTextEdit *)tabWidget->page(x))->setWrapPolicy(QTextEdit::AtWordBoundary);
              x++;
	   }
    wrapPolicy->setItemChecked(1,TRUE);
    wrapPolicy->setItemChecked(2,FALSE);
    QString s = "Wrappig set to word boundaries";
    setMessage(s);
    writeWrapPolicy(w);
    }else{
    if (w == 2) {
        while (x<c) {
              if ( !(QTextEdit *)tabWidget->page(x) )
	        return;

              ((QTextEdit *)tabWidget->page(x))->setWrapPolicy(QTextEdit::Anywhere);
              x++;
	   }
    wrapPolicy->setItemChecked(1,FALSE);
    wrapPolicy->setItemChecked(2,TRUE);
    QString s = "Wrappig set to widget edge";
    setMessage(s);
    writeWrapPolicy(w);
    }
    }
}

           
   

void Kpad::writeSettings() {
    KConfig *kconfig = KGlobal::config();
    kconfig->setGroup("General");
    kconfig->writeEntry("Encoding",defaultEncoding);
    kconfig->writeEntry("Directory",dir);
    kconfig->writeEntry("Geometry",size());
    kconfig->writeEntry("NamesCount",recentNamesCount);
    kconfig->writeEntry("BackupPolicy",isBackup);
    kconfig->writeEntry("FilePolicy",showHiddenFiles);
    kconfig->writeEntry("ToolBar",showTB);
    kconfig->writeEntry("MakePolicy",makeOut);
    kconfig->writeEntry("MailPolicy",mailTo);
    kconfig->writeEntry("HighlightPolicy",isHighlight);
    kconfig->sync();
    
  
}

void Kpad::writeFindSettings() {
    KConfig *kconfig = KGlobal::config();
    kconfig->setGroup("Find");
    kconfig->writeEntry("Findcs",fd->case_sensitive());
    kconfig->writeEntry("Findww", fd->word_only());
    kconfig->writeEntry("Findsb", fd->search_backwards());
    kconfig->sync();
}

void Kpad::writeFTPSettings(QString s,QString u,QString p) {
    KConfig *kconfig = KGlobal::config();
    kconfig->setGroup("FTPSettings");
    kconfig->writeEntry("Server",s);
    kconfig->writeEntry("User", u);
    kconfig->writeEntry("Password", p);
    kconfig->sync();
}

void Kpad::readFTPSettings() {
  KConfig *kconfig = KGlobal::config();
  kconfig->setGroup("FTPSettings");
  server = kconfig->readEntry("Server");
  user = kconfig->readEntry("User");
  password = kconfig->readEntry("Password");
}

void Kpad::writeSMTPSettings(QString s,QString u,QString p) {
    KConfig *kconfig = KGlobal::config();
    kconfig->setGroup("SMTPSettings");
    kconfig->writeEntry("Server",s);
    kconfig->writeEntry("From", u);
    kconfig->writeEntry("Reply", p);
    kconfig->sync();
}

void Kpad::readSMTPSettings() {
  KConfig *kconfig = KGlobal::config();
  kconfig->setGroup("SMTPSettings");
  host = kconfig->readEntry("Server");
  from = kconfig->readEntry("From");
  replyTo = kconfig->readEntry("Reply");
}

void Kpad::writeReplaceSettings() {
    KConfig *kconfig = KGlobal::config();
    kconfig->setGroup("Replace");
    kconfig->writeEntry("Replacecs",rd->case_sensitive());
    kconfig->writeEntry("Replaceww", rd->word_only());
    kconfig->writeEntry("Replacesb", rd->search_backwards());
    kconfig->writeEntry("Replacep", rd->_prompt());
    kconfig->sync();
}

void Kpad::writeMailRecipientHistory() {
   KConfig *kconfig = KGlobal::config();
   kconfig->setGroup("MailRecipients");
   QStringList sl = mailDialog->recipientHistory();
   kconfig->writeEntry("StringList",sl,',');
   kconfig->sync();
}

QStringList Kpad::readMailRecipientHistory() {
   KConfig *kconfig = KGlobal::config();
   kconfig->setGroup("MailRecipients");
   QStringList sList = kconfig->readListEntry("StringList",',');
   return sList;
}


void Kpad::writeRecentFile(QString fname) {
  KConfig *config = KGlobal::config();
  config->setGroup("RecentFiles");
  config->writeEntry((recentNames[recentNamesCount]),fname);
  config->sync();
}

QString Kpad::readRecentFile(int i) {
  KConfig *conf = KGlobal::config();
  conf->setGroup("RecentFiles");
  QString fname = conf->readEntry(recentNames[i],"");
 
  return fname;
}

void Kpad::writeFont(QFont f) {
  KConfig *config = KGlobal::config();
  config->setGroup("Font");
  config->writeEntry("thisFont",f);
  config->sync();
}

int Kpad::readWordWrap() {
  KConfig *conf = KGlobal::config();
  conf->setGroup("WordWrap");
  int i = conf->readNumEntry("Wrap",1);
  return i;
}

void Kpad::writeWordWrap(int i) {
  KConfig *conf = KGlobal::config();
  conf->setGroup("WordWrap");
  conf->writeEntry("Wrap",i);
  conf->sync();
}



int Kpad::readWrapPolicy() {
  KConfig *conf = KGlobal::config();
  conf->setGroup("WordWrapPolicy");
  int i = conf->readNumEntry("WrapPolicy",1);
  return i;
}

void Kpad::writeWrapPolicy(int i) {
  KConfig *conf = KGlobal::config();
  conf->setGroup("WordWrapPolicy");
  conf->writeEntry("WrapPolicy",i);
  conf->sync();
}

QFont Kpad::getThisFont() {
  KConfig *config = KGlobal::config();
  config->setGroup("Font");
  QFont defaultFont = QFont("fixed",10);
  QFont m_font = config->readFontEntry("thisFont",&defaultFont);
  return m_font;
}

void Kpad::readFindSettings() {
  KConfig *kconfig = KGlobal::config();
  kconfig->setGroup("Find");
  fd->setFindcs(kconfig->readBoolEntry("Findcs",false));
  fd->setFindww(kconfig->readBoolEntry("Findww",false));
  fd->setFindsb(kconfig->readBoolEntry("Findsb",false));
} 
 
void Kpad::readReplaceSettings() {
  KConfig *kconfig = KGlobal::config();
  kconfig->setGroup("Replace");
  rd->setReplacecs(kconfig->readBoolEntry("Replacecs",false));
  rd->setReplaceww(kconfig->readBoolEntry("Replaceww",false));
  rd->setReplacesb(kconfig->readBoolEntry("Replacesb",false));
  rd->setReplacep(kconfig->readBoolEntry("Replacep",false));
} 
 
 
void Kpad::readSettings() {
  KConfig *kconfig = KGlobal::config();
  kconfig->setGroup("General");
  defaultEncoding = kconfig->readNumEntry("Encoding",1);
  dir = kconfig->readEntry("Directory");
  recentNamesCount = kconfig->readNumEntry("NamesCount",0);
  isBackup = kconfig->readNumEntry("BackupPolicy",1);
  showHiddenFiles = kconfig->readNumEntry("FilePolicy",1);
  showTB = kconfig->readNumEntry("ToolBar",1);
  makeOut = kconfig->readNumEntry("MakePolicy",1);  
  mailTo = kconfig->readNumEntry("MailPolicy",1);
  isHighlight = kconfig->readNumEntry("HighlightPolicy",1);
  QSize size = kconfig->readSizeEntry("Geometry");
  if (!size.isEmpty()) {
    resize(size);
  }else{
    resize(600,440);
  }
}

//  QPalette Kpad::readColorSettings() {
//    KConfig *conf = KGlobal::config();
//    conf->setGroup("Colors");
//    QPalette p;
//    QString bgstring = conf->readEntry("BG");
//    QString fgstring = conf->readEntry("FG");
//    if (bgstring.isNull() == false) {
//      QColor c(bgstring);     
//    p.setColor(QColorGroup::Base,c);
//    }else{
//      p.setColor(QColorGroup::Base,KGlobalSettings::baseColor());
//    }
//    if (fgstring.isNull() == false) {
//      QColor cl(fgstring);   
//    p.setColor(QColorGroup::Text,cl);
//    }else{
//      p.setColor(QColorGroup::Text,KGlobalSettings::textColor());
//    }
//    return p;
//  }

void Kpad::putRecent(QString fnm) {
  
int c = 0;
 for (int k = 0 ; k  < 5 ; k++) {
   QString st = readRecentFile(k); 
   
   if (fnm == st) {
     
	      c++;
   break;
   }
 }
   
       
	      if (c == 0) {      	     
        writeRecentFile(fnm);
        recentNamesCount++;
        if (recentNamesCount == 5)
          recentNamesCount = 0;
	      }
  
      
    for (int i = 0 ; i < 5 ; i++)
      recentFiles->changeItem(i,(readRecentFile(i)));
	
}

/////////////////////////////////////
// save_as a specific encoding
/////////////////////////////////////
void Kpad::save_as(int coding){
    if ( !currentEditor() )
	return;
    QString fn = QFileDialog::getSaveFileName( dir, fileType, this );
    if ( QFileInfo(fn).exists() ) {
      QString s = QFileInfo(fn).fileName();
      QString m = " already exists -- Overwrite? ";
	 QString msg = s.append(m);
       switch ( QMessageBox::warning( this, "KPad",
					msg,
					tr("&Yes"),
					
					tr("&No"),
					0, 0,1) ) {
	case 0: // yes
	    if ( !fn.isEmpty() ) {
	filenames.replace( currentEditor(), fn );
        thisEncoding.replace( currentEditor(), coding );
	//////////////////
        
        ////////////////////////////////////////////////
	fileSave(coding,TRUE);
	tabWidget->setTabLabel( currentEditor(), QFileInfo( fn ).fileName() );
        dir = QFileInfo(fn).filePath();
        
        setCaption(dir);
	putRecent(fn);
    if (isHighlight == 1) {
        if ((fn.endsWith(".cpp")) || (fn.endsWith(".h")) || (fn.endsWith(".c")) || (fn.endsWith(".hh")) || (fn.endsWith(".c++")) || (fn.endsWith(".cxx")) || (fn.endsWith(".hpp")) || (fn.endsWith(".h++")) || (fn.endsWith(".hxx")))
             cppsyntaxHighlighter = new cppSyntaxHighlighter(currentEditor());
        else if (fn.endsWith(".java"))  
             javasyntaxHighlighter = new javaSyntaxHighlighter(currentEditor());
        else if ((fn.endsWith(".py")) || (fn.endsWith(".pyw"))) 
             pythonsyntaxHighlighter = new pythonSyntaxHighlighter(currentEditor());
	else if ((fn.endsWith(".htm")) || (fn.endsWith(".html")) || (fn.endsWith(".dhtml"))) 
             htmlsyntaxHighlighter = new htmlSyntaxHighlighter(currentEditor());
    }
    
	    } // end if 				
	    
	    break;
	case 1: // no
	    				
	    break;
	
	    
	   
       }// end switch
	
    
    }//end if fn exists
else if ( !fn.isEmpty() ) {
	filenames.replace( currentEditor(), fn );
        thisEncoding.replace( currentEditor(), coding );
        
         
	fileSave(coding,TRUE);
	tabWidget->setTabLabel( currentEditor(), QFileInfo( fn ).fileName() );
        dir = QFileInfo(fn).filePath();
        setCaption(dir);
        putRecent(fn);
    if (isHighlight == 1) {
        if ((fn.endsWith(".cpp")) || (fn.endsWith(".h")) || (fn.endsWith(".c")) || (fn.endsWith(".hh")) || (fn.endsWith(".c++"))  || (fn.endsWith(".cxx")) || (fn.endsWith(".hpp")) || (fn.endsWith(".h++")) || (fn.endsWith(".hxx")))
             cppsyntaxHighlighter = new cppSyntaxHighlighter(currentEditor());
        else if (fn.endsWith(".java"))  
             javasyntaxHighlighter = new javaSyntaxHighlighter(currentEditor());
        else if ((fn.endsWith(".py")) || (fn.endsWith(".pyw"))) 
             pythonsyntaxHighlighter = new pythonSyntaxHighlighter(currentEditor());
        else if ((fn.endsWith(".htm")) || (fn.endsWith(".html")) || (fn.endsWith(".dhtml"))) 
             htmlsyntaxHighlighter = new htmlSyntaxHighlighter(currentEditor());
    }
}
   
}

/////////////////////////////////
// open_as as a specific encoding
/////////////////////////////////

void Kpad::open_as(int coding){
  QFileDialog *fileDialog = new QFileDialog( dir, fileType, this, "Open" , TRUE );
  fileDialog->setMode ( QFileDialog::ExistingFile );
  if (showHiddenFiles == 2)
    fileDialog->setShowHiddenFiles(FALSE);
  else
  fileDialog->setShowHiddenFiles(TRUE);
  fileDialog->setViewMode ( QFileDialog::List );
  QString fn;
  if( fileDialog->exec() == QDialog::Accepted ) {
    fn = fileDialog->selectedFile();
    if ( !fn.isEmpty() )
	load( fn,coding );
    thisEncoding.replace( currentEditor(), coding );
    dir = QFileInfo(fn).dirPath();
    setCaption(dir);
    QString str = QString("Read %1 ( %2 )").arg(QFileInfo(fn).filePath())
                       .arg(pE[coding]);
    setMessage(str);
  }
    
    
    
}

void Kpad::setFontDialog()
{
  
       if ( !currentEditor() )
	return;
    
       
       QFont tempfont; 
       int mode = KFontDialog::getFont(tempfont);
       if ( mode == KFontDialog::Accepted ) {
           int c = tabWidget->count();
           int x = 0;
           while (x<c) {
              if ( !(QTextEdit *)tabWidget->page(x) )
	        return;

              ((QTextEdit *)tabWidget->page(x))->setFont(tempfont);
              x++;
              
	   }
	   writeFont(tempfont);
       }
}

void Kpad::load( const QString &fileName )
{

  load(fileName, defaultEncoding);

}

void Kpad::load( const QString &fileName, int code )
{
    if ( !QFile::exists( fileName ) )
	return;
    QTextEdit *editor = new QTextEdit( tabWidget );
  if (isHighlight == 1) {
    if ((fileName.endsWith(".cpp")) || (fileName.endsWith(".h")) || (fileName.endsWith(".c")) || (fileName.endsWith(".hh")) || (fileName.endsWith(".c++")) || (fileName.endsWith(".output"))  || (fileName.endsWith(".cxx")) || (fileName.endsWith(".hpp")) || (fileName.endsWith(".h++")) || (fileName.endsWith(".hxx")))  { 
      cppsyntaxHighlighter = new cppSyntaxHighlighter(editor);
      //QString st = "c++ mode";
      //setMessage(st);
    }
    else if (fileName.endsWith(".java"))  { 
      javasyntaxHighlighter = new javaSyntaxHighlighter(editor);
      //QString st = "java mode";
      //setMessage(st);
    }
    else if ((fileName.endsWith(".py")) || (fileName.endsWith(".pyw"))) {
      pythonsyntaxHighlighter = new pythonSyntaxHighlighter(editor);
    }
    else if ((fileName.endsWith(".htm")) || (fileName.endsWith(".html")) || (fileName.endsWith(".dhtml"))) {
      htmlsyntaxHighlighter = new htmlSyntaxHighlighter(editor);
    }
  }
    editor->setTextFormat( PlainText );
    QFont tempFont = getThisFont();
    editor->setFont(tempFont);
    //****************************************
    //editor->setPalette(readColorSettings());
    //*****************************************
    int i = readWordWrap();
        if (i == 1) {
          editor->setWordWrap(QTextEdit::WidgetWidth);
          
	}else{
	  if (i == 2) {
          editor->setWordWrap(QTextEdit::NoWrap);
          
	  }
	}
    int j = readWrapPolicy();
        if (j == 1) {
          editor->setWrapPolicy(QTextEdit::AtWordBoundary);
          
	}else{
	  if (j == 2) {
          editor->setWrapPolicy(QTextEdit::Anywhere);
          
	  }
	}

    connect(editor,SIGNAL(cursorPositionChanged(int,int)),this,SLOT(updateStatusBar()));
    tabWidget->addTab( editor, QFileInfo( fileName ).fileName() );
    QFile file( fileName );
    if ( !file.open( IO_ReadOnly ) )
	return;
    QTextStream textStream( &file );
    if (code == 0) {
      
      textStream.setEncoding(QTextStream::Unicode);
    } else {
    QTextCodec  *textCodec = QTextCodec::codecForName(pE[code]);
    
    textStream.setCodec(textCodec);
    }
    QString text = textStream.read();
    editor->setText( text );
    tabWidget->showPage( editor );
    
    

    editor->viewport()->setFocus();
    //filenames.replace( editor, fileName );
    QFileInfo(fileName).convertToAbs();
    filenames.replace( editor, fileName );
    QString _temp = QFileInfo(fileName).absFilePath();
    
    file.close();
    //putRecent(temp,true);
    if (isFTPOpen == true)
      isFTPOpen = false;
    else
      putRecent(_temp);   
}

QTextEdit *Kpad::currentEditor() const
{
    if ( tabWidget->currentPage() &&
	 tabWidget->currentPage()->inherits( "QTextEdit" ) )
	return (QTextEdit*)tabWidget->currentPage();
    return 0;	
}

void Kpad::fileNew()
{
    QTextEdit *edit = new QTextEdit( tabWidget );
    edit->setTextFormat( PlainText );
    int i = readWordWrap();
        if (i == 1) {
          edit->setWordWrap(QTextEdit::WidgetWidth);
          
	}else{
	  if (i == 2) {
          edit->setWordWrap(QTextEdit::NoWrap);
          
	  }
	}
    int j = readWrapPolicy();
        if (j == 1) {
          edit->setWrapPolicy(QTextEdit::AtWordBoundary);
          
	}else{
	  if (j == 2) {
          edit->setWrapPolicy(QTextEdit::Anywhere);
          
	  }
	}
    

    
    connect(edit,SIGNAL(cursorPositionChanged(int,int)),this,SLOT(updateStatusBar()));
   
    tabWidget->addTab( edit, tr( "untitled" ) );
    tabWidget->showPage( edit );
    QFont tempFont = getThisFont();
    edit->setFont( tempFont );
    //*************************************
    //edit->setPalette(readColorSettings());
    //**************************************
    edit->viewport()->setFocus();
    setCaption("untitled");
    // filenames.replace( edit, fileName );
}

void Kpad::fileOpen()
{

  QFileDialog *fileDialog = new QFileDialog( dir, fileType, this, "Open" , TRUE );
  fileDialog->setMode ( QFileDialog::ExistingFile );
  if (showHiddenFiles == 2)
    fileDialog->setShowHiddenFiles(FALSE);
  else
  fileDialog->setShowHiddenFiles(TRUE);
  fileDialog->setViewMode ( QFileDialog::List );
  QString fn;
  if( fileDialog->exec() == QDialog::Accepted ) {
    fn = fileDialog->selectedFile();
    if ( !fn.isEmpty() )
 load( fn );
    dir = QFileInfo(fn).dirPath();
    setCaption(dir);
    QString str = QString("Read %1 ( %2 )").arg(QFileInfo(fn).filePath())
              .arg(pE[defaultEncoding]);
    setMessage(str);
    
    
       
  }
}

bool Kpad::fileSave() {
  //cout << " here we are in fileSave \n";
      if ( !currentEditor() )
      return FALSE;  
      if ( thisEncoding.find( currentEditor() ) == thisEncoding.end() ) {
      fileSave(defaultEncoding,FALSE);
      //cout << "ok we send it on as default encoding \n";
      return TRUE;
      }else{
      int i( *thisEncoding.find( currentEditor() ) );
      //cout << "or we send it on as special encoding \n";
      fileSave(i,FALSE);
      return TRUE;
      }
 
}
/////////////////////////////////////////////////////
// this is the save -- it's called by all other saves
/////////////////////////////////////////////////////
bool Kpad::fileSave(int code,bool svAs)
{
  //cout << " now we are just making it to the real fileSave \n";
    if ( !currentEditor() )
      return FALSE;
    if (code == defaultEncoding) { // if the encoding if not default we can't just skip it
      // if this is not from saveAs
      if (svAs == FALSE) {
     if ( !currentEditor()->isModified() ) { // the text has not been changed
     QString str = "(No changes need to be saved)";
     setMessage(str);
     return FALSE;
     }
      } // end if saveAs == FALSE
    } // end if code == default
    if ( filenames.find( currentEditor() ) == filenames.end() ) {
      // cout << " here we ship it over to fileSaveAs() \n";
 fileSaveAs();
        return TRUE;
    } else { // ok here we do the write
        QFile file( *filenames.find( currentEditor() ) );
        if ((isBackup == 1) && (svAs == FALSE)) {// if it's from a saveAs no need to do the backup
          QString fileName = QFileInfo(file).fileName();
          back = doBackup(fileName);
	  //     if  (back < 0 )
     //cout << "Couldn't  backup file \n";
         
            
	  
	}// that's the end of the if svAs check
	
	if ( !file.open( IO_WriteOnly ) )
	  return FALSE;
        
        QTextStream ts( &file );
	if (code == 0) {//have to do utf16 this way
	 
          ts.setEncoding(QTextStream::Unicode);
	} else {//otherwise
        QTextCodec *textCodec = QTextCodec::codecForName(pE[code]);
        
	
        ts.setCodec(textCodec);
	}
	ts << currentEditor()->text();
        currentEditor()->setModified(false);
        QString str = QString("Wrote %1 ( %2 )").arg(QFileInfo(file).filePath())
                       .arg(pE[code]);
        setMessage(str);
        file.close();
        if ((isBackup == 1) && (svAs == FALSE)) { // just like before can't close these if it's a svAs
        if (back == 0) {// so we did a backup and it returned OK
        ::close(read);
        ::close(write);
	}
	}
              
        return TRUE;
	
       
    }
}

    
        int Kpad::doBackup(QString &_fileName) {
        
        struct stat buf_stat;
        off_t offset = 0;
        QCString cfileName = QFile::encodeName(_fileName);
        QCString cfileNameBK = cfileName + "~" ;
        const char *filename = cfileName.data();
        const char *filenameBK = cfileNameBK.data();
        read = open (filename,O_RDONLY);
        if (read < 0)
            return -1;
  
        fstat ( read, &buf_stat );
        write = open (filenameBK, O_WRONLY | O_CREAT , buf_stat.st_mode);
        if (write < 0) {
   ::close(read);
          return -1;
        }
        
        sendfile (write,read,&offset,buf_stat.st_size);
      
  
        
        return 0;  

      }



///////////////////////////
//this is the regular SaveAs
//////////////////////////
void Kpad::fileSaveAs()
{
  //cout << "this is in fileSaveAs \n";
   if ( !currentEditor() )
  return;
      QString fn = QFileDialog::getSaveFileName( dir, fileType, this );
      //  QFileDialog *fileDialog = new QFileDialog( dir, tr( "All Files (*)" ), this, "Save As" , TRUE );
//      fileDialog->setMode ( QFileDialog::ExistingFile );
//      if (showHiddenFiles == 2)
//        fileDialog->setShowHiddenFiles(FALSE);
//      else
//      fileDialog->setShowHiddenFiles(TRUE);
//      fileDialog->setViewMode ( QFileDialog::List );
//      QString fn;
//      cout << "this is right before the save dialog is called \n";
//      if( fileDialog->exec() == QDialog::Accepted ) {
//        fn = fileDialog->selectedFile();
    if ( QFileInfo(fn).exists() ) {
      QString s = QFileInfo(fn).fileName();
      QString m = " already exists -- Overwrite? ";
  QString msg = s.append(m);
  //cout << "here we call the message box \n";
       switch ( QMessageBox::warning( this, "KPad",
     msg,
     tr("&Yes"),
     
     tr("&No"),
          0,
     0,1) ) {
 case 0: // yes
   // cout << "you just chose yes to overwrite \n";
     if ( !fn.isEmpty() ) {
	filenames.replace( currentEditor(), fn );
        
	fileSave(defaultEncoding,TRUE);
	tabWidget->setTabLabel( currentEditor(), QFileInfo( fn ).fileName() );
        dir = QFileInfo(fn).filePath();
        setCaption(dir);
        putRecent(fn);
     if (isHighlight == 1) {
        if ((fn.endsWith(".cpp")) || (fn.endsWith(".h")) || (fn.endsWith(".c")) || (fn.endsWith(".hh")) || (fn.endsWith(".c++"))   || (fn.endsWith(".cxx")) || (fn.endsWith(".hpp")) || (fn.endsWith(".h++")) || (fn.endsWith(".hxx")))
             cppsyntaxHighlighter = new cppSyntaxHighlighter(currentEditor());
        else if (fn.endsWith(".java"))   
             javasyntaxHighlighter = new javaSyntaxHighlighter(currentEditor());
        else if ((fn.endsWith(".py")) || (fn.endsWith(".pyw"))) 
             pythonsyntaxHighlighter = new pythonSyntaxHighlighter(currentEditor());
        else if ((fn.endsWith(".htm")) || (fn.endsWith(".html")) || (fn.endsWith(".dhtml"))) 
             htmlsyntaxHighlighter = new htmlSyntaxHighlighter(currentEditor());
     }
    
	    } // end if 				
	    
	    break;
	case 1: // no
	    				
	    break;
	
	    
	   
       }// end switch
	
    
    }//end if fn exists
    //if fn doesn't already exist just go ahead and write it
else if ( !fn.isEmpty() ) {
	filenames.replace( currentEditor(), fn );
        

	fileSave(defaultEncoding,TRUE);
	tabWidget->setTabLabel( currentEditor(), QFileInfo( fn ).fileName() );
        dir = QFileInfo(fn).filePath();
        setCaption(dir);
        putRecent(fn);
     if (isHighlight == 1) {
        if ((fn.endsWith(".cpp")) || (fn.endsWith(".h")) || (fn.endsWith(".c")) || (fn.endsWith(".hh")) || (fn.endsWith(".c++"))   || (fn.endsWith(".cxx")) || (fn.endsWith(".hpp")) || (fn.endsWith(".h++")) || (fn.endsWith(".hxx")))
             cppsyntaxHighlighter = new cppSyntaxHighlighter(currentEditor());
        else if (fn.endsWith(".java"))   
             javasyntaxHighlighter = new javaSyntaxHighlighter(currentEditor());
        else if ((fn.endsWith(".py")) || (fn.endsWith(".pyw"))) 
             pythonsyntaxHighlighter = new pythonSyntaxHighlighter(currentEditor());
        else if ((fn.endsWith(".htm")) || (fn.endsWith(".html")) || (fn.endsWith(".dhtml"))) 
             htmlsyntaxHighlighter = new htmlSyntaxHighlighter(currentEditor());
     }
}
    //  }// use this for the more complex dialog box
   
}

  void Kpad::filePrint()
  {
        if ( !currentEditor() )
    	return;
    #ifndef QT_NO_PRINTER
        QPrinter printer;
        printer.setFullPage(TRUE);
        if ( printer.setup( this ) ) {
    	QPainter p( &printer );
    	// Check that there is a valid device to print to.
    	if ( !p.device() ) return;  	
    	QPaintDeviceMetrics metrics( p.device() );
    	int dpix = metrics.logicalDpiX();
    	int dpiy = metrics.logicalDpiY();
    	const int margin = 72; // pt
    	QRect body( margin * dpix / 72, margin * dpiy / 72,
    		    metrics.width() - margin * dpix / 72 * 2,
    		    metrics.height() - margin * dpiy / 72 * 2 );
    	QFont font( currentEditor()->QWidget::font() );
     	font.setPointSize( 10 ); // we define 10pt to be a nice base size for printing
    	QSimpleRichText richText( currentEditor()->text(), font,
    				  currentEditor()->context(),
    				  currentEditor()->styleSheet(),
    				  currentEditor()->mimeSourceFactory(),
    				  body.height() );
    	richText.setWidth( &p, body.width() );
    	QRect view( body );
    	int page = 1;
    	do {
    	    richText.draw( &p, body.left(), body.top(), view, colorGroup() );
    	    view.moveBy( 0, body.height() );
    	    p.translate( 0 , -body.height() );
    	    p.setFont( font );
    	    p.drawText( view.right() - p.fontMetrics().width( QString::number( page ) ),
    			view.bottom() + p.fontMetrics().ascent() + 5, QString::number( page ) );
    	    if ( view.top()  >= body.top() + richText.height() )
    		break;
    	    printer.newPage();
    	    page++;
    	} while (TRUE);
        }
          #endif
  }

void Kpad::fileClose()
{
 if ( !currentEditor() )
	return;
 

    QFile file( *filenames.find( currentEditor() ) );
    if ( currentEditor()->isModified() ) { // the text has been changed
      int x = tabWidget->currentPageIndex();
      
      QString msg = QString("Save Changes to %1 at Tab %2 ?").arg(tabWidget->label(x))
	.arg(QString::number(x+1,10));
      
	switch ( QMessageBox::warning( this, "KPad",
					msg,
					tr("&Yes"),
					tr("&No"),
					tr("Cancel"),
					0, 2) ) {
	case 0: // yes
	    if ( fileSave() )
		delete currentEditor();
	    if ( currentEditor() ) 
	currentEditor()->viewport()->setFocus();
        break;
					
	case 1: // no
	    delete currentEditor();
    if ( currentEditor() )
	currentEditor()->viewport()->setFocus();				
	    break;
	case 2: // cancel
	    
	    break;
	}// end switch
	
    }// end if is modified
   // OK if it hasen't changed
    else {
        delete currentEditor();
        if ( currentEditor() )
	currentEditor()->viewport()->setFocus();
    }				
	
}

void Kpad::fileExit()
{
    bool accept = true;
    
    QString msg;
    int c = tabWidget->count();
    int x = 0;
    while (x<c) {
 if ( !(QTextEdit *)tabWidget->page(x) )
	return;
   


    if (( (QTextEdit *)tabWidget->page(x))->isModified() ) { // the text has been changed
      
      msg = QString("Save Changes to %1 at Tab %2 ?").arg(tabWidget->label(x))
	.arg(QString::number(x+1,10));
	switch ( QMessageBox::warning( this, "KPad",
					msg,
					tr("&Yes"),
					tr("&No"),
					tr("Cancel"),
					0, 2) ) {
	case 0: // yes
	  tabWidget->setCurrentPage(x);
	    if ( fileSave() )
	      break;   
	    else
	      
	    break;
	case 1: // no
	    
	    break;
	case 2: // cancel
	    
	    break;
	}// end switch
    }// end if is modified
    if (accept)
    x = x+1;
    else
      break;
    }// end while
    if (accept) {
      writeSettings();
      qApp->quit();
    }
}

void Kpad::editUndo()
{
    if ( !currentEditor() )
	return;
    currentEditor()->undo();
}

void Kpad::editRedo()
{
    if ( !currentEditor() )
	return;
    currentEditor()->redo();
}

void Kpad::editCut()
{
    if ( !currentEditor() )
	return;
    currentEditor()->cut();
}

void Kpad::editCopy()
{
    if ( !currentEditor() )
 return;
    currentEditor()->copy();
}

void Kpad::editPaste()
{
    if ( !currentEditor() )
 return;
    currentEditor()->paste();
}

void Kpad::selectAll() {
  if ( !currentEditor() )
    return;
  currentEditor()->selectAll(TRUE);
}


void Kpad::editorChanged( QWidget * )
{
    if ( !currentEditor() )
 return;
    updateStatusBar();
    if ( filenames.find( currentEditor() ) == filenames.end() ) {
      setCaption("untitled");
    }else{
    QFile file( *filenames.find( currentEditor() ) );
    QString s  = QFileInfo(file).filePath();
    setCaption(s);
    }
        
}


void Kpad::closeEvent( QCloseEvent *event ) {
  
  
  //cout << " Within the close event \n"; 
    bool accept = true;
      int c = tabWidget->count();
      int x = 0;
    
      QString msg;
      while (x<c) {
        if ( !(QTextEdit *)tabWidget->page(x) )
        return;
   


      if (( (QTextEdit *)tabWidget->page(x))->isModified() ) { // the text has been changed
      
         msg = QString("Save Changes to %1 at Tab %2 ?").arg(tabWidget->label(x))
    .arg(QString::number(x+1,10));
   switch ( QMessageBox::warning( this, "KPad",
       msg,
       tr("&Yes"),
       tr("&No"),
       tr("Cancel"),
       0, 2) ) {
   case 0: // yes //enter
   // cout << " You just clicked yes \n";
            tabWidget->setCurrentPage(x);
     //cout << " after setCurrentPage(x) \n";
     if ( fileSave() ) {
       //cout << " after if fileSave() back in the close event\n";
       //event->accept();
                  break;
	    }
  	    else
  	      //event->ignore();
  	    break;
  	case 1: // no
  	  //event->accept();
  	    break;
  	case 2: // cancel //esc
  	  // event->ignore();
  	  accept = false;
  	    break;
           
  	}// end switch
      }// end if is modified
      if (accept)    
      x = x+1;
      else
        break;
      }// end while
      if (accept) {
        writeSettings();
      event->accept();
      }else
        event->ignore();
      
  }//end method

























