




#include <kmainwindow.h>
#include <qmap.h>
#include "cppSyntaxHighlighter.h"
#include "javaSyntaxHighlighter.h"
#include "pythonSyntaxHighlighter.h"
#include "htmlSyntaxHighlighter.h"
#include "MyWidget.h"
#include "myFindDialog.h"
#include "myGoToDialog.h"
#include "myReplaceDialog.h"
#include "myRenameDialog.h"
#include "myMailDialog.h"
#include "myFTP.h"
#include "mySMTP.h"
#include "myHTTP.h"
#include "FTPListDialog.h"
#include "FTPSettingsDialog.h"
#include "SMTPSettingsDialog.h"
#include <qtextedit.h>
//#include <features.h>
//#include <qfile.h>
//#include <kstdaccel.h>
class KSpell;
class KAction;
class QTabWidget;
class QTextEdit;
//class QSyntaxHighlighter;
//class QFont;

class Kpad : public KMainWindow
{
    Q_OBJECT

public:
    Kpad( MyWidget *parent = 0, const char *name = 0 );
      ~Kpad();
      
      
private:
      KSpell *kspell;
      myFindDialog *fd;
      myGoToDialog *gd;
      myReplaceDialog *rd;
      myFTP *ftp_session;
      mySMTP *smtp_session;
      myHTTP *http_session;
      FTPListDialog *listDialog;
      myRenameDialog *renameDialog;
      myMailDialog *mailDialog;
      FTPSettingsDialog *settingsDialog;
      SMTPSettingsDialog *mailSettingsDialog;
      cppSyntaxHighlighter *cppsyntaxHighlighter;
      javaSyntaxHighlighter *javasyntaxHighlighter;  
      pythonSyntaxHighlighter *pythonsyntaxHighlighter;
      htmlSyntaxHighlighter *htmlsyntaxHighlighter;
    void createFileMenu();
    void createEditMenu();
    void createViewMenu();
    void createOptionsMenu();
    void createToolsMenu();
    void createEmailMenu();
    void createSpellingMenu();
    void createFTPMenu();
    void createStatusBar();
    void createToolBar();
    void load( const QString &f );
    void load( const QString &f,int );
    QTextEdit *currentEditor() const;
    void setMessage(const QString &string);
    bool fileSave(int,bool);
    void readSettings();
    void writeSettings();
    QFont getThisFont();
    void writeFont(QFont f);
    int readWordWrap();
    void writeWordWrap(int);
    int readWrapPolicy();
    void writeWrapPolicy(int);
    int readBackupPolicy();
    void writeBackupPolicy(int);
    void writeRecentFile(QString fname);
    QString readRecentFile(int i);
    int doBackup(QString &_fileName);     
    //QPalette readColorSettings();
    void putRecent(QString fnm);
    int spawn (char* program, char** arg_list);
    int doSearch(QString,bool,bool,bool);
    int doReplace(QString,QString, bool, bool ,bool, bool);
    void readFindSettings();
    void readReplaceSettings();
    QStringList readMailRecipientHistory();
    void writeMailRecipientHistory();
    void writeFTPSettings(QString s,QString u,QString p); 
    void readFTPSettings();
    void writeSMTPSettings(QString,QString,QString); 
    void readSMTPSettings();       
    int read;
    int write; 
    int back; 

private slots:
    void spell_check ( KSpell *);
    void spell_done(const QString&);
    void spell_corrected (const QString &, const QString &, unsigned int);
    void timer();    
    void fileNew();
    void fileOpen();
    bool fileSave();
    void fileSaveAs();
     void filePrint();
    void fileClose();
    void fileExit();
    void setFontDialog();
    void editUndo();
    void editRedo();
    void editCut();
    void editCopy();
    void editPaste();
    void selectAll();
    void editorChanged( QWidget * );
    void save_as(int);
    void open_as(int);
    void updateStatusBar();
    void setDefaultEncoding(int);
    void setWrapMode(int);
    void setThisWrapPolicy(int);
    // void setBKColorDialog();
    //void setFGColorDialog();
    void Zoom_In();
    void Zoom_Out();   
    void _Make();
    //void _Term();
    void _Find();
    void _Replace();
    void _GoTo();
    void setBackupPolicy(int);
    void setMakePolicy(int);
    void setMailPolicy(int);
    void openRecentFile(int);
    void setHiddenFilesPolicy(int);
    void ToolBarPolicy(int);
    void _find();
    void _goto();
    void _replace();
    void writeFindSettings();
    void writeReplaceSettings();
    void threadListener();
    void FTP_DoLogon();
    void FTP_DoLogoff();
    void FTP_DoList();
    void FTP_OpenFile();
    void FTP_SaveFile();
    void FTP_SaveFileAs();
    void FTP_CD();
    void FTP_PWD();
    void FTP_RM();
    void FTP_MV();
    void FTP_RMDIR();
    void FTP_MKDIR();
    void FTP_Settings();
    void FTP_SETTINGS();
    void FTP_DOWNLOAD();
    void FTP_UPLOAD();    
    void ftp_open_get(const QString &qstring);
    void ftp_remove(const QString &qstring);
    void ftp_open_get();
    void ftp_remove();
    void ftp_download();
    void ftp_download(const QString &qstring);
    void do_ftp_mv();
    void SEND_MAIL();
    void _Email();
    void EmailSettings();
    void SMTP_SETTINGS();
    void spellcheck();
    void spellcheckConfig();
    void HTTP_Open();
    void rehighlight_this();
    void setHighlightPolicy(int p);
    void Date_Time();
private:
    QTabWidget *tabWidget;
    QMap<QTextEdit*, QString> filenames;
    QString dir;
    //  KAccel *keyAccel;
    QString server;
    QString user;
    QString password; 
    QString host;
    QString from;
    QString replyTo;
 protected:
    void closeEvent( QCloseEvent * );


};
// non-member
struct thread_parameters {
    QString drnm;
};

void* doPipe(void* parameters);












