#include "myFindDialog.h"
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>

bool findcs = false;
bool findww = false;
bool findsb = false;
      

myFindDialog::myFindDialog( QWidget * parent , const char * name ) :
      QDialog(parent, name, FALSE)
     
  {
     
      init();
      // setOptions();
  }
  

  
  myFindDialog::~myFindDialog()
  {
      
  }
  
  
 void myFindDialog::init()
 {
    
     QVBoxLayout *contentPane;
      QGridLayout *optionsPane;
      QGridLayout *buttonPane; 
     
     contentPane  = new QVBoxLayout(this);
     
     contentPane->setMargin( 0 );
      findGrp = new QGroupBox(0, Qt::Vertical, "Find", this);
     
     findLayout = new QGridLayout(findGrp->layout());
      
     
 
     findLabel = new QLabel("Text to find:", findGrp);
     find = new QLineEdit(this);
     
     
     findLayout->addWidget(findLabel, 0, 0);
   
     findLayout->addMultiCellWidget(find, 1, 1, 0, 1);
      
     contentPane->addWidget(findGrp);
 
    
     optionGrp = new QGroupBox(0, Qt::Vertical,"Options", this);
          optionsPane = new QGridLayout(optionGrp->layout());
     
     caseSensitive = new QCheckBox("C&ase sensitive", optionGrp);
      wholeWordsOnly = new QCheckBox("&Whole words only", optionGrp);
      backwards = new QCheckBox("&Search backwards" , optionGrp);
     optionsPane->addWidget(caseSensitive,0,0);
      optionsPane->addWidget(wholeWordsOnly,0,1);
      optionsPane->addWidget(backwards,1,0);
     contentPane->addWidget(optionGrp);
     // buttonPane = new QHBoxLayout(contentPane->layout());
     buttonPane = new QGridLayout(contentPane->layout());
    
     QPushButton *findNext, *quit;
     findNext = new QPushButton( "Find Next", this );
    
     
        quit = new QPushButton( "Quit", this );
       
        connect( findNext, SIGNAL(clicked()),parent(), SLOT(_find()) );
        connect( quit, SIGNAL(clicked()), SLOT(slotQuit()) );
        connect( quit, SIGNAL(clicked()),parent(), SLOT(writeFindSettings()) ); 
	buttonPane->addWidget(findNext,0,2);
        buttonPane->addWidget(quit,0,3);   
       
    
 }

 
bool myFindDialog::case_sensitive() {
  if (caseSensitive->isChecked()) {
    findcs = true;
    return true;
  }
  else {
    findcs = false;
    return false;
  }
}
 
bool myFindDialog::word_only() {
  if (wholeWordsOnly->isChecked()) {
    findww = true;
    return true;
  }
  else {
    findww = false;
    return false;
  }
}

bool myFindDialog::search_backwards() {
  if (backwards->isChecked()) {
    findsb = true;
    return true;
  }
  else {
    findsb = false;
    return false;
  }
}

void myFindDialog::setFindcs(bool b) {
  findcs = b;
}

void myFindDialog::setFindww(bool b) {
  findww = b;
}

void myFindDialog::setFindsb(bool b) {
  findsb = b;
}


QString myFindDialog::pattern() 
 {
   QString line = find->text(); 
    return line;
 }
 
 
 
 void myFindDialog::setOptions()
 {
     caseSensitive->setChecked(findcs);
     wholeWordsOnly->setChecked(findww);
     backwards->setChecked(findsb);
 }
 
// void myFindDialog::changed(const QString & s) {
// findString = find->text();
//}
 
//void myFindDialog::slotFind()
//{

//    Nothing to find?
//  if  (pattern().isEmpty())
// {
//       KMessageBox::error(this, i18n("You must enter some text to search for."));
//     return;
// }
 
     
     
//}
 
void myFindDialog::slotQuit() {
  close();
}

void myFindDialog::closeEvent( QCloseEvent *event ) {
  event->accept();
}













