#include "mySMTP.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <ctype.h>
#include <pwd.h>
#include <unistd.h>
#include <iostream>
using namespace std;

  
  static char *host;
  static const int   mailport   = 25;
  static char *mailhost;
  static char *from_addr;
  static char *cc_addr;
  static char *err_addr;
  static FILE *sfp;
  static FILE *rfp;

mySMTP::mySMTP() {
  
}


mySMTP::~mySMTP() {
}

/*
**  examine message from server 
*/
int  mySMTP::get_response()
{
    char buf[BUFSIZ];
    char nCode[4]={0};
    while (fgets(buf, sizeof(buf), rfp)) {
        buf[strlen(buf)-1] = 0;
        printf("%s --> %s\n", host, buf);
        if (!isdigit(buf[0]) || buf[0] > '3') {
	  //exit(1);
          return 1;
        }
        if (buf[4] != '-')
            break;
    }
    strncpy(nCode, buf, 3);
    nCode[3] = '\0';
    return (atoi(nCode));
}

/*
**  say something to server and check the response
*/
void mySMTP::chat(char *fmt, ...)
{
    va_list ap;

    va_start(ap, fmt);
    vfprintf(sfp, fmt, ap);
    va_end(ap);
  
    va_start(ap, fmt);
    printf("%s <-- ", host);
    vprintf(fmt, ap);
    va_end(ap);

    fflush(sfp);
    //get_response();
}



/*
**  main procedure
*/


int mySMTP::DoMail(char *recipient, char *subject, char *msgBody, char *reply_addr)
{
    
    char buf[BUFSIZ];
    char my_name[BUFSIZ];
    struct sockaddr_in sin;
    struct hostent *hp;
    //struct servent *sp;
    //int c;
    int s;
    int r;
    //int i;
    struct passwd *pwd;
    char *cp;
    int response;
    

    /*
     *  Determine SMTP server
     */
    if (mailhost == NULL) {
      if ((cp = getenv("SMTPSERVER")) != NULL) {
            mailhost = cp;
            host = mailhost;
      }
        else {
	  char hst[] = "localhost";
            mailhost = hst;
            host = mailhost;
	}
    }

    /*
     *  Find out my own host name for HELO; 
     *  if possible, get the FQDN.
     */
    if (gethostname(my_name, sizeof(my_name) - 1) < 0) {
        return 1;
    }
    if ((hp = gethostbyname(my_name)) == NULL) {
        return 1;
    }
    strcpy(my_name, hp->h_name);

    /*
     *  Determine from address if not specified.
     */
    if (from_addr == NULL) {
        if ((pwd = getpwuid(getuid())) == 0) {
            sprintf(buf, "userid-%d@%s", getuid(), my_name);
        } else {
            sprintf(buf, "%s@%s", pwd->pw_name, my_name);
        }
        from_addr = strdup(buf);
    } 

    /*
     *  Connect to smtp daemon on mailhost.
     */
    
  
    if ((hp = gethostbyname(mailhost)) == NULL) {
    
        return 1;
    }
    cout << "server is \n" << hp;
    if (hp->h_addrtype != AF_INET) {
        cout << "dies due to AF_INET check \n";
        return 1;
    }
    memset((char *)&sin, 0, sizeof(sin));
    memcpy((char *)&sin.sin_addr, hp->h_addr, hp->h_length);
    sin.sin_family = hp->h_addrtype;
    sin.sin_port = htons(mailport);
    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        return 1;
    }
    if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
        return 1;
    }
    if ((r = dup(s)) < 0) {
        return 1;
    }
    if ((sfp = fdopen(s, "w")) == 0) {
        return 1;
    }
    if ((rfp = fdopen(r, "r")) == 0) {
        return 1;
    }

    /* 
     *  Give out SMTP headers.
     */
    response = get_response(); /* banner */
    cout << "thinks response is " << response << "\n";
    if (response == 1) {
      cout << "dies due to returned 1 \n";
      return 1;
    }
    else {
      if (response != 220) {
        cout << "dies due to response != 220 \n";
        cout << "thinks response is " << response << "\n";
        return 1;
      }
    }
    char _h[] = "HELO %s\r\n";
    char *helo = _h;
    chat(helo, my_name);
    response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 250) {
        return 1;
      }
    }
    char _f[] = "MAIL FROM: <%s>\r\n";
    char *frm = _f;
    chat(frm, from_addr);
    response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 250) {
        return 1;
      }
    }
    char _r[] = "RCPT TO: <%s>\r\n";
    char *rcp = _r;
    chat(rcp, recipient);
    response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 250) {
        return 1;
      }
    }
    if (cc_addr) {
      char cc_r[] = "RCPT TO: <%s>\r\n";
      char *cc_rcp = cc_r;
      chat(cc_rcp, cc_addr);
      response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 250) {
        return 1;
      }
    }
    }
	char _d[] = "DATA\r\n";
        char *dat = _d;
    chat(dat);
    response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 354) {
        return 1;
      }
    }
    /* 
     *  Give out Message header. 
     */
    fprintf(sfp, "From: %s\r\n", from_addr);
    if (subject)
        fprintf(sfp, "Subject: %s\r\n", subject);

    if (reply_addr)
        fprintf(sfp, "Reply-To: %s\r\n", reply_addr);
    if (err_addr)
        fprintf(sfp, "Errors-To: %s\r\n", err_addr);
    if ((pwd = getpwuid(getuid())) == 0) {
        fprintf(sfp, "Sender: userid-%d@%s\r\n", getuid(), my_name);
    } else {
        fprintf(sfp, "Sender: %s@%s\r\n", pwd->pw_name, my_name);
    }

    fprintf(sfp, "To: %s", recipient);
  
    fprintf(sfp, "\r\n");
    if (cc_addr)
        fprintf(sfp, "Cc: %s\r\n", cc_addr);

  
    fprintf(sfp, "\r\n");

    /* 
     *  Give out Message body.
     */
    
    fprintf(sfp, "%s\r\n", msgBody);
    fprintf(sfp, "..\r\n");
	
    /* 
     *  Give out SMTP end.
     */
    char _dot[] = ".\r\n";
    char *end_dot = _dot;
    chat(end_dot);
    response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 250) {
        return 1;
      }
    }
    char _qu[] = "QUIT\r\n";
    char *_quit = _qu;
    chat(_quit);
    response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 221) {
        return 1;
      }
    }
    /* 
     *  We did it ! ...
     */
    return 0;
}


int mySMTP::DoMail(char *recipient, char *subject, char *msgBody, char *mailhost, char *from_addr, char *reply_addr)
{
    host = mailhost;
    //char buf[BUFSIZ];
    char my_name[BUFSIZ];
    struct sockaddr_in sin;
    struct hostent *hp;
    //struct servent *sp;
    //int c;
    int s;
    int r;
    //int i;
    struct passwd *pwd;
    // char *cp;
    int response;
    /*
     *  Find out my own host name for HELO; 
     *  if possible, get the FQDN.
     */
    if (gethostname(my_name, sizeof(my_name) - 1) < 0) {
        return 1;
    }
    if ((hp = gethostbyname(my_name)) == NULL) {
        return 1;
    }
    strcpy(my_name, hp->h_name);

  
    /*
     *  Connect to smtp daemon on mailhost.
     */
  
    if ((hp = gethostbyname(mailhost)) == NULL) {
      
        return 1;
    }
    cout << "server is \n" << hp;
    if (hp->h_addrtype != AF_INET) {
      cout << "dies due to AF_INET check \n";
        return 1;
    }
    memset((char *)&sin, 0, sizeof(sin));
    memcpy((char *)&sin.sin_addr, hp->h_addr, hp->h_length);
    sin.sin_family = hp->h_addrtype;
    sin.sin_port = htons(mailport);
    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        return 1;
    }
    if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
        return 1;
    }
    if ((r = dup(s)) < 0) {
        return 1;
    }
    if ((sfp = fdopen(s, "w")) == 0) {
        return 1;
    }
    if ((rfp = fdopen(r, "r")) == 0) {
        return 1;
    }

    /* 
     *  Give out SMTP headers.
     */
     cout << "get response \n";
    response = get_response();//banner 
    cout << "thinks response is " << response << "\n";
    if (response == 1) {
       cout << "dies due to response = 1 \n";
      return 1;
    }
    else {
      if (response != 220) {
         cout << "dies due to response !=220 \n";
        return 1;
      }
    }
    char _h[] = "HELO %s\r\n";
    char *helo = _h;
    chat(helo, my_name);
    response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 250) {
        return 1;
      }
    }
    char _f[] = "MAIL FROM: <%s>\r\n";
    char *frm = _f;
    chat(frm, from_addr);
    response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 250) {
        return 1;
      }
    }
    char _r[] = "RCPT TO: <%s>\r\n";
    char *rcp = _r;
    chat(rcp, recipient);
    response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 250) {
        return 1;
      }
    }
    if (cc_addr) {
      char cc_r[] = "RCPT TO: <%s>\r\n";
      char *cc_rcp = cc_r;
      chat(cc_rcp, cc_addr);
      response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 250) {
        return 1;
      }
    }
    }
	char _d[] = "DATA\r\n";
        char *dat = _d;
    chat(dat);
    response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 354) {
        return 1;
      }
    }
    /* 
     *  Give out Message header. 
     */
    fprintf(sfp, "From: %s\r\n", from_addr);
    if (subject)
        fprintf(sfp, "Subject: %s\r\n", subject);

    if (reply_addr)
        fprintf(sfp, "Reply-To: %s\r\n", reply_addr);
    if (err_addr)
        fprintf(sfp, "Errors-To: %s\r\n", err_addr);
    if ((pwd = getpwuid(getuid())) == 0) {
        fprintf(sfp, "Sender: userid-%d@%s\r\n", getuid(), my_name);
    } else {
        fprintf(sfp, "Sender: %s@%s\r\n", pwd->pw_name, my_name);
    }

    fprintf(sfp, "To: %s", recipient);
  
    fprintf(sfp, "\r\n");
    if (cc_addr)
        fprintf(sfp, "Cc: %s\r\n", cc_addr);

  
    fprintf(sfp, "\r\n");

    /* 
     *  Give out Message body.
     */
    
    fprintf(sfp, "%s\r\n", msgBody);
    fprintf(sfp, "..\r\n");
	
    /* 
     *  Give out SMTP end.
     */
    char _dot[] = ".\r\n";
    char *end_dot = _dot;
    chat(end_dot);
    response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 250) {
        return 1;
      }
    }
    char _qu[] = "QUIT\r\n";
    char *_quit = _qu;
    chat(_quit);
    response = get_response(); 
    if (response == 1) {
      return 1;
    }
    else {
      if (response != 221) {
        return 1;
      }
    }

    /* 
     *  We did it ! ...
     */
    return 0;
}
















