

#include <iostream>
#include <qvaluevector.h>
#include <qregexp.h>
#include <qstring.h>
#include <qstringlist.h>
#include "pythonSyntaxHighlighter.h"


QString pykeywords[28] = { "and", "assert", "break", "class", "continue", "def", "del", "elif", "else", "except", "finally", "for", "from","global", "if", "import","in","is","lambda","not",  "or","pass", "print","raise", "return",  "try", "while" , "__init__" };

QChar pysymbols[6] = { '(', ')', '{', '}', '[', ']' };

      
     
QValueVector<int> pysquoteStart(1);
QValueVector<int> pysquoteEnd(1);
QValueVector<int> pydquoteStart(1);
QValueVector<int> pydquoteEnd(1);     

bool pytempFlag = false;
int pytempPlace = 0;
//int endStateOfLastPara;
pythonSyntaxHighlighter::pythonSyntaxHighlighter(QTextEdit *textEdit) 
  : QSyntaxHighlighter(textEdit) {
  return;
}



pythonSyntaxHighlighter::~pythonSyntaxHighlighter(void) {
  return;
}

int pythonSyntaxHighlighter::highlightParagraph(const QString &text, 
					     int endStateOfLastPara) {
  
  // parse lines first
 
  QStringList lines = QStringList::split('\n', text, TRUE);
  for(unsigned int i=0; i<lines.count(); i++) {
    
    start=0;
    place = 0;
    pysquoteStart.clear();
    pysquoteEnd.clear();
    pydquoteStart.clear();
    pydquoteEnd.clear();
    pysquoteStart.push_back(0);
    pysquoteEnd.push_back(0);
    pydquoteStart.push_back(0);
    pydquoteEnd.push_back(0);
    sQuoteNum = 0;
    dQuoteNum = 0;
    commentStart = 0;
    commentFlag = false;
    skipSQuoteFlag = false;
    skipDQuoteFlag = false;
    
    QString line = lines[i];
    if(line.isNull() || line.isEmpty()) {
      
      continue;
      
    }
    pytempPlace = 0;
    pytempFlag = false;
    squoteFlag = false;
    dquoteFlag = false;    
    
    int lineLength = line.length() + 1;
   
      setFormat((0), lineLength, QColor(0, 0, 0));
  
      // I'm not even going to try to deal with python block comment ! 
      // it's just too weird
      
    // now to examine this line in an inner loop
    for(int i=0; i<lineLength-1; i++) {
      // no need to examine this line more if in a line comment
      
      QChar a = line[i];
      // QChar b = line[(i+1)];
     
   
      
	// first check if we have a line comment
	if (a == '#')  {
	  setFormat((i), lineLength, QColor(0, 200, 155));
	  commentFlag = true;
	  commentStart = i;
	  // if we are in a line comment 
	  // no need to look at anymore chars in this line
	  break;
	}
         
        
	// look for the second quote mark first if we have one already
	if ((dquoteFlag == true) && (a == '"')) {
	  setFormat((pydquoteStart[dQuoteNum - 1]), ((i - pydquoteStart[dQuoteNum - 1]) + 1), QColor(200,0 ,200 ));
	  dquoteFlag = false;
	  skipDQuoteFlag = true;
	  pydquoteStart.push_back(0);
	  pydquoteEnd.push_back(0);
	  pydquoteEnd[dQuoteNum - 1] = pydquoteStart[dQuoteNum - 1] + (i - pydquoteStart[dQuoteNum - 1]);
	}else if (dquoteFlag == false) {
	  // have to check for a first quote mark
	  if (a == '"') {
	    dquoteFlag = true;
	    dQuoteNum++;
	    // remember where the qoute mark is
	    pydquoteStart[dQuoteNum -1] = i;
	  }
	}
	// do the same thing for single quote mark
	if ((squoteFlag == true) && (a == "'")) {
	  setFormat((pysquoteStart[sQuoteNum - 1] ), ((i - pysquoteStart[sQuoteNum - 1]) + 1), QColor(200, 0,200 ));
	  squoteFlag = false;
	  skipSQuoteFlag = true;
	  pysquoteStart.push_back(0);
	  pysquoteEnd.push_back(0);
	 
	  pysquoteEnd[sQuoteNum -1] = pysquoteStart[sQuoteNum -1] + (i - pysquoteStart[sQuoteNum -1]);
	}else if (squoteFlag == false) {
   
	  if (a == "'") {
	    squoteFlag = true;
	    sQuoteNum++;
	    pysquoteStart[sQuoteNum -1] = i;
	  }
	}
      
      
      
      
    } // this ends the inner loop checking the line's chars
             
                 
    QStringList words = QStringList::split(' ', line, TRUE);
    for(unsigned int i=0; i<words.count(); i++) {
   
      key = false;
      typ = false;
   
      QString strings = words[i];
      spaceLength = strings.length() + 1;
    
      if(strings.isNull() || strings.isEmpty()) {
    
	start = start + spaceLength;
	continue;
      
      }
      int advance = 0;
      for(int i=0; i<spaceLength-1; i++) {
        QChar a = strings[i];
        if(a == QChar::null) 
	  break;
	else if(a.isSpace()) {
	  start++;
	  advance++;
	}
	else
	  break;
      }
      spaceLength -= advance;
      strings = strings.stripWhiteSpace();
      
      //****************************
     
      
      //********************************
      
      // so i'll back up word and wordLength wordEnd and start for symbols check later
      wordBK = strings;
      wordLengthBK = strings.length() + 1;
      //wordEndBK = start + wordLengthBK - 1;
      startBK = start;
      //wordLengthBK = wordLength;
      
      ///////// here lets hash it up further
      QStringList pieces = QStringList::split('(', strings, TRUE);
        for(unsigned int j=0; j<pieces.count(); j++) {
          QString q = pieces[j];
          //int len  = pieces.length() + 1;
          QStringList pieces_2 = QStringList::split(')', q, TRUE);
            for(unsigned int l=0; l<pieces_2.count(); l++) {
            QString r = pieces_2[l];
              QStringList pieces_3 = QStringList::split('{', r, TRUE);
                for(unsigned int m=0; m<pieces_3.count(); m++) {
                QString u = pieces_3[m];
                  QStringList pieces_4 = QStringList::split('}', u, TRUE);
                    for(unsigned int n=0; n<pieces_4.count(); n++) {
                    QString v = pieces_4[n];
                      QStringList pieces_5  = QStringList::split(',', v, TRUE);
                        for(unsigned int o=0; o<pieces_5.count(); o++) {
                        QString word = pieces_5[o];

       wordLength = word.length() + 1;
       //wordEnd = start + wordLength - 1;
       // if (word.endsWith(";")) {  
       // wordLength = wordLength - 1;
       // word.truncate(wordLength - 1);
        //wordEnd = start + wordLength;
       //}
     
      
      for(unsigned int k=0; k<28; k++) {
	if (highlightKeywords(word,pykeywords[k]) == true) {
	  key = true;
	  break;
	}
      }
      if (key == true) {
	start += wordLength;
	continue;
      }
      
    
      
      // for(unsigned int k=0; k<10; k++) {
      //if (highlightTypes(word,jtypes[k]) == true) {
      //  typ = true;
      //  break;
      //}
      // }
      // if (typ == true) {
      //	start += wordLength;
      //continue;
      //}
      
      start += wordLength;
			}
		    }
		}
	    }
	}
    
       
      
	start = startBK;
      highlightSymbols(wordBK);
      start += spaceLength;  
      
    } // now we have ended the words loop
  } // now we have finished the lines loop
     
    return 0;
} // end of highlight          
     
      
    




bool pythonSyntaxHighlighter:: highlightKeywords (QString s, QString w) {
  
  
  if (s  ==  w) {
    if (pytempFlag == true) {
      if (start <= pytempPlace)
	return false;
    }
    if (commentFlag == true) {
      if (commentStart <= start)
	return false;
    }
    
    if (skipSQuoteFlag == true)  {
      if (sQuoteNum == 1) {
	// if the quote starts and ends before where we are now
	if ((pysquoteStart[sQuoteNum -1] <  start) && (pysquoteEnd[sQuoteNum -1] < start)) { 
	  setFormat(start, (wordLength-1), QColor(0, 0, 255));
	  return true;
	}
	// if the qoute starts after where we are now
	else if (pysquoteStart[sQuoteNum -1] >  start) { 
	  setFormat(start, (wordLength-1), QColor(0, 0, 255));
	  return true;
	}
      } if (sQuoteNum > 1) {
	int count = 0;
	for(int i=0; i < sQuoteNum; i++) {
	  // if the quote starts and ends before where we are now
	  if ((pysquoteStart[i] <  start) && (pysquoteEnd[i] < start)) {
            
	    count++;
            
	  }
	}
	if (count == sQuoteNum) {
	  setFormat(start, (wordLength-1), QColor(0, 0, 255));
	  return true;
	}
	//count = 0;
	for(int i=0; i < sQuoteNum; i++) {
	  // add it in if the qoute starts after where we are now 
	  if (pysquoteStart[i] >  start)  { 
	    count++;
	  }
	}
	if (count == sQuoteNum) {
	  setFormat(start, (wordLength-1), QColor(0, 0, 255));
	  return true;
	}
      }
    }else 
      /////////////////////////////////
      if (skipDQuoteFlag == true)  {
	if (dQuoteNum == 1) {
	  // if the quote starts and ends before where we are now
	  if ((pydquoteStart[dQuoteNum - 1] <  start) && (pydquoteEnd[dQuoteNum - 1] < start)) { 
	    setFormat(start, (wordLength-1), QColor(0, 0, 255));
	    return true;
	  }
	  // if the qoute starts after where we are now 
	  else if (pydquoteStart[dQuoteNum - 1] >  start) { 
	    setFormat(start, (wordLength-1), QColor(0, 0, 255));
	    return true;
	  }
	}
	if (dQuoteNum > 1) {
	  int count = 0;
          for(int i=0; i < dQuoteNum; i++) {
	    // if all the quotes start and ends before where we are now
	    if ((pydquoteStart[i] <  start) && (pydquoteEnd[i] < start)) {
               
	      count++;
	    }
	  }
	  if (count == dQuoteNum) {
	    setFormat(start, (wordLength-1), QColor(0, 0, 255));
	    return true;
	  }
	  //count = 0;
          for(int i=0; i < dQuoteNum; i++) {
	    // add in any qoutes that  start after where we are now 
	    if (pydquoteStart[i] >  start) { 
	      count++;  
	    }
	  }
	  if (count == dQuoteNum) {
	    setFormat(start, (wordLength-1), QColor(0, 0, 255));
	    return true;
	  }
	}
      }else {
	setFormat(start, (wordLength-1), QColor(0, 0, 255));
	return true;
      }

    
    
  }
  
  
  
  return false;
  
}





void pythonSyntaxHighlighter::highlightSymbols (QString w) {
  int startChar = start;
  if (pytempFlag == true) {
    if (start <= pytempPlace)
      return;
  }
  if (commentFlag == true) {
    if (commentStart <= start)
      return;
  }
  if (skipSQuoteFlag == true) {
    if (sQuoteNum == 1) { 
      for(int i=0; i<wordLengthBK-1; i++) {
	QChar a = w[i];
	if ((startChar < pysquoteStart[sQuoteNum - 1]) || (startChar > pysquoteEnd[sQuoteNum - 1])) {
	  for(unsigned int k=0; k<6; k++) {
	    QChar s = pysymbols[k];
	    if(a == s)
	      if (commentFlag == true) {
		if (startChar < commentStart)
		  setFormat(startChar, 1, QColor(255, 0, 0));
	      }else 
		setFormat(startChar, 1, QColor(255, 0, 0));
	  }
	}
	startChar++;
      }
    }
    if (sQuoteNum > 1) {
                    
      for(int i=0; i<wordLengthBK-1; i++) {
	int count = 0;
	QChar a = w[i];
	for(int j=0; j < sQuoteNum; j++) {
      
	  if ((startChar < pysquoteStart[j]) || (startChar > pysquoteEnd[j])) {
	    count++;
	  }
	}
	if (count == sQuoteNum) {
	  for(unsigned int k=0; k<6; k++) {
	    QChar s = pysymbols[k];
	    if(a == s)
	      if (commentFlag == true) {
		if (startChar < commentStart)
		  setFormat(startChar, 1, QColor(255, 0, 0));
	      }else 
		setFormat(startChar, 1, QColor(255, 0, 0));
	  }
	}
     
	startChar++;
      }
    }
  
  }else
    if (skipDQuoteFlag == true) {
      if (dQuoteNum == 1) {
	for(int i=0; i<wordLengthBK-1; i++) {
	  QChar a = w[i];
	  if ((startChar < pydquoteStart[dQuoteNum - 1]) || (startChar > pydquoteEnd[dQuoteNum - 1])) {
	    for(unsigned int k=0; k<6; k++) {
	      QChar s = pysymbols[k];
	      if(a == s)
		if (commentFlag == true) {
		  if (startChar < commentStart)
		    setFormat(startChar, 1, QColor(255, 0, 0));
		}else
		  setFormat(startChar, 1, QColor(255, 0, 0));
                
	    }
             
             
	  }
	  startChar++; 
	} 
      }
      if (dQuoteNum > 1) {
		

	for(int i=0; i<wordLengthBK-1; i++) {
	  int count = 0;
	  QChar a = w[i];
	  for(int j=0; j < dQuoteNum; j++) {
      
	    if ((startChar < pydquoteStart[j]) || (startChar > pydquoteEnd[j])) {
	      count++;
	    }
	  }
	  if (count == dQuoteNum) {
	    for(unsigned int k=0; k<6; k++) {
	      QChar s = pysymbols[k];
	      if(a == s)
		if (commentFlag == true) {
		  if (startChar < commentStart)
		    setFormat(startChar, 1, QColor(255, 0, 0));
		}else 
		  setFormat(startChar, 1, QColor(255, 0, 0));
	    }
	  }
     
	  startChar++;
	}
      }
    }else             
      for(int i=0; i<wordLengthBK-1; i++) {
       
	QChar a = w[i];
	for(unsigned int k=0; k<6; k++) {
	  QChar s = pysymbols[k]; 
	  if(a == s)
	    if (commentFlag == true) {
	      if (startChar < commentStart)
		setFormat(startChar, 1, QColor(255, 0, 0));
	    }else
	      setFormat(startChar, 1, QColor(255, 0, 0));
                 
	}  
             
	startChar++; 
      }
}
        





























































