#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/mecabrc.new
( cd usr/lib ; rm -rf libmecab.so )
( cd usr/lib ; ln -sf libmecab.so.1.0.0 libmecab.so )
( cd usr/lib ; rm -rf libmecab.so.1 )
( cd usr/lib ; ln -sf libmecab.so.1.0.0 libmecab.so.1 )
