/*
   Copyright (C) 2001-2008 Thomas Capricelli <orzel@freehackers.org>
*/

#ifndef OPALE_DATA_H
#define OPALE_DATA_H

/* Qt */
#include <QList>
#include <QTreeWidget>
#include <QList>
#include <qdatetime.h>

/* KDE */

/* Opale */
#include "record.h"

//#define DISPLAY_BEST_CASE 1
#undef DISPLAY_BEST_CASE

class QLabel;
class QTreeWidgetItem;
class QComboBox;

typedef enum { editMethod, editCategory} editBoxWhat_t;

/**
  * @short Internal representation of the account data
  *
  * The OpaleDocument object stores all the relevant data of an account. This
  * is exactly the same thing as an opale document, but in a structured
  * class stored in (ram) memory.
  *
  * This is the display widget as well ( a QTreeWidget )
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */

class OpaleDocument : public QTreeWidget
{
	// XXX orzel remove this
        friend class MainWindow;
	Q_OBJECT
public:
        OpaleDocument( QWidget* parent = 0);

	/* document handling */
	void resetData(void);
	bool loadXML(const QDomDocument & );
	QDomDocument saveXML();
	bool loadXML( const QString filenme );
	bool saveXML(QString filename);

	void    updateTotal(Total &);
	void	fillDataGraph(QList<GraphData> &chartData, QDate begin, QDate end, amount_t &a_min, amount_t &a_max);
	void	fillDataStats(StatsData &statsData, QDate begin, QDate end);
	QString	currency(void) {return s_currency; }
	QString	account_name(void) {return s_account_name; }

//	void	setInfos(QString currency, QString account_name) { s_currency = currency; s_account_name = account_name; setModified(true); }
	void    setModified(bool f);
	bool    isModified(void){return b_modified;};
	void	fillCombos(QComboBox *, QComboBox *);
	int	checkMethodCombos(QComboBox *);
	int	checkCategoryCombos(QComboBox *);

//	void	deleteRecord(OpaleRecord *);
//	void	addRecord(OpaleRecord *);
	void	addPattern(OpalePattern);
	/** something has changed : */
	void	touched(void);
	OpaleRecord	*newRecordFromPattern(int i) { return new OpaleRecord(this, patterns.at(i)); }
	int     recordsCount( void ) { return topLevelItemCount() ; }

	/** should only be used by listboxeditor */
	bool        canDelete( int, editBoxWhat_t  );

	QString method( int i ) { return methodSList[i];}
	QString category( int i ) { return categorySList[i];}


public slots:
	void editRecord(QTreeWidgetItem *item, int column);
	void itemclicked( QTreeWidgetItem * item, int c );
	int editFileOptions(void);
	int editCategories(void);
	int editMethods(void);
	void repeat_record();
	void delete_record();
	void new_pattern(void);
	void check_record();
	void gotoNow(void);

	const QStringList methods(void ) const { return methodSList; }
	const QStringList categories(void ) const { return categorySList; }

signals:
	/** This signal is emmited when the pattern list has changed. This
	  * is used to update the pattern combobox on the gui
	  * (toolbar+menu). */
	void	newPatterns (QStringList );
	/** This signal is emmited when the actual data is changed, like
	  * adding/changing/removing a record. It is not emmited when a
	  * category or a type is changed */
	void	listUpdated(void);
	/** This signal is emmited when the category list is changed, like
	  * adding/changing/removing a category */
	void    categoriesUpdated(void);
	/** This signal is emmited when the method list is changed, like
	  * adding/changing/removing a method */
	void    methodsUpdated(void);

protected:
	void     removeMethod(int num, int newnum);
	void     removeCategory(int num, int newnum);

protected:
        void	fillList(void );
	void	syncPatterns(void);

private:
	QList<OpalePattern>	patterns;
	QStringList		methodSList;
	QStringList		categorySList;

	/* account information */
	QString			s_currency;
	QString			s_account_name;
	bool                    b_modified;
};

#endif // OPALE_DATA_H


