/*
   Copyright (C) 2001-2008 Thomas Capricelli <orzel@freehackers.org>
*/

#ifndef OPALE_GRAPH_H
#define OPALE_GRAPH_H


#include <time.h>

/* Qt */
#include <QList>

/* KDE */
#ifdef ENABLE_KDE
#include <kmainwindow.h>
#else
#include <QMainWindow>
#ifndef KMainWindow
# define KMainWindow QMainWindow
#endif
#endif

/* Opale */
#include "record.h" // GraphData

class QPainter;
class OpaleDocument;

/** Minimum time length displayed on the graph, in seconds */
#define MINIMUM_LENGTH (5*24*60*60) // five days

/**
  * @short Graph Widget
  *
  * This Widget diplays a graph representing the balance as a function of
  * time.
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */
class GraphWidget: public QWidget
{
	Q_OBJECT
public:
	GraphWidget( OpaleDocument *_data, QDate s, QDate e, QWidget *parentWidget = 0);
	~GraphWidget();

	void paintEvent (  QPaintEvent * e );
	void resizeEvent (  QResizeEvent *  );

	void    setBeginEnd(uint uistart, uint uiend);
	void    setMiddleLen(uint m, uint l);

public slots:
	void	updateChart(void);
	void	goleft(void);
	void	goright(void);
	void	zoomin(void);
	void	zoomout(void);

protected:
	virtual void mousePressEvent( QMouseEvent * );
	virtual void mouseReleaseEvent( QMouseEvent * );
	virtual void mouseDoubleClickEvent ( QMouseEvent * e );

private:
	int amount2pixel( amount_t a ) { return y2+(a-a_min)*(y1-y2)/(a_max-a_min);}
	int date2pixel( QDate d );
	QDate pixel2date(int);
	int pixel2time(int x );

	/**
	  * This enum is used so that displayTimeRow knows what to display
 	 */
	typedef enum {
			dr_days,
			dr_months,
			dr_years
	} dateRowToDisplay;
	/**
	  * display time lines ( kind 1,2,3 is for years,month,days )
	  * y is the y-coordinate to be used for text, and h the heigh
	  */
	void displayTimeRow(QPainter &, QPen , dateRowToDisplay what, int y, int h);
	QList<GraphData> chartData;
	amount_t    a_min, a_max;
	OpaleDocument * data;

	int x1,x2,y1,y2; // grid bound
	int datelen;     // number of day between start and end

	QDate	start,end;
	uint	pstart,pend; //pixel
	uint	len, middle;
	int	mousePos;
};


/**
  * @short Q/KMainWindow used to display the graph Widget.
  *
  * It does nothing more than creating the frame and connect signal/slots.
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */

class OpaleGraph : public KMainWindow
{
	Q_OBJECT
public:
	OpaleGraph( OpaleDocument *data, QWidget *parentWidget = 0);
	~OpaleGraph();

private:
	GraphWidget *chart;
};

#endif // OPALE_GRAPH_H
