/**********************************************************************
** Copyright (C) 2005 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include <qlineedit.h>
#include <qlabel.h>
#include <QPainter>
#include <QListWidget>
#include <qpushbutton.h>
#include <qcheckbox.h>

#include "listboxeditorimpl.h"
#include "document.h"
#include "opale.h"

ListBoxEditor::ListBoxEditor(OpaleDocument *d, editBoxWhat_t e, QWidget *parent, QStringList list)
    : QDialog( parent)
    , data(d)
    , editBoxWhat(e)
{
	setupUi(this);
    itemText->setText( "" );
    itemText->setEnabled( FALSE );

    for ( int i=0; i<list.count(); i++ )
	    preview->insertItem(i, list[i]);

    if ( preview->item(0) )
	preview->setCurrentRow(0);

}

void ListBoxEditor::insertNewItem()
{
	// preview.inserttem(tr("New Item"));
	preview->addItem( tr("New Item"));
}

void ListBoxEditor::deleteCurrentItem()
{
	int idx = preview->currentRow();
	if (!data->canDelete(idx, editBoxWhat) )
		return; // abort

	delete preview->item(idx);
	// update edit text
//	if ( preview->currentRow() != -1 )
//		preview->setSelected( preview->currentItem(), TRUE );
}

void ListBoxEditor::currentTextChanged( const QString &txt )
{
	if ( preview->currentRow() == -1 ) {
		qWarning("ListBoxEditor::currentTextChanged() is -1");
		return;
	}

	QList<QListWidgetItem *> selected = preview->selectedItems();
	Q_ASSERT(selected.count()==1);
	preview->blockSignals( TRUE );
	selected[0]->setText(txt);
	preview->blockSignals( FALSE );
}


#include "listboxeditorimpl.moc"

