/**********************************************************************
** Copyright (C) 2000-2005 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef LISTBOXEDITORIMPL_H
#define LISTBOXEDITORIMPL_H

/* Qt */
#include <q3listbox.h>

/* Project */
#include "ui_listboxeditor.h"
#include "document.h"


class QListWidget;
class OpaleDocument;
class FormWindow;

/**
  * @short A widget used to edit a list of strings (add/remove)
  *
  * Code taken from Qt example, wich i modified quite a lot
  *
  * @author Trolltech
  * @author Thomas Capricelli <orzel@freehackers.org>
  */
class ListBoxEditor : public QDialog, Ui_ListBoxEditorBase
{
    friend class OpaleDocument;
    Q_OBJECT

public:
    ListBoxEditor(OpaleDocument *d, editBoxWhat_t, QWidget *parent, QStringList list );

protected slots:
    void insertNewItem();
    void deleteCurrentItem();
    void currentTextChanged( const QString & );

private:
    QListWidget listbox;
    OpaleDocument *data; // associated data
    editBoxWhat_t editBoxWhat;
};

#endif
