/*
   Copyright (C) 2001-2008 Thomas Capricelli <orzel@freehackers.org>
*/

/* Qt */
#include <qfile.h>
#include <qdir.h>
#include <q3iconview.h>

/* KDE */
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kglobal.h>

/* Project */
#include "mainwindow.h"
#include "ui_recentfiledialog.h"



static const KCmdLineOptions options[]=
{
	{"+[file]", I18N_NOOP("File To Open"),0},
        KCmdLineLastOption
};

const char* version="0.10pre";
const char* description=I18N_NOOP("Very simple personal finance manager and planning tool.");



QString loadRecent(void)
{
	KConfig *config = KGlobal::config();
	// Create openRecent document panel
	if(config->hasGroup("RecentFiles")) {
		qDebug("Yes, we've got RecentFiles!");
		config->setGroup("RecentFiles");
		RecentFileDialog *rfd=new RecentFileDialog( 0, "RecentFileDialog" );

		// fill it
		QString value="faked";
		int i = 1;
		QMap<Q3IconViewItem*,QString> map;
		do {
			QString key = QString( "File%1" ).arg( i );
			value = config->readPathEntry( key );
			if ( !value.isEmpty() ) {
				static int firstselected=false;
				int pos = value.findRev('/');
				Q3IconViewItem *item =new Q3IconViewItem( rfd->iconView, value.mid(pos+1));
				if ( !firstselected ) {
					rfd->iconView->setSelected( item, true);
					firstselected=true;
				}
				map[item]=value;
				qDebug("reading \"%s\"", key.ascii());
				qDebug("got : \"%s\"", value.ascii());
			}
			i++;
		} while ( !value.isEmpty() || i<10);
		QObject::connect(rfd->iconView, SIGNAL(doubleClicked( Q3IconViewItem * )), rfd, SLOT(accept()));

		// show it
		if ( rfd->exec() == QDialog::Accepted ) {
			// find the selected one
			for (  Q3IconViewItem *item = rfd->iconView->firstItem(); item; item = item->nextItem() )
				if ( item->isSelected() ) {
					qDebug("found selected : %s", map[item].ascii());
					return  map[item].ascii() ;
					break;
				}
		}
	}
	return QString::null;
}



int main( int argc, char **argv )
{
	KAboutData aboutData( "opale", "Opale",
			version, description, KAboutData::License_GPL,
			"(c) 2001-2007, Thomas Capricelli", 0, "http://orzel.freehackers.org/opale", "http://www.freehackers.org/bugtracker//set_project.php?project_id=1&ref=bug_report_page.php");

	aboutData.addAuthor("Thomas Capricelli",0,
			"orzel@freehackers.org", "http://orzel.freehackers.org");

	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options );
	KApplication app(argc,argv);


	// file handling
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	for ( int i = 0; i < args->count(); i++ ) // Counting start at 0!
		qDebug("argument : %s", QFile::decodeName(args->arg(i)).ascii());
	

	MainWindow *m = new MainWindow( );

	app.setMainWidget(m);
	if (  QApplication::desktop()->width() > m->width() + 10 && QApplication::desktop()->height() > m->height() +30 )
		m->show();
	else
		m->showMaximized();

	if ( args->count() ) {
		if ( args->arg(0)[0]!='/' ) 
			m->openfilename( QDir::current().canonicalPath()+"/"+QFile::decodeName(args->arg(0)) );
		else
			m->openfilename(  QFile::decodeName(args->arg(0)) );
		}
	else{
		QString load=loadRecent();
		if ( load !=QString::null )
			m->openfilename( load );
	}
//	else m->file_new();

	// dcop stuff
	app.dcopClient()->attach();
	app.dcopClient()->registerAs( "opale" );


	return app.exec();
}

