/*
   Copyright (C) 2001-2008 Thomas Capricelli <orzel@freehackers.org>
*/

/* Qt */
#include <qfile.h>
#include <qdir.h>
#include <qapplication.h>
#include <QDesktopWidget>

/* Project */
#include "mainwindow.h"
//#include "recentfiledialog.h"

#define I18N_NOOP(x) x

const char* version="0.10pre";
const char* description=I18N_NOOP("Very simple personal finance manager and planning tool.");

int main( int argc, char **argv )
{
	QApplication app(argc,argv);

    // qt init
    QCoreApplication::setOrganizationName( "Freehackers" );
    QCoreApplication::setOrganizationDomain( "freehackers.org" );
    QCoreApplication::setApplicationName( "Opale" );

	MainWindow *m = new MainWindow( );
	if (  QApplication::desktop()->width() > m->width() + 10 && QApplication::desktop()->height() > m->height() +30 )
		m->show();
	else
		m->showMaximized();

	if ( argc>1 ) {
		if ( argv[1][0]!='/' ) 
			m->openfilename( QDir::current().canonicalPath()+"/"+QFile::decodeName(argv[1]) );
		else
			m->openfilename(  QFile::decodeName(argv[1]) );
		}

	return app.exec();
}

