/*
   Copyright (C) 2001-2008 Thomas Capricelli <orzel@freehackers.org>
*/

#ifndef OPALE_MAINWINDOW
#define OPALE_MAINWINDOW

/* unix */

/* qt */

/* KDE */
#ifdef ENABLE_KDE
#include <kmainwindow.h>
class KRecentFilesAction;
class KListAction;
#else
#include <QMainWindow>
#ifndef KMainWindow
# define KMainWindow QMainWindow
#endif
#endif

/* Opale */
#include "opale.h"

class OpaleRecord;
class QLabel;
class OpaleDocument;
class QUrl;
class KSelectAction;

/**
  * @short Opale Mainwindow
  *
  * The mainwindow displays the record list, several other information and
  * a toolbar.
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */
class MainWindow : public KMainWindow
{
	Q_OBJECT;
public:
	MainWindow(QWidget *parent=0);
	~MainWindow( );

	/**
	  * open a file using the @arg _filename
	  * *Warning* we suppose no file is already open here
	  */
	void openfilename( QString _filename );

signals:
	void setEnabled( bool );

public slots:
	// FILE STUFF
	void newFile();
	void open();
	bool save();
    void openRecentFile();
	bool saveAs();
	bool file_close();
	bool app_close();
	// help menu
	void aboutOpale();
	void reportBug();
	void openManual();

	// operation on opalepart
	void new_record(void);
	void new_record_from_pattern(int);

	// misc
	void newPatterns(QStringList);
	void get_graph(void);
	void get_stats(void);
	void updateTotal(void);

protected:
	virtual void closeEvent(  QCloseEvent * e );

private:
	void createActions();

#ifndef ENABLE_KDE
	void createMenus();
	void createToolBars();

	QMenu *fileMenu;
	QMenu *editMenu;
	QMenu *helpMenu;
	QMenu *viewMenu;
	QMenu *settingsMenu;

	QToolBar *fileToolBar;
	QToolBar *editToolBar;

	QAction *newAct;
	QAction *openAct;
	QAction *saveAct;
	QAction *saveAsAct;
	QAction *closeAct;
	QAction *exitAct;
	QAction *newRecordAct;
	QAction *repeatRecordAct;
	QAction *deleteRecordAct;
	QAction *checkRecordAct;
	QAction *editfileOptionsAct;
	QAction *editCategoriesAct;
	QAction *editMethodsAct;
	QAction *newPatternAct;
	QAction *getGraphAct;
	QAction *getStatsAct;
	QAction *gotoNowAct;
	QAction *openManualAct;
	QAction *reportBugAct;
	QAction *aboutAct;
#endif


	void displayTotal(void);


    void setCurrentFile(const QString &fileName);
    QString strippedName(const QString &fullFileName);
	QString	fillLabel(amount_t amount, bool exact=false);

	QLabel		*l_utt, *l_uttsafe, *l_checked;
	KSelectAction	*m_patternaction;
#ifdef ENABLE_KDE
	KRecentFilesAction * m_recent;
#else
    void updateRecentFileActions();
    enum { MaxRecentFiles = 5 };
    QAction *recentFileActs[MaxRecentFiles];
    QAction *separatorAct;
#endif
	/**
	  * filename. Can be
	  *     QString::null if no file is here
	  *     empty string for an unnamed new file
	  *     nonempty string if a named file is loaded
	  */
	QString filename;
	Total        total;
	OpaleDocument *mydata;
};


#endif /* OPALE_MAINWINDOW */
