/*
 *  Copyright (C) 2001-2008 Thomas Capricelli <orzel@freehackers.org>
 */

/* System */

/* Qt */
#include <qpainter.h>

/* KDE */

/* Opale */
#include "piechart.h"

PieChart::PieChart(QWidget *parentWidget)
	:QWidget(parentWidget)
{
}

#define MAX_NUMBER_DISPLAYED 8

void PieChart::setSums(QVector<int> s, const QStringList c)
{
	int i;
	int numberDisplayed = MAX_NUMBER_DISPLAYED;
	// basic check
	sums = s; captions = c;
	if (sums.count() != captions.count()) {
		qWarning("PieChart::setSums(), counts are different ! sums:%d, captions;%d",sums.count(),captions.count());
		return;
	}
	for (i=0; i<sums.count(); i++)
		if (sums[i]<0)
			qWarning("sums[%d]=%d", i, sums[i]);

	// really basic "sort and select biggest", no need for optimisation here
	int start=0;

	while (start<MAX_NUMBER_DISPLAYED && start<sums.count()) {
		int max =-10 , maxIdx=-1;
		// find biggest one
		for (i=start; i<sums.count(); i++)
			if (sums[i]>max) {
				max = sums[i];
				maxIdx = i;
			}
		if (max<=0)  {
			numberDisplayed = start;
			sums.resize(start);
			break;
		}
		Q_ASSERT(max>0);
		// swap
		int tmpi; QString tmpstr;
		tmpi = sums[start]; sums[start] = sums[maxIdx]; sums[maxIdx] = tmpi;
		tmpstr = captions[start]; captions[start] = captions[maxIdx]; captions[maxIdx] = tmpstr;

		// keep on
		start ++;
	}

	// handle the case where not data is available
	if (!sums.count() || !numberDisplayed) {
		sums.resize(0);
		return;
	}

	// cut the end
	if (sums.count()>numberDisplayed) {
		captions[numberDisplayed-1] = tr("Others");
		for (i=numberDisplayed; i<sums.count(); i++)
			sums[numberDisplayed-1] += sums[i];
		sums.resize(numberDisplayed);
	}
	qDebug("sums size -> %d", sums.count());

	// compute total
	float total=0;
	for (i=0; i<sums.count(); i++)
		total += sums[i];

	// set %
	for (i=0; i<sums.count(); i++)
		captions[i] += QString(" (%1 %)").arg(float(100.*sums[i])/total, 0, 'f', 2);

}

#define MARGIN 10
#define LINE_MARGIN 5
#define SQUARE_SIZE 10

void PieChart::resizeEvent (  QResizeEvent *  )
{
	update();
}

void PieChart::paintEvent (  QPaintEvent *)
{
	static QColor colorTab[] = { Qt::red, Qt::green, Qt::blue, Qt::cyan, Qt::magenta, Qt::yellow, Qt::darkRed, Qt::darkGreen, Qt::darkBlue, Qt::darkCyan, Qt::darkMagenta, Qt::darkYellow, Qt::darkGray };
	int colorIdx = 0;
	int i;

	// init
	QPainter p( this);

	// clear
	QRect r=p.window();
	p.eraseRect(r);

	// if sums is empty, this means there is no data to display
	if ( !sums.count()) {
		p.drawText(40,70,"No Data available");
		p.end();
		update(); // widget
		return;
	}

	// compute size needed for the caption
	int capw=0, caph=MARGIN; // width, height
	if (!captions.empty()) {
		for ( int i=0; i< sums.count(); i++) {
			QRect rect = p.boundingRect(1,1,200,200,Qt::AlignLeft,captions[i]);
			//		qDebug("text : w,h = %d,%d, x,y=.,%d", rect.width(), rect.height(), rect.y());
			if (capw<rect.width()) capw=rect.width();
			caph+= LINE_MARGIN+ rect.height();
		}
		capw+=2*MARGIN; // a margin of MARGIN all around
		capw += SQUARE_SIZE + MARGIN; // square
//		qDebug("text : w,h = %d,%d", capw,caph);
	} else {
		capw=caph=0;
	}

	// geometry settings
	QRect caption,pie;
	if ( qMin( r.width()-capw, r.height()) >= qMin( r.width(), r.height()-caph)) {
		// caption on the right
		pie = QRect(0,0, r.width()-capw, r.height());
		caption = QRect(pie.width(), 0, capw, caph);
		caption.moveTop((r.height()-caption.height())/2); // center
	} else {
		// caption on top
		caption = QRect((r.width()-capw)/2, 0, capw, caph);
		pie = QRect(0,caph, r.width(), r.height()-caph);
	}
	// center pie
	int size = qMin( pie.width(), pie.height());
	pie.translate( (pie.width()-size)/2, (pie.height()-size)/2); // center
	pie.setWidth(size);
	pie.setHeight(size);

	// display caption
	if (!captions.empty()) {
		int x = caption.x()+MARGIN;
		int y = caption.bottom()-MARGIN;
		colorIdx = (sums.count()-1)%sizeof(colorTab);
		for ( int i=sums.count()-1; i>=0; i--) {
//			qDebug("colorIdx = %d", colorIdx);
			p.setBrush( colorTab[colorIdx]);
			--colorIdx %= sizeof(colorTab);
			p.drawRect(x,y,SQUARE_SIZE,-SQUARE_SIZE);
			QRect rect = p.boundingRect(x,y,200,200,Qt::AlignLeft,captions[i]);
			p.drawText( x+SQUARE_SIZE+MARGIN, y, captions[i]);
			y -= LINE_MARGIN+ rect.height();
		}
		p.setBrush( Qt::NoBrush );
//		p.setPen( Qt::red); p.drawRect(caption); // debug
		p.setPen( Qt::black);
		caption.translate(MARGIN/2, MARGIN/2);
		caption.setWidth(caption.width()-MARGIN/2);
		caption.setHeight(caption.height()-MARGIN/2);
		p.drawRect(caption);
	}

	// compute total
	float total=0;
	for (i=0; i<sums.count(); i++)
		total += sums[i];

	// display pie
	p.setBrush( Qt::NoBrush );
//	p.setPen( Qt::red); p.drawRect(pie); // debug

	pie.translate(MARGIN/2, MARGIN/2);
	pie.setWidth(pie.width()-MARGIN/2);
	pie.setHeight(pie.height()-MARGIN/2);
//	p.setPen( Qt::black); p.drawRect(pie); // debug
	int a=0; // current angle
	int arc; // arc length

	colorIdx = 0;
	for (i=0; i<sums.count(); i++) {
		arc = int( float(16*360)*float(sums[i])/total );
//		qDebug("arc is %d,%d", arc, arc/16);
		p.setBrush( colorTab[colorIdx]);
		p.drawPie( pie, a, arc );
		++colorIdx %= sizeof(colorTab);
		a+=arc;
		}

	// end
	p.end();
	update(); // widget
}

#include "piechart.moc"

