/*
 *  Copyright (C) 2007-2008 Thomas Capricelli <orzel@freehackers.org>
 */

#ifndef OPALE_PIECHART_H
#define OPALE_PIECHART_H


/* System */

/* Qt */
#include <QVector>
#include <qwidget.h>
#include <qpixmap.h>

/* KDE */

/* Opale */


class QPainter;

/**
  * @short General Pie Chart Widget
  *
  * This widget display a nice piechart, given a vector of integer and an
  * optional caption list.
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */

class PieChart : public QWidget
{
	Q_OBJECT;
public:
	PieChart(QWidget *parentWidget = 0);

	void paintEvent (  QPaintEvent * e );
	void resizeEvent (  QResizeEvent *  );
	/** setter for both values and optional captions */
	void setSums(QVector<int> s, const QStringList c=QStringList::QStringList());
private:
	/** values displayed in the pie chart */
	QVector<int> sums;
	/** corresponding captions  */
	QStringList captions;
};

#endif // OPALE_PIECHART_H
