/*
 *  Copyright (C) 2001-2008 Thomas Capricelli <orzel@freehackers.org>
 */

/* System */
//#include <math.h>

/* Qt */
#include <qstatusbar.h>
#include <qlabel.h>

/* KDE */
#ifdef ENABLE_KDE
#include <kcombobox.h>
#else
#include <qcombobox.h>
//#define KComboBox QComboBox
#endif

/* Opale */
#include "stats.h"
#include "document.h"
#include "piechart.h"


OpaleStats::OpaleStats( OpaleDocument *_data, QWidget *parentWidget)
	: QMainWindow( parentWidget), data(_data) 
{
	delete statusBar();

	setupUi(this);
		
	// do it
	start= QDate::currentDate().addMonths(-5);
	end = QDate::currentDate();

	connect( data, SIGNAL(listUpdated(void)), this, SLOT(updatePie(void)));
	connect( comboWhat, SIGNAL(activated(int)), this, SLOT(updatePie()));
	connect( comboDate, SIGNAL(activated(int)), this, SLOT(updatePie()));

	// fill names
	comboDate->setCurrentIndex(6);
	updatePie();
}

OpaleStats::~OpaleStats()
{
}



void OpaleStats::updatePie(void)
{
//	qDebug("OpaleStats::updatePie()");
	// fetch time range
	QString range;
	QDate d = QDate::currentDate();


	// compute start/end and caption
	switch(comboDate->currentIndex()) {
		default:
			qWarning("OpaleStats::updatePie() : unknown date range: %d", comboWhat->currentIndex());
			return;
		case 0: // this month
			start.setDate(d.year(), d.month(), 1);
			end = start.addMonths(+1);
			end = end.addDays(-1);
			range = tr("This month :")+ start.toString("MMMM yyyy");
			break;
		case 1: // last month
			end.setDate(d.year(), d.month(), 1);
			start = end.addMonths(-1);
			end = end.addDays(-1);
			range = tr("Last month :")+ start.toString("MMMM yyyy");
			break;
		case 2: // this year
			start.setDate(d.year(), 1, 1);
			end = start.addYears(+1);
			end = end.addDays(-1);
			range = tr("This year :")+ start.toString("yyyy");
			break;
		case 3: // last year
			end.setDate(d.year(), 1, 1);
			start = end.addYears(-1);
			end = end.addDays(-1);
			range = tr("Last year :")+ start.toString("yyyy");
			break;
		case 4: // until now
			range = tr("Until now");
			// QDate doc : This calendar was adopted by England from the 14th September 1752 (hence this is the earliest valid QDate)
			start= QDate::QDate(1752, 9, 15);
			end = QDate::currentDate();
			break;
		case 5: // from now on
			range = tr("From now on");
			start= QDate::currentDate();
			// QDate doc : The end of time is reached around
			// the year 8000, by which time we expect Qt to be
			// obsolete.
			end = QDate::QDate(8000,1,1);
			break;
		case 6: // all
			range = tr("All");
			// see comment on 6 and 7
			start= QDate::QDate(1752, 9, 15);
			end = QDate::QDate(8000,1,1);
			break;
	}

	// display caption
	switch(comboDate->currentIndex()) {
		default:
			titleLabel->setText( tr("Statistics from %1 to %2 (%3)").arg(start.toString(Qt::TextDate)).arg(end.toString(Qt::TextDate)).arg(range) );
			break;
		case 6: // all
			titleLabel->setText( tr("Statistics for all records"));
			break;
		case 4: // until now
			titleLabel->setText( tr("Statistics from beginning to %1").arg(end.toString(Qt::TextDate)));
			break;
		case 5: // from now on
			titleLabel->setText( tr("Statistics from %1 onward").arg(start.toString(Qt::TextDate)) );
			break;
	}

	// fetch data
	data->fillDataStats(statsData, start, end);

	// fill chart
	switch (comboWhat->currentIndex()) {
		default:
			qWarning("OpaleStats::updatePie() : unknown what : %d", comboWhat->currentIndex());
			return;
		case 0: // Income
			qDebug("print data is %p", data);
			chart1->setSums(statsData.categoryPositive,data->categories() );
			break;
		case 1: // Outcome
			chart1->setSums(statsData.categoryNegative,data->categories() );
			break;
		case 2: // Methods In
			chart1->setSums(statsData.methodPositive,data->methods() );
			break;
		case 3: // Methods Out
			chart1->setSums(statsData.methodNegative,data->methods() );
			break;
	}
	chart1->update();
}

#include "stats.moc"

