/*
 *  Copyright (C) 2006-2008 Thomas Capricelli <orzel@freehackers.org>
 */

#ifndef OPALE_STATS_H
#define OPALE_STATS_H

/* System */

/* Qt */
#include <QMainWindow>

/* KDE */

/* Opale */
#include "record.h" // StatsData
#include "ui_statswindow.h"


class OpaleDocument;

/**
  * @short QMainWindow used to display a piechart
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */
class OpaleStats : public QMainWindow, Ui_StatsWindowBase
{
	Q_OBJECT
public:
	OpaleStats( OpaleDocument *data, QWidget *parentWidget = 0);
	~OpaleStats();

public slots:
	/** This slot does the actual rendering, updating the main window
	  * captions wrt to the different widgets (what to display, time
	  * period ). 
	  * It calls data->fillDataStats() and updates the pie chart
	  * accordingly.
	  */
	void updatePie(void);
protected:
//	virtual void resizeEvent ( QResizeEvent * e );
private:
	OpaleDocument *data;
	StatsData statsData;
	QDate	start,end;
	QVector<int> sums1, sums2;
};

#endif // OPALE_STATS_H
