/*
*  RAL -- Rubrica Addressbook Library
*  file: address.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_ADDRESS_H
#define _R_ADDRESS_H

#include <glib.h> 
#include <glib-object.h>


#define R_ADDRESS_TYPE            (r_address_get_type())

#define R_ADDRESS(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),    \
                                   R_ADDRESS_TYPE, RAddress))

#define R_ADDRESS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),     \
                                   R_ADDRESS_TYPE, RAddressClass))

#define IS_R_ADDRESS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),    \
                                   R_ADDRESS_TYPE))

#define IS_R_ADDRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),     \
                                   R_ADDRESS_TYPE))

#define R_ADDRESS_GET_CLASS(kls)  (G_TYPE_INSTANCE_GET_CLASS((kls),     \
                                   R_ADDRESS_TYPE, RAddressClass))

// delivery address - indirizzo (indirizzo di consegna)
 
/**
 * RAddressType, the address's type, modeled on vcard address's types
 */
typedef enum {
  R_ADDRESS_PREF = 0,    /* preferred delivery address                */
  R_ADDRESS_HOME,        /* delivery address for a residence          */
  R_ADDRESS_WORK,        /* delivery address for a place of work      */
  R_ADDRESS_PARCEL,      /* parcel delivery address (consegna pacchi) */ 
  R_ADDRESS_POSTAL,      /* postal delivery address                   */
  R_ADDRESS_INTL,        /* international delivery address            */
  R_ADDRESS_DOM,         /* domestic delivery address                 */
  R_ADDRESS_COMPANY,     /* registered office                         */
  R_ADDRESS_SUBSIDIARY,  /* subsidiary company                        */ 
  R_ADDRESS_OTHER,       /* other address type                        */
  R_ADDRESS_UNKNOWN,     /* */
  R_ADDRESS_INVALID
} RAddressType;



typedef struct _RAddress        RAddress;
typedef struct _RAddressClass   RAddressClass;
typedef struct _RAddressPrivate RAddressPrivate;


struct _RAddress
{
  GObject parent;

  RAddressPrivate* priv;
};

struct _RAddressClass
{
  GObjectClass parent_class;
};


GType        r_address_get_type    (void);
 

RAddress*    r_address_new             (void);
void         r_address_free            (RAddress* address);

gboolean     r_address_have_data       (RAddress* address);
gboolean     r_address_check           (RAddress* contact, 
					const gchar* property, gchar** value);

RAddress*    r_address_copy            (RAddress* address);

gboolean     r_address_search          (RAddress* address, const gchar* str);

RAddressType r_address_lookup_str2enum (gchar* str);
gchar*       r_address_lookup_enum2str (RAddressType type);

gchar*       r_address_lookup_enum2lbl (RAddressType type);
gchar*       r_address_lookup_str2lbl  (gchar* str);


#endif
