/*
*  RAL -- Rubrica Addressbook Library 
*  file: ref.h 
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it> 
*
*  This program is free software; you can redistribute it and/or modify 
*  it under the terms of the GNU General Public License as published by 
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful, 
*  but WITHOUT ANY WARRANTY; without even the implied warranty of 
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
*  GNU General Public License for more details. 
*
*  You should have received a copy of the GNU General Public License 
*  along with this program; if not, write to the Free Software 
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
*/ 

#ifndef _R_REF_H
#define _R_REF_H

#include <glib.h>
#include <glib-object.h>


#define R_REF_TYPE           (r_ref_get_type())

#define R_REF(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),      \
		              R_REF_TYPE, RRef))

#define R_REF_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),       \
                              R_REF_TYPE, RRefClass))

#define IS_R_REF(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj), R_REF_TYPE))
#define IS_R_REF_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls),    R_REF_TYPE))

#define R_REF_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),       \
                              R_REF_TYPE, RRefClass))


typedef struct _RRef        RRef;
typedef struct _RRefClass   RRefClass;
typedef struct _RRefPrivate RRefPrivate;


struct _RRef
{
  GObject parent;

  RRefPrivate* private;
};


struct _RRefClass
{
  GObjectClass parent;
};


GType    r_ref_get_type (void);


RRef*    r_ref_new  (glong id);
void     r_ref_free (RRef* ref);

RRef*    r_ref_copy (RRef* ref);
gboolean r_ref_check (RRef* ref, const gchar* property, gchar** value);

#endif
