/*
*  RAL -- Rubrica Addressbook Library
*  file: types.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_TYPES_H
#define _R_TYPES_H


#include <glib.h>


typedef enum {
  SEARCH_ON_STRING,             /* search a string                         */
  SEARCH_ON_CREATION,           /* search creation date that is given      */
  SEARCH_ON_CHANGE,             /* search change date that is given        */
  SEARCH_CREATION_BEFORE,       /* search a creation date before given     */
  SEARCH_CREATION_AFTER,        /*    "                    after given     */
  SEARCH_CREATION_BETWEEN,      /*    "       between first and second     */
  SEARCH_CHANGE_BEFORE,         /* search a last change date before given  */
  SEARCH_CHANGE_AFTER,          /*    "                       after given  */
  SEARCH_CHANGE_BETWEEN,        /*    "        between first and second    */
} SearchType;


typedef enum {
  R_CARD_DELETED,
  R_CARD_UNDELETED,
  R_CARD_HAS_REFS
} RDelType;


typedef void (*RFunc) (gpointer obj, gpointer user_data);


typedef struct {
  glong  id;           /* card id                     */
  gchar *label;        /* card label                  */
  gchar *first;        /* contact's first name        */
  gchar *last;         /* contact's last name         */
  gchar *prof;         /* contact's profession        */
  gchar *city;         
  gchar *country;
  gchar *assignment;   /* contact's assignmet         */
  gchar *web;          /* contact's home page         */
  gchar *email;        /* contact's email             */
  gchar *irc;
  gchar *telephone;    /* contact's telephone number  */
} RInfos;


#define r_infos_get_id(x)          (x->id)
#define r_infos_get_label(x)       (x->label)
#define r_infos_get_first(x)       (x->first)
#define r_infos_get_last(x)        (x->last)
#define r_infos_get_profession(x)  (x->prof)
#define r_infos_get_city(x)        (x->city)
#define r_infos_get_country(x)     (x->country)
#define r_infos_get_assignment(x)  (x->assignment)
#define r_infos_get_web(x)         (x->web)
#define r_infos_get_email(x)       (x->email)
#define r_infos_get_irc(x)         (x->irc)
#define r_infos_get_telephone(x)   (x->telephone)


#endif
