/*
*  RAL -- Rubrica Addressbook Library
*  file: work.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_WORK_H
#define _R_WORK_H

#include <glib.h>
#include <glib-object.h>


#define R_WORK_TYPE            (r_work_get_type())

#define R_WORK(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),      \
                                R_WORK_TYPE, RWork))

#define R_WORK_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),       \
                                R_WORK_TYPE, RWorkClass))

#define IS_R_WORK(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), R_WORK_TYPE))

#define IS_R_WORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),  R_WORK_TYPE))

#define R_WORK_GET_CLASS(klass) (G_TYPE_INSTANCE_GET_CLASS((klass),     \
                                 R_WORK_TYPE, RWorkClass))


typedef struct _RWork        RWork;
typedef struct _RWorkClass   RWorkClass;
typedef struct _RWorkPrivate RWorkPrivate;


struct _RWork
{
  GObject parent; 

  RWorkPrivate* priv;
};


struct _RWorkClass
{
  GObjectClass parent_class;
};


GType  r_work_get_type    (void);
 

RWork*   r_work_new       (void);
void     r_work_free      (RWork* work);

gboolean r_work_check     (RWork* work, const gchar* property, gchar** value);
gboolean r_work_have_data (RWork* work);
gboolean r_work_search    (RWork* work, const gchar* str);

RWork*   r_work_copy      (RWork* work);


#endif
