/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <klocale.h>

//kX Generator Includes
#include <qstring.h>
#include "kxgenerator.h"
#include "ServerLayoutWidget.h"
#include "MouseWidget.h"
#include "GlobalFunctions.h"
#include "KeyboardWidget.h"
#include "VideocardWidget.h"
#include "MonitorWidget.h"
#include "AdvancedWidget.h"
#include "ChangeEntriesDialog.h"
#include "PropertiesDialog.h"
#include "LayoutWriter.h"

#include "Xorg.h"
#include "properties.h"

#include "ScreenModesEditor.h"


#define ERR "ERROR"

QString kXGeneratorMain :: Locale (int n)
{
if (n == 0) { return i18n("Server Layout"); }
if (n == 1) { return i18n("Pointer"); }
if (n == 2) { return i18n("Keyboard"); }
if (n == 3) { return i18n("Video Card"); }
if (n == 4) { return i18n("Display"); }
if (n == 5) { return i18n("Advanced Settings"); }
if (n == 6) { return i18n("Accept"); }
if (n == 7) { return i18n("Quit"); }
if (n == 8) { return i18n("Do you really want to quit? Settings will NOT be saved!"); }
if (n == 9) { return i18n("Quit?"); }
if (n == 10) { return i18n("About..."); }
if (n == 11) { return i18n("Choose ServerLayout"); }
if (n == 12) { return i18n("General options"); }
if (n == 13) { return i18n("Default Server Layout:"); }
if (n == 500) { return i18n("kX Generator"); }
return ERR;
}

QString ServerLayoutWidget :: Locale (int n)
{
if (n == 0) { return i18n("Server Layout"); }
if (n == 1) { return i18n("Add"); }
if (n == 2) { return i18n("Change entries..."); }
if (n == 3) { return i18n("Pointers"); }
if (n == 4) { return i18n("Keyboards"); }
if (n == 5) { return i18n("Screens"); }
if (n == 6) { return i18n("Add..."); }
if (n == 7) { return i18n("Remove"); }
if (n == 8) { return i18n("Rename"); }
if (n == 9) { return i18n("Here you can modify all pointer devices that will be connected when X start with current Server Layout."); }
if (n == 10) { return i18n("Core Pointer"); }
if (n == 11) { return i18n("Here you can modify all keyboard devices that will be connected when X start with current Server Layout."); }
if (n == 12) { return i18n("Here you can modify screens connected to server."); }
if (n == 13) { return i18n("This pointer is already on the list."); }
if (n == 14) { return i18n("There should be at least one pointer entry."); }
if (n == 15) { return i18n("This keyboard is already on the list."); }
if (n == 16) { return i18n("There should be at least one keyboard entry."); }
if (n == 17) { return i18n("This screen is already on the list."); }
if (n == 18) { return i18n("There should be at least one screen entry."); }
if (n == 19) { return i18n("Remove"); }
if (n == 20) { return i18n("Add new section"); }
if (n == 21) { return i18n("Select name for new section:"); }
if (n == 22) { return i18n("Rename section"); }
if (n == 23) { return i18n("Select new name for new section %1:"); }
if (n == 24) { return i18n("This identifier is already used by another section."); }
if (n == 25) { return i18n("Identifier in use"); }
if (n == 26) { return i18n("Are you sure you want to remove section %1?"); }
if (n == 27) { return i18n("Section removal"); }


if (n == 500) { return i18n("Error"); }

return ERR;
}

QString MouseWidget :: Locale (int n)
{
if (n == 0) { return i18n("Pointer"); }
if (n == 1) { return i18n("&Change entries..."); }
if (n == 2) { return i18n("Advanced"); }
if (n == 3) { return i18n("Driver:"); }
if (n == 4) { return i18n("Device:"); }
if (n == 5) { return i18n("Driver description"); }
if (n == 6) { return i18n("Autodetect"); }
if (n == 7) { return i18n("Cannot find required input driver %1 on system. Please select another driver."); }
if (n == 8) { return i18n("Error!"); }
if (n == 9) { return i18n("Properties dialog for driver %1 is not implemented yet."); }

return ERR;
}

QString GlobalFunctions :: Locale (int n)
{
if (n == 0) { return i18n("Add pointer"); }
if (n == 1) { return i18n("Please select pointer device you wish to add from the list:"); }

if (n == 2) { return i18n("Add keyboard"); }
if (n == 3) { return i18n("Please select keyboard device you wish to add from the list:"); }

if (n == 4) { return i18n("Add screen"); }
if (n == 5) { return i18n("Please select screen you wish to add from the list:"); }

if (n == 6) { return i18n("Default ServerLayout"); }
if (n == 7) { return i18n("Please select Server Layout that will be used as default from the list:"); }


if (n == 200) { return i18n("Mouse"); }

if (n == 300) { return i18n("NVidia Accelerated Graphics Driver\n\nThis is non-free driver supplied by\nNVIDIA corporation."); }
if (n == 301) { return i18n("Vesa is an Xorg driver for generic VESA video cards. It can drive most VESA-compatible video cards, but only makes use of the basic standard VESA core that is common to these cards. The driver supports depths 8, 15 16 and 24."); }

if (n == 1000) { return i18n("No description yet!"); }
return ERR;
}

QString KeyboardWidget :: Locale(int n)
{
if (n == 0) { return i18n("Keyboard"); }
if (n == 1) { return i18n("&Change entries..."); }
if (n == 2) { return i18n("Driver:"); }
if (n == 3) { return i18n("Layout:"); }
if (n == 4) { return i18n("Model:"); }
if (n == 5) { return i18n("Device:"); }
if (n == 6) { return i18n("Protocol:"); }
if (n == 7) { return i18n("Auto Repeat:"); }
if (n == 8) { return i18n("Delay before repeating (ms):"); }
if (n == 9) { return i18n("Repeat rate:"); }
if (n == 10) { return i18n("Autodetect"); }




if (n == 999) { return i18n("Not specified"); }
if (n == 1000) { return i18n("af - Afrikaans"); }
if (n == 1001) { return i18n("ar - Arabic"); }
if (n == 1002) { return i18n("bg - Bulgarian"); }
if (n == 1003) { return i18n("bo - Tibetan"); }
if (n == 1004) { return i18n("br - Breton"); }
if (n == 1005) { return i18n("ca - Catalan"); }
if (n == 1006) { return i18n("cs - Czech"); }
if (n == 1007) { return i18n("cy - Welsh"); }
if (n == 1008) { return i18n("da - Danish"); }
if (n == 1009) { return i18n("de - German"); }
if (n == 1010) { return i18n("el - Greek"); }
if (n == 1011) { return i18n("en_GB - English (Great Britain)"); }
if (n == 1012) { return i18n("en_US - English (United States)"); }
if (n == 1013) { return i18n("eo - Esperanto"); }
if (n == 1014) { return i18n("es - Spanish"); }
if (n == 1015) { return i18n("et - Estonian"); }
if (n == 1016) { return i18n("eu - Basque"); }
if (n == 1017) { return i18n("fi - Finnish"); }
if (n == 1018) { return i18n("fr - French"); }
if (n == 1019) { return i18n("ga - Irish"); }
if (n == 1020) { return i18n("gl - Galician"); }
if (n == 1021) { return i18n("gu - Gujarati"); }
if (n == 1022) { return i18n("he - Hebrew"); }
if (n == 1023) { return i18n("hi - Hindi"); }
if (n == 1024) { return i18n("hu - Hungarian"); }
if (n == 1025) { return i18n("id - Indonesian"); }
if (n == 1026) { return i18n("is - Icelandic"); }
if (n == 1027) { return i18n("it - Italian"); }
if (n == 1028) { return i18n("ja - Japanese"); }
if (n == 1029) { return i18n("km - Cambodian"); }
if (n == 1030) { return i18n("ko - Korean"); }
if (n == 1031) { return i18n("lt - Lithuanian"); }
if (n == 1032) { return i18n("lv - Latvian (Lettish)"); }
if (n == 1033) { return i18n("mi - Maori"); }
if (n == 1034) { return i18n("mk - Macedonian"); }
if (n == 1035) { return i18n("mr - Marathi"); }
if (n == 1036) { return i18n("nl - Dutch"); }
if (n == 1037) { return i18n("no - Norwegian"); }
if (n == 1038) { return i18n("oc - Occitan"); }
if (n == 1039) { return i18n("pl - Polish"); }
if (n == 1040) { return i18n("pt - Portuguese"); }
if (n == 1041) { return i18n("ro - Romanian"); }
if (n == 1042) { return i18n("ru - Russian"); }
if (n == 1043) { return i18n("sk - Slovak"); }
if (n == 1044) { return i18n("sl - Slovenian"); }
if (n == 1045) { return i18n("sr - Serbian"); }
if (n == 1046) { return i18n("sv - Swedish"); }
if (n == 1047) { return i18n("ta - Tamil"); }
if (n == 1048) { return i18n("th - Thai"); }
if (n == 1049) { return i18n("tr - Turkish"); }
if (n == 1050) { return i18n("uk - Ukrainian"); }

if (n == 2000) { return i18n("Not specified"); }
if (n == 2001) { return i18n("PC-105"); }              //pc105
if (n == 2002) { return i18n("PC-104"); }              //pc104
if (n == 2003) { return i18n("Logicordless"); }        //logicordless
if (n == 2004) { return i18n("Macintosh"); }           //macintosh
if (n == 2005) { return i18n("PC-98"); }               //pc98
if (n == 2006) { return i18n("Solaris 8 on x86"); }    //pc101_sol8x86

if (n == 2010) { return i18n("Standard"); }            //Standard
if (n == 2011) { return i18n("Xqueue"); }              //Xqueue




return ERR;
}

QString Xorg :: Locale(int n)
{
if (n == 0) { 
QString ToRet = QString("# X Server Configuration file generated by ").append(APPNAME).append(" ").append(APPVERSION).append("\n");
ToRet = ToRet.append("# (c) ").append(APPYEAR).append(" ").append(APPAUTHOR).append("\n");


return ToRet;
}
return ERR;
}

QString VideocardWidget :: Locale(int n)
{
if (n == 0) { return i18n("Video Card"); }
if (n == 1) { return i18n("Change entries..."); }
if (n == 2) { return i18n("Advanced"); }
if (n == 3) { return i18n("Driver:"); }
if (n == 4) { return i18n("Vendor name:"); }
if (n == 5) { return i18n("Driver information"); }
if (n == 6) { return i18n("Error!"); }
if (n == 7) { return i18n("Properties dialog for driver %1 is not implemented yet."); }



return ERR;
}

QString MonitorWidget :: Locale(int n)
{
if (n == 0) { return i18n("Display"); }
if (n == 1) { return i18n("Here you can modify display properties - display modes, refresh rates, monitor information."); }
if (n == 2) { return i18n("Monitor"); }
if (n == 3) { return i18n("Screen"); }
if (n == 4) { return i18n("Monitor:"); }
if (n == 5) { return i18n("Change entries..."); }
if (n == 6) { return i18n("Vendor:"); }
if (n == 7) { return i18n("Model:"); }
if (n == 8) { return i18n("Monitor is DPMS compilant"); }
if (n == 9) { return i18n("Monitor:"); }
if (n == 10) { return i18n("Video card:"); }
if (n == 11) { return i18n("Screen:"); }
if (n == 12) { return i18n("Screen modes..."); }

return ERR;
}

QString AdvancedWidget :: Locale(int n)
{
if (n == 0) { return i18n("Advanced settings"); }
if (n == 1) { return i18n("In this section you can modify advanced X properties - file paths, modules and extensions."); }
if (n == 2) { return i18n("Files"); }
if (n == 3) { return i18n("Modules"); }
if (n == 4) { return i18n("Extensions"); }
if (n == 5) { return i18n("Add"); }
if (n == 6) { return i18n("Remove"); }
if (n == 7) { return i18n("Add module"); }
if (n == 8) { return i18n("Type the name of module you wish to add:"); }
if (n == 9) { return i18n("Module %1 is already on the list."); }
if (n == 10) { return i18n("Error."); }
if (n == 11) { return i18n("Do you really want to remove module %1?"); }
if (n == 12) { return i18n("Module removal"); }
if (n == 13) { return i18n("RGB path:"); }
if (n == 14) { return i18n("Font paths:"); }
if (n == 15) { return i18n("Module paths:"); }
if (n == 16) { return i18n("Remove"); }
if (n == 17) { return i18n("Enable Xinerama extension"); }
if (n == 18) { return i18n("Enable Composite extension"); }
if (n == 19) { return i18n("Options"); }
if (n == 20) { return i18n("Disable use of CTRL-ALT-BACKSPACE"); }
if (n == 21) { return i18n("Disable VT switching"); }
if (n == 22) { return i18n("Disable zooming"); }
if (n == 23) { return i18n("Japanese PC-98 machine"); }
if (n == 24) { return i18n("Start X server even if pointer cannot be initialized"); }
if (n == 25) { return i18n("More options..."); }





return ERR;
}

QString ScreenModesEditor :: Locale (int n)
{
if (n == 0) { return i18n("X Screen Modes Editor"); }
if (n == 1) { return i18n("Screen Modes Editor"); }
if (n == 2) { return i18n("Here you can modify screen modes and depths that X will validate on startup. Remember that X will use first validated mode on list as default."); }
if (n == 3) { return i18n("OK"); }
if (n == 4) { return i18n("Apply"); }
if (n == 5) { return i18n("Cancel"); }
if (n == 6) { return i18n("Add mode..."); }
if (n == 7) { return i18n("Settings for: "); }
if (n == 8) { return i18n("Remove mode"); }
if (n == 9) { return i18n("Display size"); }
if (n == 10) { return i18n("Refresh rates"); }
if (n == 11) { return i18n("Horizontal sync:"); }
if (n == 12) { return i18n("Vertical refresh:"); }
if (n == 13) { return i18n("Add mode..."); }
if (n == 14) { return i18n("Add mode..."); }
if (n == 15) { return i18n("Mode:"); }
if (n == 16) { return i18n("Refresh rate:"); }
return ERR;
}

QString ChangeEntriesDialog :: Locale (int n)
{
if (n == 0) { return i18n("Server Layout"); }
if (n == 1) { return i18n("Pointer"); }
if (n == 2) { return i18n("Keyboard"); }
if (n == 3) { return i18n("Device"); }
if (n == 4) { return i18n("Monitor"); }
if (n == 5) { return i18n("Screen"); }
if (n == 6) { return i18n("Entries editor - "); }
if (n == 7) { return i18n("Here you can modify all %1 sections that are present in configuration file."); }
if (n == 8) { return i18n("Entries Editor"); }
if (n == 9) { return i18n("OK"); }
if (n == 10) { return i18n("Cancel"); }
if (n == 11) { return i18n("Add"); }
if (n == 12) { return i18n("Remove"); }
if (n == 13) { return i18n("Rename"); }
if (n == 14) { return i18n("New section"); }
if (n == 15) { return i18n("Enter name for new section:"); }
if (n == 16) { return i18n("This identifier is taken."); }
if (n == 17) { return i18n("Error"); }
if (n == 18) { return i18n("Are you sure you want to remove section %1?"); }
if (n == 19) { return i18n("Section removal"); }
if (n == 20) { return i18n("There should be at least one section available."); }
if (n == 21) { return i18n("Section renaming"); }
if (n == 22) { return i18n("Enter new identifier:"); }

return ERR;
}

QString PropertiesDialog :: Locale (int n)
{
if (n == 0) { return i18n("Properties"); }
if (n == 1) { return i18n("OK"); }
if (n == 2) { return i18n("Cancel"); }
if (n == 5) { return i18n("Properties dialog for driver %1"); }

if (n == 3) { return i18n("General"); }
if (n == 4) { return i18n("Protocol:"); }
if (n == 6) { return i18n("Here you can configure mouse options. Note that these are for advanced users only, so modify them at your own risk."); }
if (n == 7) { return i18n("Autodetect"); }
if (n == 8) { return i18n("Baud rate:"); }
if (n == 9) { return i18n("Number of buttons:"); }
if (n == 10) { return i18n("Sample rate:"); }
if (n == 11) { return i18n("Resolution:"); }
if (n == 12) { return i18n("Middle button sends L+R button event"); }
if (n == 13) { return i18n("Clear DTR"); }
if (n == 14) { return i18n("Clear RTS"); }
if (n == 15) { return i18n("Flip X axis"); }
if (n == 16) { return i18n("Flip Y axis"); }
if (n == 17) { return i18n("Angle offset"); }
if (n == 18) { return i18n("Cursor motion angle offset:"); }
if (n == 19) { return i18n("Emulate 3 buttons"); }
if (n == 20) { return i18n("Timeout:"); }
if (n == 21) { return i18n("Wheel button emulation"); }
if (n == 22) { return i18n("Button:"); }
if (n == 23) { return i18n("Wheel inertia (in pixels):"); }
if (n == 24) { return i18n("Timeout (ms):"); }
if (n == 25) { return i18n("Entry:"); }
if (n == 26) { return i18n("Swap X and Y axis"); }
if (n == 27) { return i18n("Specify the mouse protocol. Not all protocols are supported on all platforms. The \"Auto\" platform specifies that protocol auto-detection should be attempted. There is no default protocol setting, and specifying this option is mandatory."); }
if (n == 28) { return i18n("Set the baud rate to use for communicating with a serial mouse. This option should rarely be required because the default is correct for almost all situations."); }
if (n == 29) { return i18n("Specifies the number of mouse buttons. In cases where the number of buttons cannot be auto-detected, the default value is 3."); }
if (n == 30) { return i18n("Sets the number of motion/button events the mouse sends per second. Setting this is only supported for some mice, including some Logitech mice and some PS/2 mice on some platforms. Default: whatever the mouse is already set to."); }
if (n == 31) { return i18n("Sets the resolution of the device in counts per inch. Setting this is only supported for some mice, including some PS/2 mice on some platforms. Default: whatever the mouse is already set to."); }
if (n == 32) { return i18n("Enable/disable handling of mice that send left+right events when the middle button is used. Default: off."); }
if (n == 33) { return i18n("Enable/disable clearing the DTR line on the serial port used by the mouse. Some dual-protocol mice require the DTR line to be cleared to operate in the non-default protocol. This option is for serial mice only. Default: off."); }
if (n == 34) { return i18n("Enable/disable clearing the RTS line on the serial port used by the mouse. Some dual-protocol mice require the RTS line to be cleared to operate in the non-default protocol. This option is for serial mice only. Default: off."); }
if (n == 35) { return i18n("Invert the X axis. Default: off."); }
if (n == 36) { return i18n("Invert the Y axis. Default: off."); }
if (n == 37) { return i18n("Enable/disable swapping the X and Y axes."); }
if (n == 38) { return i18n("Specify a clockwise angular offset (in degrees) to apply to the pointer motion."); }
if (n == 39) { return i18n("Enable/disable the emulation of the third (middle) mouse button for mice which only have two physical buttons. The third button is emulated by pressing both buttons simultaneously. Default: off"); }
if (n == 40) { return i18n("Sets the timeout (in milliseconds) that the driver waits before deciding if two buttons where pressed \"simultaneously\" when 3 button emulation is enabled. Default: 50."); }
if (n == 41) { return i18n("Enable/disable \"wheel\" emulation. Wheel emulation means emulating button press/release events when the mouse is moved while a specific real button is pressed. Wheel button events (typically buttons 4 and 5) are usually used for scrolling. Wheel emulation is useful for getting wheel-like behaviour with trackballs. It can also be useful for mice with 4 or more buttons but no wheel. Default: off."); }
if (n == 42) { return i18n("Specifies which button must be held down to enable wheel emulation mode. While this button is down, X and/or Y pointer movement will generate button press/release events."); }


if (n == 43) { return i18n("Specifies how far (in pixels) the pointer must move to generate button press/release events in wheel emulation mode. Default: 50."); }
if (n == 44) { return i18n("Here you can configure options for your video card. If you video card is working properly, don't change anything."); }
if (n == 45) { return i18n("CRTC Number:"); }
if (n == 46) { return i18n("Hardware cursor"); }
if (n == 47) { return i18n("Hardware acceleration"); }
if (n == 48) { return i18n("OS Specific framebuffer interface"); }
if (n == 49) { return i18n("Shadow framebuffer layer"); }
if (n == 50) { return i18n("Rotation"); }
if (n == 51) { return i18n("Clockwise"); }
if (n == 52) { return i18n("Counter-clockwise"); }
if (n == 53) { return i18n("Force use of Digital Flat Panel"); }
if (n == 54) { return i18n("Flat Panel Dithering"); }
if (n == 55) { return i18n("Flat Panel Resolution Scaling"); }
if (n == 56) { return i18n("GeForce2 MX, nForce2, Quadro4, GeForce4, Quadro FX and GeForce FX may have two video outputs. The driver attempts to autodetect which one the monitor is connected to. In the case that autodetection picks the wrong one, this option may be used to force usage of a particular output. The options are \"0\" or \"1\". Default: autodetected."); }
if (n == 57) { return i18n("Enable or disable the HW cursor. Default: on."); }
if (n == 58) { return i18n("Disable or enable acceleration. Default: acceleration is enabled."); }
if (n == 59) { return i18n("Enable or disable use of on OS-specific fb interface (and is not supported on all OSs). Default: off."); }
if (n == 60) { return i18n("Enable or disable use of the shadow framebuffer layer. Default: off."); }
if (n == 61) { return i18n("Rotate the display clockwise or counterclockwise. This mode is unaccelerated. Default: no rotation. Note: The Resize and Rotate extension will be disabled if the Rotate option is used."); }
if (n == 62) { return i18n("The driver usually can autodetect the presence of a digital flat panel. In the case that this fails, this option can be used to force the driver to treat the attached device as a digital flat panel. With this driver, a digital flat panel will only work if it was POSTed by the BIOS, that is, the machine must have booted to the panel. If you have a dual head card you may also need to set the option CRTC Number. Default: off."); }
if (n == 63) { return i18n("Many digital flat panels (particularly ones on laptops) have only 6 bits per component color resolution. This option tells the driver to dither from 8 bits per component to 6 before the flat panel truncates it. This is only supported in depth 24 on GeForce2 MX, nForce2, GeForce4, Quadro4, Geforce FX and Quadro FX. Default: off."); }
if (n == 64) { return i18n("Enable/disable resolution scaling on flat panel."); }
if (n == 65) { return i18n("Here you can configure your WACOM tablet options."); }
if (n == 66) { return i18n("Type:"); }
if (n == 67) { return i18n("Stylus"); }
if (n == 68) { return i18n("Eraser"); }
if (n == 69) { return i18n("Cursor"); }
if (n == 70) { return i18n("default"); }
if (n == 71) { return i18n("Mode:"); }
if (n == 72) { return i18n("Relative"); }
if (n == 73) { return i18n("Absolute"); }
if (n == 74) { return i18n("Use USB"); }
if (n == 75) { return i18n("Enable tilt report"); }
if (n == 76) { return i18n("Always Core"); }
if (n == 77) { return i18n("Keep Shape"); }
if (n == 78) { return i18n("Other options"); }
if (n == 79) { return i18n("History size:"); }
if (n == 80) { return i18n("Serial number:"); }
if (n == 81) { return i18n("Threshold:"); }
if (n == 82) { return i18n("Debug level:"); }
if (n == 83) { return i18n("Device name:"); }
if (n == 84) { return i18n("Coordinates"); }
if (n == 85) { return i18n("Top X:"); }
if (n == 86) { return i18n("Top Y:"); }
if (n == 87) { return i18n("Bottom X:"); }
if (n == 88) { return i18n("Bottom Y:"); }

if (n == 89) { return i18n("General Options"); }
if (n == 90) { return i18n("TwinView Options"); }
if (n == 91) { return i18n("Cursor, TV & DFP Options"); }
if (n == 92) { return i18n("Other Options"); }

if (n == 93) { return i18n("&No logo"); }
if (n == 94) { return i18n("&Hardware acceleration of RENDER extension"); }
if (n == 95) { return i18n("&Disable RENDER extension"); }
if (n == 96) { return i18n("&UBB"); }
if (n == 97) { return i18n("&Enable window flipping"); }
if (n == 98) { return i18n("Enable &page flipping"); }
if (n == 99) { return i18n("Dac 8 &bit"); }
if (n == 100) { return i18n("Enable &RGB workstation overlay visuals"); }
if (n == 101) { return i18n("Enable color &index workstation overlay visuals"); }
if (n == 102) { return i18n("Defau&lt overlay visual"); }
if (n == 103) { return i18n("Use EDID &frequencies"); }
if (n == 104) { return i18n("Disable p&robing of EDID"); }

if (n == 105) { return i18n("Stereo (only Quadro chipsets"); }
if (n == 106) { return i18n("Custom AGP settings"); }
if (n == 107) { return i18n("Digital vibrance"); }

if (n == 108) { return i18n("DDC glasses"); }
if (n == 109) { return i18n("Blueline glasses"); }
if (n == 110) { return i18n("Onboard stereo support"); }
if (n == 111) { return i18n("TwinView clone mode stereo (\"passive\" stereo)"); }

if (n == 112) { return i18n("Disable AGP"); }
if (n == 113) { return i18n("Use NVIDIA's internal AGP support if possible"); }
if (n == 114) { return i18n("Use AGPGART if possible"); }
if (n == 115) { return i18n("Use any AGP support (AGPGART then NVIDIA)"); }

if (n == 116) { return i18n("Enable TwinView"); }
if (n == 117) { return i18n("TwinView orientation:"); }

if (n == 118) { return i18n("Right Of"); }
if (n == 119) { return i18n("Left Of"); }
if (n == 120) { return i18n("Above"); }
if (n == 121) { return i18n("Below"); }
if (n == 122) { return i18n("Clone"); }

if (n == 123) { return i18n("2nd monitor horizontal sync:"); }
if (n == 124) { return i18n("2nd monitor vertical refresh:"); }
if (n == 125) { return i18n("1st connected monitor:"); }
if (n == 126) { return i18n("2nd connected monitor:"); }

if (n == 127) { return i18n("CRT"); }
if (n == 128) { return i18n("DFP"); }
if (n == 129) { return i18n("TV"); }

if (n == 130) { return i18n("<b>Note: </b>Use EDID to probe your TV's capabilities, setting too high values can damage your TV!"); }

if (n == 131) { return i18n("1st display"); }
if (n == 132) { return i18n("2nd display"); }

if (n == 133) { return i18n("MetaModes"); }
if (n == 134) { return i18n("Force hardware cursor"); }
if (n == 135) { return i18n("Force software cursor"); }
if (n == 136) { return i18n("Cursor shadow"); }
if (n == 137) { return i18n("Cursor shadow alpha"); }
if (n == 138) { return i18n("Cursor shadow X offset"); }
if (n == 139) { return i18n("Cursor shadow Y offset"); }
if (n == 140) { return i18n("TV Options"); }
if (n == 141) { return i18n("TV Standard:"); }
if (n == 142) { return i18n("TV-Out format:"); }
if (n == 143) { return i18n("TV Overscan:"); }
if (n == 144) { return i18n("DFP Options"); }
if (n == 145) { return i18n("Scaling:"); }
if (n == 146) { return i18n("Dithering:"); }
if (n == 147) { return i18n("Default"); }
if (n == 148) { return i18n("Use DFP's scaler"); }
if (n == 149) { return i18n("Use NVIDIA's scaler"); }
if (n == 150) { return i18n("Center image"); }
if (n == 151) { return i18n("Aspect-scale"); }
if (n == 152) { return i18n("Enabled"); }
if (n == 153) { return i18n("Disabled"); }
if (n == 154) { return i18n("No TwinView Xinerama info"); }
if (n == 155) { return i18n("Use hardware clip ID buffers"); }
if (n == 156) { return i18n("No bandwidth test"); }
if (n == 157) { return i18n("Multisample compatibility"); }
if (n == 158) { return i18n("Ignore display devices"); }
if (n == 159) { return i18n("Add..."); }
if (n == 160) { return i18n("Remove"); }
if (n == 161) { return i18n("This option tells NVIDIA kernel module to completely ignore the indicated classes of display devices when checking what display devices are connected."); }
if (n == 162) { return i18n("Add device..."); }
if (n == 163) { return i18n("Please select device type to ignore:"); }
if (n == 164) { return i18n("Error!"); }
if (n == 165) { return i18n("This device is already on list."); }
if (n == 166) { return i18n("You must type at least one MetaMode to continue."); }
if (n == 167) { return i18n("Incorrect horizontal sync values."); }
if (n == 168) { return i18n("Incorrect vertical refresh values."); }
if (n == 169) { return i18n("Enter at least one device to ignore."); }
if (n == 170) { return i18n("Sorry"); }
if (n == 171) { return i18n("Driver %1 has no properties to set."); }
if (n == 172) { return i18n("Disable shadow framebuffer"); }
if (n == 173) { return i18n("Enable shadow framebuffer layer"); }
if (n == 174) { return i18n("Enable hardware cursor"); }
if (n == 175) { return i18n("Disable hardware acceleration"); }
if (n == 176) { return i18n("Combine sync signals with green signal"); }
if (n == 177) { return i18n("Reduce DAC operations to 6-bit"); }
if (n == 178) { return i18n("Debug mode"); }
if (n == 179) { return i18n("General options"); }
if (n == 180) { return i18n("i810 and i815 options"); }
if (n == 181) { return i18n("830M options"); }
if (n == 182) { return i18n("Enable software cursor"); }
if (n == 183) { return i18n("Color key:"); }
if (n == 184) { return i18n("Cache lines:"); }
if (n == 185) { return i18n("Enable DRI support"); }
if (n == 186) { return i18n("Enable DDC support"); }
if (n == 187) { return i18n("Enable 6-bits per RGB for 8-bit modes"); }
if (n == 188) { return i18n("Enable XvMC:"); }
if (n == 189) { return i18n("Restore VBE"); }
if (n == 190) { return i18n("Enable XVideo support"); }
if (n == 191) { return i18n("Enable clone mode"); }
if (n == 192) { return i18n("Clone refresh rate:"); }
if (n == 193) { return i18n("Check lid"); }
if (n == 194) { return i18n("Switch primary screen to alternate pipe"); }
if (n == 195) { return i18n("Display info"); }
if (n == 196) { return i18n("Detect connected monitors"); }
if (n == 197) { return i18n("Rotate clockwise"); }
if (n == 198) { return i18n("Rotate counterclockwise"); }
if (n == 199) { return i18n("Enable shadow framebuffer layer"); }
if (n == 200) { return i18n("Monitor layout (pipe A/B):"); }


return ERR;


}

QString LayoutWriter :: Locale (int n)
{
if (n == 0) { return i18n("Write error!"); }
if (n == 1) { return i18n("Cannot write to "); }
if (n == 2) { return i18n("Please check if you have write permissions for this file."); }

return ERR;
}
