/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XORG_H
#define XORG_H

#include <qstring.h>
#include <qstringlist.h>

class Xorg 
{
public:


//Section enumeration
    enum Section
               {
                ServerLayout,
                ServerFlags,
                Files,
                Modules,
                Extensions,
                InputDevice,
                Device,
                Monitor,
                Screen,
                Other
               };

    enum Property
               {
                PathToConfigFile,
                PathToVideoDrv,
                PathToInputDrv,
                PathToHw
               };



//Functions - boolean


bool isKeyboard(int SectionNumber);
bool isKeyboard(QString Identifier);
bool isPointer(QString Identifier);
bool isValuePresent(QString ValueName, QString Value);
bool GetBoolOption(Section SectionName, int SectionNumber, QString OptionName);

//Functions - QString
QString GetProperty(Property Prop);
QString GetValue(Section SectionName, int SectionNumber, QString ValueName, int ValueNumber);
QString GetLineBreakValue(Section SectionName, int SectionNumber, QString ValueName, int ValueNumber);
QString GetOption(Section SectionName, int SectionNumber, QString ValueName);
QString LayoutTranslate(int ComboNumber);
QString ModelTranslate (int ModelNumber);
QString ProtocolTranslate (int ProtocolNumber);

QString DumpConfiguration();
QString DumpSection(Section SectionName, int SectionNumber);

QString Locale (int n);

//Functions - integer
int CountSections(Section SectionName);
int CountValues(Section SectionName, int SectionNumber, QString ValueName);
int PointerTranslate(int PointerNumber);
int KeyboardTranslate(int KeyboardNumber);


int LayoutTranslate(QString LayoutName);                       //Only keyboard
int ModelTranslate(QString ModelName);                         //Only keyboard
int ProtocolTranslate(QString ProtocolName);                   //Only keyboard


//Functions - void
void WriteValue(Section SectionName, int SectionNumber, QString ValueName, QString ValueEntry);
void WriteOption(Section SectionName, int SectionNumber, QString ValueName, QString ValueEntry);
void AppendValue(Section SectionName, int SectionNumber, QString ValueName, QString ValueEntry);
void RemoveValue(Section SectionName, int SectionNumber, QString ValueName, QString ValueEntry);
void RemoveValue(Section SectionName, int SectionNumber, QString ValueName);
void RemoveOption(Section SectionName, int SectionNumber, QString ValueName);
void RemoveSection(Section SectionName, int SectionNumber);
void LoadConfig(QString XorgFile, QString PathToVideoDrivers, QString PathToInputDrivers, QString PathToHwConf);
void AppendLine(Section SectionName, int SectionNumber, QString Value);
void WriteLineBreakValue(Section SectionName, int SectionNumber, QString ValueName, QString ValueEntry);
void AppendLineBreakValue(Section SectionName, int SectionNumber, QString ValueName, QString ValueEntry);
void AddSection(Section SectionName, QString Identifier);
void ReplaceServerLayoutValue(QString OldName, QString NewName);
void ReplaceScreenValue(QString Value, QString OldName, QString NewName);
void RemoveServerLayoutValue(QString Value, QString OldName);
void ClearOptions(Section SectionName, int SectionNumber);
private:
QString ServerLayoutSection[128];
QString ServerFlagsSection;
QString FilesSection;
QString ModulesSection;
QString ExtensionsSection;
QString InputDeviceSection[128];
QString DeviceSection[128];
QString MonitorSection[128];
QString ScreenSection[128];
QString OtherSection[128];
QString WholeFile;
QString Properties[4];

QString GetSection(Section SectionName, int SectionNumber);
};

#endif
