///This file is for author's use only.

#include "PropertiesDialog.h"
#include "properties.h"
#include <iostream.h>
#include <ktabwidget.h>
#include <kiconloader.h>

void PropertiesDialog :: SetOptions_i810(QWidget *Parent, Xorg *Xorg, int SectionNumber)
{
CreateWindow(580, 570, "i810", "kcmpci", Parent);

SecNum = SectionNumber;
X = Xorg;

InformationLabel->setText(Locale(44).append("<br><br>" + Locale(25) + " <b>" + X->GetValue(Xorg::Device, SectionNumber, "Identifier", 1) + "</b>"));

KTabWidget *Tab = new KTabWidget (OptionsDialog);
Tab->setGeometry(10, 160, 560, 350);

QWidget *GeneralTab = new QWidget(Tab);
QWidget *i810Tab = new QWidget(Tab);
QWidget *i830Tab = new QWidget(Tab);


KIconLoader *Icons = new KIconLoader();

Tab->insertTab(GeneralTab, Icons->loadIcon("kcmpci", KIcon::Desktop, KIcon::SizeSmall), Locale(179));
Tab->insertTab(i810Tab, Icons->loadIcon("kcmpci", KIcon::Desktop, KIcon::SizeSmall), Locale(180));
Tab->insertTab(i830Tab, Icons->loadIcon("kcmpci", KIcon::Desktop, KIcon::SizeSmall), Locale(181));


   Check[0] = new QCheckBox(GeneralTab);
    Check[0]->setText(Locale(175));
    Check[0]->setGeometry(10, 10, 300, 25);

   Check[1] = new QCheckBox(GeneralTab);
    Check[1]->setText(Locale(182));
    Check[1]->setGeometry(10, 35, 300, 25);

   Check[2] = new QCheckBox(GeneralTab);
    Check[2]->setText(Locale(183));
    Check[2]->setGeometry(10, 60, 300, 25);

   SpinBox[0] = new KIntSpinBox(GeneralTab);
    SpinBox[0]->setGeometry(480, 60, 70, 25);

   Check[3] = new QCheckBox(GeneralTab);
    Check[3]->setText(Locale(184));
    Check[3]->setGeometry(10, 85, 300, 25);

   SpinBox[1] = new KIntSpinBox(GeneralTab);
    SpinBox[1]->setGeometry(480, 85, 70, 25);

   Check[4] = new QCheckBox(GeneralTab);
    Check[4]->setText(Locale(185));
    Check[4]->setGeometry(10, 110, 300, 25);

   Check[5] = new QCheckBox(i810Tab);
    Check[5]->setText(Locale(186));
    Check[5]->setGeometry(10, 10, 300, 25);

   Check[6] = new QCheckBox(i810Tab);
    Check[6]->setText(Locale(187));
    Check[6]->setGeometry(10, 35, 300, 25);

   Check[7] = new QCheckBox(i810Tab);
    Check[7]->setText(Locale(188));
    Check[7]->setGeometry(10, 60, 300, 25);

   SpinBox[2] = new KIntSpinBox(i810Tab);
    SpinBox[2]->setGeometry(480, 60, 70, 25);
    SpinBox[2]->setMaxValue(7);
    SpinBox[2]->setMinValue(6);

   Check[8] = new QCheckBox(i830Tab);
    Check[8]->setText(Locale(189));
    Check[8]->setGeometry(10, 10, 300, 25);

   Check[9] = new QCheckBox(i830Tab);
    Check[9]->setText(Locale(190));
    Check[9]->setGeometry(10, 35, 300, 25);

   Group[0] = new QGroupBox(i830Tab);
    Group[0]->setTitle(Locale(191));
    Group[0]->setGeometry(10, 60, 540, 55);
    Group[0]->setCheckable(TRUE);

   QLabel *Label = new QLabel(Group[0]);
    Label->setGeometry(10, 20, 300, 25);
    Label->setText(Locale(192));

   SpinBox[3] = new KIntSpinBox(Group[0]);
    SpinBox[3]->setGeometry(460, 20, 70, 25);

Group[0]->setChecked(FALSE);


   Check[10] = new QCheckBox(i830Tab);
    Check[10]->setText(Locale(193));
    Check[10]->setGeometry(10, 120, 300, 25);

   Check[11] = new QCheckBox(i830Tab);
    Check[11]->setText(Locale(194));
    Check[11]->setGeometry(10, 145, 300, 25);

   Check[12] = new QCheckBox(i830Tab);
    Check[12]->setText(Locale(195));
    Check[12]->setGeometry(10, 170, 300, 25);

   Check[13] = new QCheckBox(i830Tab);
    Check[13]->setText(Locale(196));
    Check[13]->setGeometry(10, 195, 300, 25);

   Check[14] = new QCheckBox(i830Tab);
    Check[14]->setText(Locale(197));
    Check[14]->setGeometry(10, 220, 300, 25);

   Check[15] = new QCheckBox(i830Tab);
    Check[15]->setText(Locale(198));
    Check[15]->setGeometry(300, 220, 300, 25);

   Check[16] = new QCheckBox(i830Tab);
    Check[16]->setText(Locale(199));
    Check[16]->setGeometry(10, 245, 300, 25);

   Check[17] = new QCheckBox(i830Tab);
    Check[17]->setGeometry(10, 275, 300, 25);
    Check[17]->setText(Locale(200));

   Combo[0] = new KComboBox(i830Tab);
    Combo[0]->setGeometry(210, 275, 70, 25);

   Combo[1] = new KComboBox(i830Tab);
    Combo[1]->setGeometry(290, 275, 70, 25);

   Combo[2] = new KComboBox(i830Tab);
    Combo[2]->setGeometry(400, 275, 70, 25);

   Combo[3] = new KComboBox(i830Tab);
    Combo[3]->setGeometry(480, 275, 70, 25);


//CRT, LFP, DFP, TV, CRT2, LFP2, DFP2, TV2, NONE

for (int a = 0; a < 4; a++)
  {
   Combo[a]->insertItem("");
   Combo[a]->insertItem("NONE");
   Combo[a]->insertItem("CRT");
   Combo[a]->insertItem("LFP");
   Combo[a]->insertItem("DFP");
   Combo[a]->insertItem("TV");
   Combo[a]->insertItem("CRT2");
   Combo[a]->insertItem("LFP2");
   Combo[a]->insertItem("DFP2");
   Combo[a]->insertItem("TV2");
  }

// Loading...

   if (X->GetBoolOption(Xorg::Device, SecNum, "NoAccel"))
     {
      Check[0]->setChecked(TRUE);
     }
   else
     {
      Check[0]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "SWCursor"))
     {
      Check[1]->setChecked(TRUE);
     }
   else
     {
      Check[1]->setChecked(FALSE);
     }

   if (X->GetOption(Xorg::Device, SecNum, "ColorKey") != "") 
    {
     bool ok;
     Check[2]->setChecked(TRUE);
     SpinBox[0]->setValue(X->GetOption(Xorg::Device, SecNum, "ColorKey").toInt(&ok, 10));
    }
   else
    {
     Check[2]->setChecked(FALSE);
    }

   if (X->GetOption(Xorg::Device, SecNum, "CacheLines") != "") 
    {
     bool ok;
     Check[3]->setChecked(TRUE);
     SpinBox[1]->setValue(X->GetOption(Xorg::Device, SecNum, "CacheLines").toInt(&ok, 10));
    }
   else
    {
     Check[3]->setChecked(FALSE);
    }

   if (X->GetBoolOption(Xorg::Device, SecNum, "DRI"))
     {
      Check[4]->setChecked(TRUE);
     }
   else
     {
      Check[4]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "DDC"))
     {
      Check[5]->setChecked(TRUE);
     }
   else
     {
      Check[5]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "Dac6Bit"))
     {
      Check[6]->setChecked(TRUE);
     }
   else
     {
      Check[6]->setChecked(FALSE);
     }


   if (X->GetOption(Xorg::Device, SecNum, "XvMCSurfaces") != "") 
    {
     bool ok;
     Check[7]->setChecked(TRUE);
     SpinBox[2]->setValue(X->GetOption(Xorg::Device, SecNum, "XvMCSurfaces").toInt(&ok, 10));
    }
   else
    {
     Check[7]->setChecked(FALSE);
    }


   if (X->GetBoolOption(Xorg::Device, SecNum, "VBERestore"))
     {
      Check[8]->setChecked(TRUE);
     }
   else
     {
      Check[8]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "XVideo"))
     {
      Check[9]->setChecked(TRUE);
     }
   else
     {
      Check[9]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "Clone"))
     {
      bool ok;
      Group[0]->setChecked(TRUE); 
      SpinBox[3]->setValue(X->GetOption(Xorg::Device, SecNum, "CloneRefresh").toInt(&ok, 10));
     }
   else
     {
      Group[0]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "CheckLid"))
     {
      Check[10]->setChecked(TRUE);
     }
   else
     {
      Check[10]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "FlipPrimary"))
     {
      Check[11]->setChecked(TRUE);
     }
   else
     {
      Check[11]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "DisplayInfo"))
     {
      Check[12]->setChecked(TRUE);
     }
   else
     {
      Check[12]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "DevicePresence"))
     {
      Check[13]->setChecked(TRUE);
     }
   else
     {
      Check[13]->setChecked(FALSE);
     }

   if (X->GetOption(Xorg::Device, SecNum, "Rotate") == "CW") 
    {
     Check[14]->setChecked(TRUE);
    }
   else
    {
     Check[14]->setChecked(FALSE);
    }

   if (X->GetOption(Xorg::Device, SecNum, "Rotate") == "CCW") 
    {
     Check[15]->setChecked(TRUE);
    }
   else
    {
     Check[15]->setChecked(FALSE);
    }

   if (X->GetBoolOption(Xorg::Device, SecNum, "ShadowFB"))
     {
      Check[16]->setChecked(TRUE);
     }
   else
     {
      Check[16]->setChecked(FALSE);
     }

QString A, B;
QString One, Two, Three, Four;
QString Monitors = X->GetOption(Xorg::Device, SecNum, "MonitorLayout");

if (Monitors != "") { Check[17]->setChecked(TRUE); } else { Check[17]->setChecked(FALSE); }

A = Monitors.section(",", 0, 0);
B = Monitors.section(",", 1, 1);

// Pipe A

if (A.contains("+") > 0) { One = A.section("+", 0, 0); Two = A.section("+", 1, 1); }
if (A.contains("+") == 0) { One = A.section("+", 0, 0); Two = ""; }

//Pipe B

if (B.contains("+") > 0) { Three = B.section("+", 0, 0); Four = B.section("+", 1, 1); }
if (B.contains("+") == 0) { Three = B.section("+", 0, 0); Four = ""; }


for (int x = 0; x < 10; x++)
  {
   if (One == Combo[0]->text(x)) { Combo[0]->setCurrentItem(x); }
   if (Two == Combo[1]->text(x)) { Combo[1]->setCurrentItem(x); }
   if (Three == Combo[2]->text(x)) { Combo[2]->setCurrentItem(x); }
   if (Four == Combo[3]->text(x)) { Combo[3]->setCurrentItem(x); }
  }


///Connecting

connect (Check[2], SIGNAL(clicked()), this, SLOT(i810_CheckSpinBoxes()));
connect (Check[3], SIGNAL(clicked()), this, SLOT(i810_CheckSpinBoxes()));
connect (Check[7], SIGNAL(clicked()), this, SLOT(i810_CheckSpinBoxes()));
connect (Check[17], SIGNAL(clicked()), this, SLOT(i810_CheckSpinBoxes()));
connect (Check[14], SIGNAL(clicked()), this, SLOT(i810_CheckRotate1()));
connect (Check[15], SIGNAL(clicked()), this, SLOT(i810_CheckRotate2()));

connect (OKButton, SIGNAL(clicked()), this, SLOT(i810_SaveAndExit()));
i810_CheckSpinBoxes();

SpinBox[0]->setMaxValue(128000);
SpinBox[1]->setMaxValue(128000);

OptionsDialog->show();
}

void PropertiesDialog :: i810_CheckSpinBoxes()
{
if (!Check[2]->isChecked()) { SpinBox[0]->setEnabled(FALSE); } else { SpinBox[0]->setEnabled(TRUE); }
if (!Check[3]->isChecked()) { SpinBox[1]->setEnabled(FALSE); } else { SpinBox[1]->setEnabled(TRUE); }
if (!Check[7]->isChecked()) { SpinBox[2]->setEnabled(FALSE); } else { SpinBox[2]->setEnabled(TRUE); }

if (!Check[17]->isChecked())
  {
   for (int a = 0; a < 4; a++)
    {
     Combo[a]->setEnabled(FALSE);
    }
  }

if (Check[17]->isChecked())
  {
   for (int a = 0; a < 4; a++)
    {
     Combo[a]->setEnabled(TRUE);
    }
  }


}

void PropertiesDialog :: i810_CheckRotate1()
{
if (Check[14]->isChecked()) { Check[15]->setChecked(FALSE); }
}

void PropertiesDialog :: i810_CheckRotate2()
{
if (Check[15]->isChecked()) { Check[14]->setChecked(FALSE); }
}


void PropertiesDialog :: i810_SaveAndExit()
{

QString Num;

if (Check[0]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "NoAccel", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "NoAccel"); }

if (Check[1]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "SWCursor", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "SWCursor"); }


Num = Num.setNum(SpinBox[0]->value(), 10);

if (Check[2]->isChecked())
{ X->WriteOption(Xorg::Device, SecNum, "ColorKey", Num); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "ColorKey"); }

Num = Num.setNum(SpinBox[1]->value(), 10);

if (Check[3]->isChecked())
{ X->WriteOption(Xorg::Device, SecNum, "CacheLines", Num); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "CacheLines"); }

if (Check[4]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "DRI", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "DRI"); }

if (Check[5]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "DDC", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "DDC"); }

if (Check[6]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "Dac6Bit", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "Dac6Bit"); }

Num = Num.setNum(SpinBox[2]->value(), 10);

if (Check[7]->isChecked())
{ X->WriteOption(Xorg::Device, SecNum, "XvMCSurfaces", Num); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "XvMCSurfaces"); }

if (Check[8]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "VBERestore", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "VBERestore"); }

if (Check[9]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "XVideo", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "XVideo"); }


Num = Num.setNum(SpinBox[3]->value(), 10);

if (Group[0]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "Clone", BOOL_TRUE); 
  X->WriteOption(Xorg::Device, SecNum, "CloneRefresh", Num); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "Clone"); 
  X->RemoveOption(Xorg::Device, SecNum, "CloneRefresh"); }

if (Check[10]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "CheckLid", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "CheckLid"); }

if (Check[11]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "FlipPrimary", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "FlipPrimary"); }

if (Check[12]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "DisplayInfo", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "DisplayInfo"); }

if (Check[13]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "DevicePresence", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "DevicePresence"); }

if (Check[14]->isChecked())
{ X->WriteOption(Xorg::Device, SecNum, "Rotate", "CW"); }

if (Check[15]->isChecked())
{ X->WriteOption(Xorg::Device, SecNum, "Rotate", "CCW"); }

if (!Check[14]->isChecked() && !Check[15]->isChecked()) 
{ X->RemoveOption(Xorg::Device, SecNum, "Rotate"); }


if (Check[16]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "ShadowFB", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "ShadowFB"); }

if (Check[17]->isChecked())
  {
   QString ToWrite = "";
   ToWrite = Combo[0]->text(Combo[0]->currentItem());
   if (Combo[1]->currentItem() > 0) 
    { ToWrite = ToWrite.append("+");
      ToWrite = ToWrite.append(Combo[1]->text(Combo[1]->currentItem())); }
     if (Combo[2]->currentItem() > 0)
      {
       ToWrite = ToWrite.append(",");
       ToWrite = ToWrite.append(Combo[2]->text(Combo[2]->currentItem()));
       if (Combo[3]->currentItem() > 0)
        {
         ToWrite = ToWrite.append("+");
         ToWrite = ToWrite.append(Combo[3]->text(Combo[3]->currentItem()));
        }
      }
   X->WriteOption(Xorg::Device, SecNum, "MonitorLayout", ToWrite);
  }


OptionsDialog->close();
}

