#ifndef MAPS_READER_HH
#define MAPS_READER_HH

#include <QString>
#include <QList>
#include <QObject>

/**
 * A struct for a single map entry.
 **/
typedef struct _MapsEntry {
    unsigned int start_address;
    unsigned int end_address;
    QString permissions;
    unsigned int offset;
    QString device;
    unsigned int inode;
    QString path;
    
    unsigned int size;
    unsigned int rss;
    unsigned int shared_clean;
    unsigned int shared_dirty;
    unsigned int private_clean;
    unsigned int private_dirty;
    unsigned int referenced;

    QString getMode () {
        if ( permissions[3] == 'p') {
            return QObject::tr("private");
        }

        else if ( permissions[3] == 's') {
            return QObject::tr("shared");
        }
        else {
            return "";
        }
    }
            
} MapsEntry;


/**
 * @brief Class that can read information from /proc/<pid>/smaps.
 *
 * This class is used to parse the @e smaps file in proc for a specific process id. It can parse all information and
 * stores it internally.
 **/
class MapsReader {

public:

    /**
     * Parses the maps for the given @p pid. All data is stored internally ready for reading. If something fails then
     * false is returned (such as the process has terminated). If all is ok then true is returned. The given list @p
     * entries will be populated with parsed @e MapsEntry entries. If something fails the list may be empty or half
     * full. It is always the responsibility of the caller to free ll entries regardless wether they were parsed ok or
     * not.
     *
     * @param pid the process id whose information is parsed.
     * @param entries a result list where the entries are placed.
     **/
    bool parse (int pid, QList<MapsEntry *> & entries);
};


#endif
