
#include <QDebug>
#include <QSettings>
#include <QColorDialog>

#include <preferences.hh>

Preferences::Preferences (QWidget * parent) : QDialog(parent) {
    setupUi(this);

    // read in the delay
    QSettings settings("Smultron", "Memory monitor");
    m_interval->setValue ( settings.value ("interval", 1000).toInt() );

    // all colors. this is a bit kludgey as qvariant doesn't store qcolor natively. first store the
    // colors in a hash for later retrieval
    m_colors.insert ( m_total_memory,    settings.value ("Colors/total",      QColor(Qt::black)).value<QColor>() );   
    m_colors.insert ( m_resident_memory, settings.value ("Colors/resident",   QColor(Qt::red)).value<QColor>() );      
    m_colors.insert ( m_shared_memory,   settings.value ("Colors/shared",     QColor(Qt::blue)).value<QColor>() );    
    m_colors.insert ( m_text_size,       settings.value ("Colors/text",       QColor(Qt::green)).value<QColor>() );   
    m_colors.insert ( m_library_size,    settings.value ("Colors/library",    QColor(Qt::magenta)).value<QColor>() );  
    m_colors.insert ( m_stack_size,      settings.value ("Colors/stack",      QColor(Qt::gray)).value<QColor>() );    
    m_colors.insert ( m_data_size,       settings.value ("Colors/data_color", QColor(Qt::darkCyan)).value<QColor>() );  
    m_colors.insert ( m_plot,            settings.value ("Colors/plot",       QColor(Qt::white)).value<QColor>() );     

    // now use the cached colors
    m_total_memory->setStyleSheet    ( "background-color: " +  m_colors[m_total_memory].name() );     
    m_resident_memory->setStyleSheet ( "background-color: " +  m_colors[m_resident_memory].name() );  
    m_shared_memory->setStyleSheet   ( "background-color: " +  m_colors[m_shared_memory].name() );    
    m_text_size->setStyleSheet       ( "background-color: " +  m_colors[m_text_size].name() );        
    m_library_size->setStyleSheet    ( "background-color: " +  m_colors[m_library_size].name() );     
    m_stack_size->setStyleSheet      ( "background-color: " +  m_colors[m_stack_size].name() );       
    m_data_size->setStyleSheet       ( "background-color: " +  m_colors[m_data_size].name() );        
    m_plot->setStyleSheet            ( "background-color: " +  m_colors[m_plot].name() );             

    connect ( m_button_box, SIGNAL(accepted()), this, SLOT(savePreferences()) );

    // handle all color buttons through one slot
    connect ( m_total_memory,   SIGNAL(clicked()), this, SLOT(selectColor()) );
    connect ( m_resident_memory,SIGNAL(clicked()), this, SLOT(selectColor()) );
    connect ( m_shared_memory,  SIGNAL(clicked()), this, SLOT(selectColor()) );
    connect ( m_text_size,      SIGNAL(clicked()), this, SLOT(selectColor()) );
    connect ( m_library_size,   SIGNAL(clicked()), this, SLOT(selectColor()) );
    connect ( m_stack_size,     SIGNAL(clicked()), this, SLOT(selectColor()) );
    connect ( m_data_size,      SIGNAL(clicked()), this, SLOT(selectColor()) );
    connect ( m_plot,           SIGNAL(clicked()), this, SLOT(selectColor()) );    
}


void Preferences::savePreferences () {
    // the object where we save
    QSettings settings("Smultron", "Memory monitor");

    // the interval
    settings.setValue ("interval", m_interval->value() );

    // all colors
    settings.setValue ("Colors/total",      m_colors[m_total_memory] );     
    settings.setValue ("Colors/resident",   m_colors[m_resident_memory] );  
    settings.setValue ("Colors/shared",     m_colors[m_shared_memory] );    
    settings.setValue ("Colors/text",       m_colors[m_text_size] );        
    settings.setValue ("Colors/library",    m_colors[m_library_size] );     
    settings.setValue ("Colors/stack",      m_colors[m_stack_size] );       
    settings.setValue ("Colors/data_color", m_colors[m_data_size] );        
    settings.setValue ("Colors/plot",       m_colors[m_plot] );             

    accept();
}


void Preferences::selectColor () {
    QWidget * button;
    
    // precautions
    if ( (button = dynamic_cast<QWidget *>(sender())) == 0 ) {
        return;
    }

    // more precautions
    if ( ! m_colors.contains(button) ) {
        qWarning() << "Preferences::selectColor: could not find the passed button!";
        return;
    }

    // ask the suer for a color using the normal color picker
    QColor picked = QColorDialog::getColor (m_colors[button], this );

    // was the dialog accepted?
    if ( picked.isValid() ) {
        // yes, take into use immediately
        button->setStyleSheet ( "background-color: " +  picked.name() );

        // and save
        m_colors[button] = picked;
    }
}
