#ifndef PREFERENCES_HH
#define PREFERENCES_HH

#include <QDialog>
#include <QHash>
#include <QColor>

#include <ui_preferences.h> 

/**
 * @brief Dialog for setting various preferences.
 *
 * This dialog is used to set the various preferences for the memory monitor application. The old
 * preferences are read from QSettings using the keys @e Smultron and @e Memory @e monitor. All
 * changes are saved back to QSettings if the dialog is accepted.
 **/
class Preferences : public QDialog, private Ui::PreferencesBase {

    Q_OBJECT

public:

    /**
     * Constructor. 
     *
     * @param parent optional parent object.
     **/
    Preferences (QWidget * parent=0);

                                                       
protected slots:

    /**
     * Callback for when the user clicks the @e Ok button. Saves all preferences into a QSettings
     * object and accepts the dialog.
     **/
    void savePreferences ();

    /**
     * Callback for when the user clicks one of the color buttons. This slot handles all buttons and
     * allows the user to pick a color using a color dialog.
     **/
    void selectColor ();
    
    
protected:

    QHash<QObject *, QColor> m_colors;
};


#endif
