/***************************************************************************
    smb4kfileio  -  Does file IO operations for Smb4K
                             -------------------
    begin                : Do Jan 1 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KFILEIO_H
#define SMB4KFILEIO_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>
#include <qstring.h>
#include <qcstring.h>

// KDE include
#include <kprocess.h>


/**
 * This class belongs to the core classes of Smb4K. It handles IO
 * operations that are performed on system configuration files.
 *
 * @author Alexander Reinholdt <dustpuppy@mail.berlios.de>
 */

class Smb4KFileIO : public QObject
{
  Q_OBJECT

  public:
    /**
     * The constructor
     *
     * @param parent      The parent object of this class
     *
     * @param name        The name of this class
     */
    Smb4KFileIO( QObject *parent = 0, const char *name = 0 );

    /**
     * The destructor
     */
    ~Smb4KFileIO();

    /**
     * Enumeration that determines for which super user program we perform
     * the current action.
     */
    enum Operation { Insert, Remove, NoOperation };

    /**
     * This function writes changes to the sudoers configuration file.
     *
     * @param operation   Defines whether entries should be inserted or if
     *                    they should be removed. With Smb4KFileIO::NoOperation
     *                    the function exits immediately and returns TRUE.
     *
     * @returns TRUE if the write process was successfully initiate and FALSE
     * otherwise.
     *
     * @note You need to connect to the finished() and failed() signals to find
     * out if the the write process finished successfully.
     *
     */
    bool writeSudoers( Smb4KFileIO::Operation operation );

  signals:
    /**
     * This signal is emitted when somthing went wrong with the writing to
     * the system configuration files.
     */
    void failed();

    /**
     * This signal is emitted when the writing to the system configuration
     * files has finished. It is emitted in case the writing was successful
     * as well as in case it wasn't.
     */
    void finished();

  protected slots:
    /**
     * This slot receives shell program output from Stderr.
     *
     * @param proc            The KProcess object
     *
     * @param buf             The buffer that holds the error output
     *
     * @param len             The length of the buffer
     */
    void slotReceivedStderr( KProcess *proc, char *buf, int len );

    /**
     * This slot receives shell program output from Stdout.
     *
     * @param proc            The KProcess object
     *
     * @param buf             The buffer that holds the output
     *
     * @param len             The length of the buffer
     */
    void slotReceivedStdout( KProcess *proc, char *buf, int len );

    /**
     * This slot is called, when the process exited.
     *
     * @param proc            The KProcess object
     */
    void slotProcessExited( KProcess *proc );

  private:
    /**
     * This buffer holds the output that was received at Stdout.
     */
    QString m_buffer;

    /**
     * Process the sudoers file.
     */
    void processSudoers();

    /**
     * The KProcess object
     */
    KProcess *m_proc;
};


#endif
