/***************************************************************************
    smb4knetworkoptions  -  The configuration page for the network
    settings of Smb4K
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qbuttongroup.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qcheckbox.h>

// KDE includes
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>

// application specific includes
#include "smb4knetworkoptions.h"
#include "../core/smb4ksettings.h"

Smb4KNetworkOptions::Smb4KNetworkOptions( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QGridLayout *grid = new QGridLayout( this );
  grid->setSpacing( 10 );

  //
  // The browse list group box.
  //
  QButtonGroup *browse_box =       new QButtonGroup( 1, Qt::Horizontal, i18n( "Browse List" ),
                                   this, "kcfg_BrowseList" );

  browse_box->insert( new QRadioButton( i18n( "Scan the network neighborhood for available workgroups and domains" ),
                      browse_box ), Smb4KSettings::EnumBrowseList::LookupDomains );
  browse_box->insert( new QRadioButton( i18n( "Query the current workgroup master browser" ),
                      browse_box), Smb4KSettings::EnumBrowseList::QueryCurrentMaster );

  QWidget *buttonWidget =          new QWidget( browse_box );
  QGridLayout *buttonLayout =      new QGridLayout( buttonWidget );
  buttonLayout->setSpacing( 5 );

  QRadioButton *use_host =         new QRadioButton( i18n( "Query this master browser:" ),
                                   buttonWidget, "CustomMasterBrowserLabel" );
  KLineEdit *host_name =           new KLineEdit( buttonWidget, "kcfg_CustomMasterBrowser" );
  QRadioButton *use_scan =         new QRadioButton( i18n( "Scan broadcast areas:" ),
                                   buttonWidget, "BroadcastAreasLabel" );
  KLineEdit *broadcast_addresses = new KLineEdit( buttonWidget, "kcfg_BroadcastAreas" );

  buttonLayout->addWidget( use_host, 0, 0, 0 );
  buttonLayout->addWidget( host_name, 0, 1, 0 );
  buttonLayout->addWidget( use_scan, 1, 0, 0 );
  buttonLayout->addWidget( broadcast_addresses, 1, 1, 0 );

  browse_box->insert( use_host, Smb4KSettings::EnumBrowseList::QueryCustomMaster );
  browse_box->insert( use_scan, Smb4KSettings::EnumBrowseList::ScanBroadcastAreas );
  
  //
  // The authentication group box
  // 
  QButtonGroup *auth_box   =       new QButtonGroup( 1, Qt::Horizontal, i18n( "Authentication" ),
                                   this );
  QCheckBox *master_browser_auth = new QCheckBox( Smb4KSettings::self()->masterBrowsersRequireAuthItem()->label(),
                                   auth_box, "kcfg_MasterBrowsersRequireAuth" );

  //
  // The search group box
  //
  QButtonGroup *search_box =       new QButtonGroup( 1, Qt::Horizontal, i18n( "Network Search" ),
                                   this, "kcfg_SearchMethod" );
  search_box->setInsideSpacing( 5 );

  QLabel *description =            new QLabel( search_box );
  description->setText( i18n( "Smb4K uses \"nmblookup\" by default to search for remote hosts. This method is very reliable but fails sometimes if your network neighborhood is configured uncommonly. In this case you should try to use \"smbclient\"." ) );
  description->setTextFormat( Qt::RichText );

  search_box->insert( new QRadioButton( i18n( "Use nmblookup (recommended)" ),
                      search_box ), Smb4KSettings::EnumSearchMethod::Nmblookup );

  search_box->insert( new QRadioButton( i18n( "Use smbclient" ),
                      search_box ), Smb4KSettings::EnumSearchMethod::Smbclient );

  QSpacerItem *spacer4 =           new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid->addWidget( browse_box, 0, 0, 0 );
  grid->addWidget( auth_box, 1, 0, 0 );
  grid->addWidget( search_box, 2, 0, 0 );
  grid->addItem( spacer4, 2, 0 );
}


Smb4KNetworkOptions::~Smb4KNetworkOptions()
{
}


#include "smb4knetworkoptions.moc"
