/***************************************************************************
    smb4kauthinfo.h  -  This class provides a container for the
    authentication data.
                             -------------------
    begin                : Sa Feb 28 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KAUTHINFO_H
#define SMB4KAUTHINFO_H

// Qt includes
#include <qstring.h>
#include <qcstring.h>

// KDE includes
#include <kdemacros.h>

/**
 * This class provides a container for the authentication data.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */


class KDE_EXPORT Smb4KAuthInfo
{
  public:
    /**
     * The constructor.
     *
     * @param workgroup The workgroup of the share the auth info is for.
     *
     * @param hosts     The host's name
     *
     * @param share     The share's name
     *
     * @param user      The username that's used for authentication. Default is QString::null.
     *
     * @param password  The password that's used for authentication. Default is QString::null.
     */
    Smb4KAuthInfo( const QString &workgroup,
                   const QString &host,
                   const QString &share,
                   const QString &user = QString(),
                   const QString &password = QString() );

    /**
     * The empty constructor.
     */
    Smb4KAuthInfo() {}

    /**
     * The copy constructor.
     *
     * @param info      The Smb4KAuthInfo object that will be copied.
     */
    Smb4KAuthInfo( Smb4KAuthInfo &info );

    /**
     * The destructor
     */
    ~Smb4KAuthInfo();

    /**
     * Returns the name of the workgroup.
     *
     * @returns         The workgroup of the server/share for which this
     *                  authentication data is for.
     */
    const QString &workgroup() const { return m_workgroup; }

    /**
     * Returns the name of the server (host).
     *
     * @returns         The server name
     */
    const QString &host() const { return m_host; }

    /**
     * Returns the name of the share.
     *
     * @returns         The share name
     */
    const QString &share() const { return m_share; }

    /**
     * Returns the user's name.
     *
     * @returns         The user name
     */
    const QCString &user() const { return m_user; }

    /**
     * Returns the (unescaped) password.
     */
    const QCString &password() const { return m_password; }

    /**
     * Sets the user name.
     *
     * @param user      The user name for the server/share
     */
    void setUser( const QString &user );

    /**
     * Sets the password.
     *
     * @param passwd    The password for the server/share
     */
    void setPassword( const QString &passwd );

    /**
     * Sets the share name.
     *
     * @param share     The name of the share
     */
    void setShare( const QString &share );

    /**
     * Sets the host name.
     *
     * @param host      The name of the host
     */
    void setHost( const QString &host );

    /**
     * Sets the workgroup.
     *
     * @param workgroup The name of the workgroup.
     */
    void setWorkgroup( const QString &workgroup );

  private:
    /**
     * The workgroup object.
     */
    QString m_workgroup;

    /**
     * The host object.
     */
    QString m_host;

    /**
     * The share object.
     */
    QString m_share;

    /**
     * The user name for this share.
     */
    QCString m_user;

    /**
     * The password object for this share.
     */
    QCString m_password;
};

#endif
