/***************************************************************************
 *   Copyright (C) 2005 by Raul Moratalla                                  *
 *   raul.moratalla@ono.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _FIREFOXQS_H_
#define _FIREFOXQS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kaction.h>
#include <qstring.h>
#include <ksystemtray.h>
#include <qobject.h>


class KConfig;
class KProcess;
class KWinModule;

class FirefoxQs : public KSystemTray
{
	Q_OBJECT
public:
	FirefoxQs();
	virtual ~FirefoxQs();

protected:
	virtual void mousePressEvent( QMouseEvent* );
private:

	KProcess* process;
	
	KToggleAction* _autostart;

	KConfig* _config;

private slots:

	void start(const QString param) const;

	void startWebBrowser( void ) const;

	void toggleAutostart( void );

	void hideFirefox(WId w );
};
#endif // _FIREFOXQS_H_
