/***************************************************************************
 *   Copyright (C) 2005 by Raul Moratalla                                  *
 *   raul.moratalla@ono.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "firefoxqs.h"

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kdesktopfile.h>
#include <kglobal.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kuniqueapplication.h>

static const char description[] =
    I18N_NOOP("The Firefox Quickstarter for KDE");

static const char version[] = "0.1.3";

static KCmdLineOptions options[] =
{
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    
	KAboutData about( "firefoxqs",
	                  I18N_NOOP( "Firefox Quickstarter" ),
	                  version, description, KAboutData::License_GPL,
	                  "(C) 2003,2004,2005 Raul Moratalla,Christian Nitschkowski",
	                  0, "http://mozillaqs.sourceforge.net" );
	about.addAuthor( "Raul Moratalla",
	                 0, "raul.moratalla@gmail.com" );
	about.addAuthor( "Christian Nitschkowski (author of OpenOffice.org QuickStarter)",
	                 0,"http://segfaultskde.berlios.de/index.php?content=oooqs" );
	
	KCmdLineArgs::init( argc, argv, &about );
	KCmdLineArgs::addCmdLineOptions( options );

	KUniqueApplication app;

	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

	app.disableSessionManagement();

	FirefoxQs mainWin;

	app.setMainWidget( &mainWin );
	mainWin.show();

	args->clear();

	return app.exec();
}
