/* This file is part of the Keep project
   Copyright (C) 2006 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#ifndef _RDBLISTENER_H_
#define _RDBLISTENER_H_

#include <qstringlist.h>

#include <qobject.h>
#include <kprocess.h>

class RDBListener: public QObject
{
Q_OBJECT
public:
	RDBListener();
	QStringList stdOut();
	QStringList stdErr();
	QString errorMessage();
	bool isOk();

public slots:
	void receivedStdOut(KProcess *proc, char *buffer, int buflen);
	void receivedStdErr(KProcess *proc, char *buffer, int buflen);

private:
	QStringList m_stdOut;
	QStringList m_stdErr;
	bool m_isOk;
};

#endif
