//
// C++ Implementation: filterlogview
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "filterlogview.h"

FilterLogView::FilterLogView( QWidget *parent, FilterLog* log )
  : KDialogBase( parent, "FilterLogView", true, QString::null, Ok, Ok, true )
{
  //save the log pointer
  this->log = log;

  //set caption
  setCaption( i18n( "Filter Log View" ) );

  //main widget
  QWidget* pgMain = new QWidget( this );
  setMainWidget( pgMain );

  //basic layout
  QVBoxLayout* layMain = new QVBoxLayout( pgMain, 0, spacingHint() );

  //view of deleted views
  QLabel* lblDeletedMails = new QLabel( i18n( "Deleted Mails:"), pgMain, "lblDeletedMails" );
  layMain->addWidget( lblDeletedMails );

  lstViewDeleted = new KListView( pgMain, "lstViewDeleted" );
  lstViewDeleted->addColumn( i18n( "Date" ) );
  lstViewDeleted->addColumn( i18n( "Sender" ) );
  lstViewDeleted->addColumn( i18n( "Account" ) );
  lstViewDeleted->addColumn( i18n( "Subject" ) );
  lstViewDeleted->setColumnWidthMode( 0, QListView::Maximum );
  lstViewDeleted->setColumnWidthMode( 1, QListView::Maximum );
  lstViewDeleted->setColumnWidthMode( 2, QListView::Maximum );
  lstViewDeleted->setColumnWidthMode( 3, QListView::Maximum );
  lstViewDeleted->setResizeMode( QListView::NoColumn );
  lstViewDeleted->setSortColumn( 0 );
  lstViewDeleted->setSortOrder( Qt::Ascending );
  layMain->addWidget( lstViewDeleted );

  KPushButton* btnClearDeleted = new KPushButton( KStdGuiItem::clear(), pgMain, "btnClearDeleted" );
  QToolTip::add( btnClearDeleted, i18n( "Clear the list of deleted mails" ) );
  connect( btnClearDeleted, SIGNAL( clicked() ), this, SLOT( slotClearDeletedMails() ) );
  btnClearDeleted->setSizePolicy( QSizePolicy::Maximum, QSizePolicy::Fixed );
  layMain->addWidget( btnClearDeleted );

  //create a seperator
  layMain->addWidget( new KSeparator( pgMain ) );

  //view of deleted views
  QLabel* lblMovedMails = new QLabel( i18n( "Moved Mails:"), pgMain, "lblMovedMails" );
  layMain->addWidget( lblMovedMails );

  lstViewMoved = new KListView( pgMain, "lstViewMoved" );
  lstViewMoved->addColumn( i18n( "Date" ) );
  lstViewMoved->addColumn( i18n( "Sender" ) );
  lstViewMoved->addColumn( i18n( "Account" ) );
  lstViewMoved->addColumn( i18n( "Moved To" ) );
  lstViewMoved->addColumn( i18n( "Subject" ) );
  lstViewMoved->setColumnWidthMode( 0, QListView::Maximum );
  lstViewMoved->setColumnWidthMode( 1, QListView::Maximum );
  lstViewMoved->setColumnWidthMode( 2, QListView::Maximum );
  lstViewMoved->setColumnWidthMode( 3, QListView::Maximum );
  lstViewMoved->setColumnWidthMode( 4, QListView::Maximum );
  lstViewMoved->setResizeMode( QListView::NoColumn );
  lstViewMoved->setSortColumn( 0 );
  lstViewMoved->setSortOrder( Qt::Ascending );
  layMain->addWidget( lstViewMoved );

  KPushButton* btnClearMoved = new KPushButton( KStdGuiItem::clear(), pgMain, "btnClearMoved" );
  QToolTip::add( btnClearMoved, i18n( "Clear the list of moved mails" ) );
  connect( btnClearMoved, SIGNAL( clicked() ), this, SLOT( slotClearMovedMails() ) );
  btnClearMoved->setSizePolicy( QSizePolicy::Maximum, QSizePolicy::Fixed );
  layMain->addWidget( btnClearMoved );

  //now we load the content for the list views
  LogEntryList listDeletedMails = log->getDeletedMails();
  LogEntryList::iterator it;
  for( it = listDeletedMails.begin(); it != listDeletedMails.end(); it++ )
  {
    //create a new list view item
    FilterLogViewDeletedItem* item = new FilterLogViewDeletedItem( lstViewDeleted );
    item->setValues( (*it).getDate(), (*it).getSender(), (*it).getAccount(), (*it).getSubject() );
  }

  LogEntryList listMovedMails = log->getMovedMails();
  for( it = listMovedMails.begin(); it != listMovedMails.end(); it++ )
  {
    //create a new list view item
    FilterLogViewMovedItem* item = new FilterLogViewMovedItem( lstViewMoved );
    item->setValues( (*it).getDate(), (*it).getSender(), (*it).getAccount(), (*it).getMailbox(), (*it).getSubject() );
  }
}


FilterLogView::~FilterLogView()
{
}

void FilterLogView::slotClearDeletedMails( )
{
  log->clearDeletedMailsLog();
  lstViewDeleted->clear();

}

void FilterLogView::slotClearMovedMails( )
{
  log->clearMovedMailsLog();
  lstViewMoved->clear();
}


#include "filterlogview.moc"
