//
// C++ Interface: filterlogview
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef FILTERLOGVIEW_H
#define FILTERLOGVIEW_H

//Qt headers
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>

//KDE headers
#include <kdialogbase.h>
#include <klocale.h>
#include <klistview.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>
#include <kseparator.h>

//KShowmail headers
#include "filterlog.h"
#include "filterlogviewdeleteditem.h"
#include "filterlogviewmoveditem.h"

/**
 * @brief This dialog box shows the filter log.
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 */
class FilterLogView : public KDialogBase
{

Q_OBJECT

  public:

    /**
     * General constructor
     * @param parent pointer to the parent widget
     * @param log pointer to the filter log
     */
    FilterLogView( QWidget* parent = NULL, FilterLog* log = NULL );

    /**
     * Destructor
     */
    ~FilterLogView();

  private:

    /**
     * Pointer to the filter log.
     */
    FilterLog* log;

    /**
     * List view of deleted mails
     */
    KListView* lstViewDeleted;

    /**
     * List view of moved mails
     */
    KListView* lstViewMoved;

  private slots:

    /**
     * Clears the list of deleted mails.
     */
    void slotClearDeletedMails();

    /**
     * Clears th elist of moved mails.
     */
    void slotClearMovedMails();

};

#endif
