//
// C++ Implementation: filterlogviewdeleteditem
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "filterlogviewdeleteditem.h"

FilterLogViewDeletedItem::FilterLogViewDeletedItem( KListView* parent )
 : KListViewItem( parent )
{
}


FilterLogViewDeletedItem::~FilterLogViewDeletedItem()
{
}

void FilterLogViewDeletedItem::setValues( QDateTime date, QString sender, QString account, QString subject )
{
  //store values
  this->date = date;
  this->sender = sender;
  this->account = account;
  this->subject = subject;

  //set column text
  setText( ColDate, date.toString( Qt::LocalDate ) );
  setText( ColSender, sender );
  setText( ColAccount, account );
  setText( ColSubject, subject );
}

int FilterLogViewDeletedItem::compare( QListViewItem * i, int col, bool ascending ) const
{
  if( col == ColDate )
  {
    if( this->date < ((FilterLogViewDeletedItem*)i)->getDate() ) return -1;
    if( this->date > ((FilterLogViewDeletedItem*)i)->getDate() ) return 1;
    else return 0;
  }
  else
    return key( col, ascending ).compare( i->key( col, ascending) );

}

QDateTime FilterLogViewDeletedItem::getDate( )
{
  return date;
}



