/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Fre Sep 28 23:29:54 CEST 2001
    copyright            : (C) 2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//KDE-Header
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kuniqueapplication.h>
#include <klocale.h>
#include <kdebug.h>

//KShowmail-Header
#include "uniqueapp.h"
#include "kshowmail.h"
#include "constants.h"

using namespace Constants;

//description of the application
static const char *description = I18N_NOOP("A powerful pop3 mail checker");

//the command line options
//see constants.h
static KCmdLineOptions kshowmailOptions[] =
  {
    { CMDLINE_REFRESH_SHORT, 0, 0},
    { CMDLINE_REFRESH, I18N_NOOP("Refresh messages now"), 0 },
    { CMDLINE_CONFIG_SHORT, 0, 0},
    { CMDLINE_CONFIG, I18N_NOOP("Launch configure dialog"), 0 },
    KCmdLineLastOption
  };

int main(int argc, char *argv[])
{
  //create datas for the about box
  KShowMailApp::m_pAbout = new KAboutData (
                             /*appName    */ "kshowmail",
                             /*programName*/ "KShowmail",
                             /*version    */ VERSION,
                             /*description*/ description,
                             /*license    */ KAboutData::License_GPL_V2,
                             /*copyright  */ "(C) 2000-2005, Eggert Ehmke",
                             /*text       */ 0,
                             /*homepage   */ "http://sourceforge.net/projects/kshowmail",
                             /*bug email  */ "eggert.ehmke@berlin.de");

  //add authors
  KShowMailApp::m_pAbout->addAuthor ("Eggert Ehmke", 0, "eggert.ehmke@berlin.de", "http://kshowmail.sourceforge.net");
  KShowMailApp::m_pAbout->addAuthor ("Allistar Melville", 0, "allistar@silvermoon.co.nz", 0);
  KShowMailApp::m_pAbout->addAuthor ("Oleg Ivanov", 0, "saruman@unigsm.com", 0);
  KShowMailApp::m_pAbout->addAuthor( "Ulrich Weigelt", 0, "ulrich.weigelt@gmx.de", 0 );
  KShowMailApp::m_pAbout->setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names") ,I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));

  //Initialize command line arguments
  KCmdLineArgs::init(argc, argv, KShowMailApp::m_pAbout);
  //add the special command line options of kshowmail which was specified above
  KCmdLineArgs::addCmdLineOptions(kshowmailOptions);

  // when released, this must be 0!
#if 0

  kdDebug () << "KShowmail running in debug mode" << endl;
  KApplication::addCmdLineOptions();

  KApplication app;
  KShowMailApp* kshow = new KShowMailApp ();
  kshow->show();
  app.exec();

#else

  //print debug message about run mode
  kdDebug () << "KShowmail running in normal mode" << endl;

  //add special command line options for unique KDE applications
  KUniqueApplication::addCmdLineOptions();

  //test whether the new application to start is unique
  if (KUniqueApplication::start())
  {
    //yes, wa can start a unique kshowmail instance

    //create a new unique appliction
    //UniqueApp is a inherited class of KUniqueApplication
    //see uniqueapp.h
    UniqueApp* app = new UniqueApp ();

    //start the application
    app->exec ();
  }
  else
  {
    //kshowmail is already running
    kdWarning() << I18N_NOOP ("Kshowmail is already running!") << endl;
  }

#endif

  return 0;
}

