package Perlbox::Plugins::Desktop;

#==============================================================================
#=== License
#==============================================================================
# Copyright (c) Date Fri Jan 16 21:11:38 MST 2004
# Author Shane Mason <me@perlbox.org>

#This file is part of Perlbox Voice.

#Perlbox Voice is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Perlbox Voice is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Foobar; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

require 5.002;
use strict;

use constant TRUE  =>1;
use constant FALSE =>0;
use Cwd;

my @codec = undef;
my $plugin_loaded = FALSE;

sub new {
    my $class = shift;
    my $self = {
        @_,
    };

    bless ( $self, $class );

    $self->init();
    return $self;
}

sub init {
     my $self = shift;
     $plugin_loaded = FALSE;
	 #inits nothing
}

sub list_plugins{
   my $self = shift;
	my $plugin_dir = shift;
	my $plugin_list = shift;

		open(FILELS,"ls $plugin_dir |");

		my $index   = 0;
		my $prefix  = undef;
		my $postfix = undef;

		while(<FILELS>){
			chomp;
			($prefix,$postfix)=split(/\./,$_);

			if($postfix eq "plug"){
				@$plugin_list->[$index] = $prefix;
				$index++;
			}

			@$plugin_list->[$index] = "none";

		}




}

sub load_plugin{
   my $self=shift;
   my $to_load_name=shift;
   my $to_load_path=shift;
   @codec=();
   if(stat($to_load_path)){
        open(PLUGIN,$to_load_path);
      my $this_line=undef;
      my $index=undef;
      while($this_line=<PLUGIN>){
           chomp $this_line;
         if($this_line =~ /^desktop/){
            #now we  make a list of commands, called codec
            my ($spoken,$execute) = split(":",$this_line);
            my $this_command;    #a hash reference
            $this_command->{'spoken'}=$spoken;
            $this_command->{'execute'}=$execute;
            push(@codec,$this_command);
          }
      }
      $plugin_loaded = TRUE;
   }
   else{
       warn ("Perlbox::Desktop.pm says: Could not load plugin $to_load_name\nBad stat on file $to_load_path\n");
       $plugin_loaded = FALSE;
   }
}

sub get_codec{
   return \@codec;
}

sub unload_plugin{
    my $self = shift;
    @codec = undef;
}

sub is_plugin_loaded{
   return $plugin_loaded;
}

sub input_command{
   my $self=shift;
   my $command=shift;
   $command = lc($command);
   if(!($command =~ /^desktop/)){
      return FALSE;
   }
   else{
      foreach my $this_codec (@codec){
         if(lc($this_codec->{'spoken'}) eq ($command)){
            #then we want to issue 'execute'
            system($this_codec->{'execute'});
            return TRUE;
         }
      }
   }
}

1;
