#==============================================================================
#=== License
#==============================================================================
# Copyright (c) Date Fri Nov  8 21:11:38 MST 2002
# Author Shane Mason <me@perlbox.org>

#This file is part of Perlbox Voice.

#Perlbox Voice is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Perlbox Voice is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Foobar; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package Perlbox::Response::VoiceResponse;
require 5.002;
use strict;
use lib './';

use FileHandle;
#BEGIN { $| = 1; print "1..3\n"; }
#END {print "not ok 1\n" unless $loaded;}
#use Perlbox::ThirdParty::Festival::Client;

my $festival_handle;
my $pipe_is_open;

sub new {
    my $class = shift;
    my $self = {
        @_,
    };

    bless ( $self, $class );

    $self->init();
    return $self;
}

sub respond{
   my $self = shift;
   my $text = shift;
   if( not $pipe_is_open ){
     warn "The pipe to Festival is broken\n";
   }
   else{ 
     print $festival_handle "(SayText \" $text \")";
     $festival_handle->flush();
   }
}

sub init{
   #now we open festival with a pipe
   $pipe_is_open = 1;
   
   #open the pipe
   open(FESTHANDLE, "|festival --pipe") or $pipe_is_open = 0;
   #set it to auto flush (so speach isn't delayed)   
   #FESTHANDLE->autoflush(1);
   #now set it to our variable (so we can keep it persistant
   $festival_handle = *FESTHANDLE;
   
   if( not $pipe_is_open ){
      warn "Perlbox-VoiceServer.pm :Could not start festival server.\n";
      warn "Make sure festival is installed, in your path and you have permissions\n";     
   }
   else{
      warn "Festival started...\n";
   }
   
}



1;

=head1 NAME

 Perlbox::VoiceResponse


=head Version

 This document refers to version 0.7 of Perlbox Voice Application Framework,
 release 3 18 2003

=head1 SYNOPSIS

 This module is interfaced from Perlbox::VoiceServer.

=head1 AUTHOR

 Shane C. Mason <me@perlbox.org>

 Special thanks to: Eric Andrechek (eric at openthought dot net)

 http://perlbox.org

=head1 COPYRIGHT

 Copyright (c) Date Fri Nov  8 21:11:38 MST 2002
 Author Shane Mason <me@perlbox.org>

 This file is part of Perlbox Voice.

 Perlbox Voice is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Perlbox Voice is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

=cut
