package Perlbox::perlboxTK::pFileDialog::pbFileTable;
use strict;
use vars qw($VERSION);
$VERSION = '0.1.x'; # $Id: //depot/Tk8/Tk/LabEntry.pm#11 $

use base  qw(Tk::Frame);
use Tk::widgets qw(Frame Label Entry);

Construct Tk::Widget 'pbFileTable';

my $currentDir;  	#current#current working directory
my $currentDir_Ref;	#reference to current dir
my @handlers;		#associative array of associative arrays with "@extensions", 'open with', 'icon'
my $cw; 			#for a given list of file extention
my $args;
my $iconDir;
my $hiddenFiles;
my @currentFileList;     #list of files read from the current directory

my $gFont;

sub Populate(){

 require Tk::Text;
 ($cw, $args) = @_;
 $cw->SUPER::Populate($args);

 my $e = $cw->Scrolled("Text",-scrollbars=>'oe');
 $e->pack('-expand' => 1, '-fill' => 'both');
 $cw->Advertise('Text' => $e );
 $cw->ConfigSpecs(DEFAULT => [$e]);
 $cw->Delegates(DEFAULT => $e);
 #$cw->AddScrollbars($e) ;#if (exists $args->{-scrollbars});
 $gFont=$e->fontCreate(-family=>"courier",-size=>10);

 #setDefaultHandlers();

}

sub setCurrentDir(){
   my($self,@args);
   ($self,@args)=@_;
   $currentDir=$args[0] or warn "Could not set dir to $args[0]";
   $currentDir_Ref=$args[1];
}

sub setIconDir(){
  my($self,@args);
    ($self,@args)=@_;
  $iconDir=$args[0] or warn $iconDir;
}



sub setDefaultHandlers(){
   my ($i,$tMime);
   my @mimz=("text","ps","image","movie","music","www");
   my @ext=("pl:txt:c:C:cpp:java:txt:php:conf","pdf:ps","jpg:jpeg:png:xmp:gif","mpeg:mov:mpg:avi","mp2:mp3:wav","html:htm:shtml");
   my @execs=("xedit,gv,display,xmms,netscape");
   my @icons=("edit.gif","ps.gif","image.gif","movie.gif","music.gif","www.gif");
   for($i=0;$i<@mimz;$i++){
       my $tMime={"mime"=>$mimz[$i],
                   "ext"=>$ext[$i],
	           "execs"=>$execs[$i],
		   "icon" =>$icons[$i]};
	 push(@handlers,$tMime);
   }
      my $tHandler;
      foreach $tHandler (@handlers){
         print $tHandler->{"mime"} ." is registered\n";
      }

}

sub registerHandler(){

}



sub longList(){
   #an argument of 0 means 'do not show hidden' DEFAULT
   #an argument of 1 means 'do show hidden'

   my($self,@args);
   ($self,@args)=@_;

   $cw->delete("1.0","end");
   if($args[0]==0){
     longList_nohidden();
   }
   else{
     longList_hidden();
   }
}

sub shortList(){

}

sub medList(){

   #an argument of 0 means 'do not show hidden' DEFAULT
   #an argument of 1 means 'do show hidden'

   my($self,@args);
   ($self,@args)=@_;

   $cw->delete("1.0","end");
   if($args[0]==0){
     medList_nohidden();
   }
   else{
     medList_hidden();
   }

}

sub longList_hidden(){
   my (@cfile,$tfile);
   opendir(LSIN,$currentDir);
   @cfile=readdir(LSIN);

   @cfile = sort(@cfile);
   @currentFileList=();

   #now we want to get stats
   foreach $tfile (@cfile){
        my @finfo=stat("$currentDir$tfile");
        my $uname= getpwuid($finfo[4]); #this can be shortened by including this in push
        my $grp = getgrgid($finfo[5]);
        my @times=localtime($finfo[9]);
        my $str=sprintf("%-15.15s %-10.10s %-10.10s %-10.10s %-10.10s",$tfile,$uname,$grp,"$times[2]:$times[1]:$times[0]","$times[4]/$times[3]/".($times[5]+1900));
        my $w=$cw->Button(-text=>"$str",-anchor=>"w",-relief=>'flat',-cursor=>"arrow", -font=>$gFont, ,-command=>[\&local_clicked,"$tfile",0,0]);
              $cw->windowCreate('end',-window=>$w);

   }
}

sub longList_nohidden(){
   my (@cfile,$tfile);
   opendir(LSIN,$currentDir);
   @cfile=readdir(LSIN);
   @cfile = sort(@cfile);
   @currentFileList=();

   #now we want to get stats
   foreach $tfile (@cfile){
     if(!($tfile=~/^\./)){
        my @finfo=stat("$currentDir$tfile");
        my $uname= getpwuid($finfo[4]); #this can be shortened by including this in push
        my $grp = getgrgid($finfo[5]);
        my @times=localtime($finfo[9]);
        my $str=sprintf("%-15.15s %-10.10s %-10.10s %-10.10s %-10.10s",$tfile,$uname,$grp,"$times[2]:$times[1]:$times[0]","$times[4]/$times[3]/".($times[5]+1900));
        my $w=$cw->Button(-text=>"$str",-anchor=>"w",-relief=>'flat',-cursor=>"arrow", -font=>$gFont, -command=>[\&local_clicked,"$tfile",0,0]);
              $cw->windowCreate('end',-window=>$w);

      }
   }
}


sub medList_hidden(){
   my (@cfile,$tfile);
   opendir(LSIN,$currentDir);
   @cfile=readdir(LSIN);

   @cfile = sort(@cfile);
   @currentFileList=();

   #now we want to get stats
   foreach $tfile (@cfile){
        my $tcolor="black";
        if (-d $currentDir.$tfile){$tcolor="blue";}
        elsif (-x $currentDir.$tfile){$tcolor="red";}
        elsif (-l $currentDir.$tfile){$tcolor="purple";}

        my @finfo=stat($currentDir.$tfile);
        my $uname= getpwuid($finfo[4]); #this can be shortened by including this in push
        my $grp = getgrgid($finfo[5]);
        my $str=sprintf("%-25.25s %-10.10s %-10.10s",$tfile,$uname,$grp);
        my $w=$cw->Button(-text=>"$str",-anchor=>"w",-relief=>'flat',-cursor=>"arrow", -font=>$gFont, -foreground=>$tcolor,-command=>[\&local_clicked,"$tfile",2,0]);
              $cw->windowCreate('end',-window=>$w);

   }
}

sub medList_nohidden(){
   my (@cfile,$tfile);
   opendir(LSIN,$currentDir);
   @cfile=readdir(LSIN);
   @cfile = sort(@cfile);
   @currentFileList=();

   #now we want to get stats
   foreach $tfile (@cfile){
     if(!($tfile=~/^\./)){
     my $tcolor="black";
       if (-d $currentDir.$tfile){$tcolor="blue";}
       elsif (-x $currentDir.$tfile){$tcolor="red";}
       elsif (-l $currentDir.$tfile){$tcolor="purple";}

        my @finfo=stat("$currentDir$tfile");
        my $uname= getpwuid($finfo[4]); #this can be shortened by including this in push
        my $grp = getgrgid($finfo[5]);
        my @times=localtime($finfo[9]);
        my $str=sprintf("%-25.25s %-10.10s %-10.10s",$tfile,$uname,$grp);
        my $w=$cw->Button(-text=>"$str",-anchor=>"w",-relief=>'flat',-cursor=>"arrow", -font=>$gFont, -foreground=>$tcolor,-command=>[\&local_clicked,"$tfile",2,0]);
              $cw->windowCreate('end',-window=>$w);

      }
   }
}


sub local_clicked(){
#$_[0] is file clicked
#$_[1] is list type 0=long 1=med 2=short
#$_[2] is 'display hidden files?' 0=no 1=yes

   if(-d $currentDir.$_[0]){
      $currentDir.=$_[0]."/";
      $$currentDir_Ref=$currentDir;
      &longList (undef,($_[2])) if($_[1]==0);
      &shortList(undef,($_[2])) if($_[1]==1);
      &medList  (undef,($_[2])) if($_[1]==2);
   }
   else{
      $$currentDir_Ref=$currentDir.$_[0];
   }
   #print ("$currentDir $_[0]\n");
}

sub goUp(){
 if($currentDir ne "/"){
  if(-d $currentDir){
    my @tmp=split("/",$currentDir);
    pop(@tmp);
    $currentDir=join("/",@tmp)."/";
    $$currentDir_Ref=$currentDir;
  }

 }

}

1;
