#!/usr/bin/perl
################################################################################
#AUTHORS: 	SHANE C. MASON, PERLBOX.ORG
#
#email:		me@perlbox.org
#url:		http://www.perlbox.org
#
#FILE:
#    This file is part of PerlBox.
#    PerlBox is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#    PerlBox is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    You should have received a copy of the GNU General Public License
#    along with PerlBox; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#################################################################################

#THIS SCEEN ALLOWS THE USER TO SELECT AN INSTALLATION DIRECTORY

use Cwd;
use lib("./");
use Tk;
use strict;
use Perlbox::perlboxTK::pDialog::pSimpleDialog;
use Perlbox::perlboxTK::pFileDialog::pFileSel;

my ( $cmdOK,$cmdCANCEL);
my ( $txtLibInstallDir, $installLibDir, $lblLibDir, $cmdBrowseLib );
my ( $txtBinInstallDir, $installBinDir, $lblBinDir, $cmdBrowseBin );

my $start_libinstall="/usr/lib/";
my $start_bininstall="/usr/bin/";
   $installLibDir=$start_libinstall;
   $installBinDir=$start_bininstall;

#make GUI
my $mw = MainWindow->new();
   $mw->geometry("400x300+100+100");
   $mw->title("perlbox");



    $cmdCANCEL=$mw->Button(-text=>"CANCEL",-relief=>'groove',-command=> sub{&myCANCEL})->
       		place(-y=>270,-x=>25,-width=>80, -height=>20);

    $cmdOK=$mw->Button(-text =>"INSTALL",-relief=>'groove', -command => sub{&myOK;})->
       		place(-y=>270,-x=>295,-width=>80,-height=>20);



    $lblLibDir=$mw->Label(-text=>"Library Directory", -anchor=>"sw")->
                place(-y=>25,-x=>25, -width=>200,-height=>20);
    $txtLibInstallDir=$mw->Entry(-textvariable=>\$installLibDir, -insertbackground=>'white',-takefocus=>1)->
                place(-y=>55,-x=>25,-width=>200,-height=>20);
    $cmdBrowseLib=$mw->Button(-text =>"BROWSE",-relief=>'groove', -command => sub{&myBrowseLib;})->
       		     place(-y=>55,-x=>225,-width=>80,-height=>20);
                 
    $lblBinDir=$mw->Label(-text=>"Binary Directory", -anchor=>"sw")->
                place(-y=>100,-x=>25, -width=>200,-height=>20);
    $txtBinInstallDir=$mw->Entry(-textvariable=>\$installBinDir, -insertbackground=>'white',-takefocus=>1)->
                place(-y=>130,-x=>25,-width=>200,-height=>20);
    $cmdBrowseBin=$mw->Button(-text =>"BROWSE",-relief=>'groove', -command => sub{&myBrowseBin;})->
       		     place(-y=>130,-x=>225,-width=>80,-height=>20);


    $mw->overrideredirect(0);


 MainLoop;

 sub myCANCEL(){
    my $d = $mw->pSimpleDialog(-title => "perlbox",-text =>"Are you sure you want to quit the install?");
    my $button = $d->Show;
       if($button){
        print "CANCEL PERLBOX VOICE INSTALL\n";
	    exit;
       }
       else{
          return;
       }
 }

 sub myOK(){
    if(!(-d $installLibDir)){
       show_dialog("Binary installation is not a directory. Would you like to choose another?");
       return;
    }
    if(!(-d $installBinDir)){
       show_dialog("Binary installation is not a directory. Would you like to choose another?");
       return;
    }
    if(!(-w $installLibDir)){
       show_dialog("You do not have permissions to install in library directory. Would you like to choose another?");
       return;
    }
    if(!(-w $installBinDir)){
       show_dialog("You do not have permissions to install in binary directory. Would you like to choose another?");
       return;
    }
    #show_dialog("Everything looks good. Should I start installing?");
    
    #remove any trailing '/'
    $installLibDir =~ s*\/$**;
    $installBinDir =~ s*\/$**; #/
    #create our library dir

    $installLibDir.="/perlbox-voice";
    mkdir($installLibDir);

     #get our current directory
     my $cwd=cwd;
     print "cp -a  $cwd/* $installLibDir\n";
    `cp -a  $cwd/* $installLibDir`;

     #set up all the files to be cpoied

     open(IN,"./pbox-voice") or die "ERROR: COULD NOT FIND NEEDED FILE pbox-voice\n";
     open(OUT,">$installLibDir"."/pbox-voice") or die "ERROR: COULD NOT FIND NEEDED FILE\n";

     my $line;
     while($line=<IN>){

        if($line=~/INSERT LIB PATH/){
           print OUT "use constant LIB_PATH => \"$installLibDir\";\n";
        }
        else{
           print OUT $line;
        }

     }
     close IN;
     close OUT;

     open(IN,"./PerlboxListener.pl") or die "ERROR: COULD NOT FIND NEEDED FILE PerlboxListener.pl\n";
     open(OUT,">$installLibDir"."/PerlboxListener.pl") or die "ERROR: COULD NOT FIND NEEDED FILE\n";

     my $line;
     while($line=<IN>){

        if($line=~/INSERT LIB PATH/){
           print OUT "use lib \"$installLibDir\";\n";
           print "FOUND\n";
        }
        else{
           print OUT $line;
        }

     }
     close IN;
     close OUT;

     open(IN,"./pbox.blank") or die "ERROR: COULD NOT FIND NEEDED FILE pbox-voice\n";
     open(OUT,">$installBinDir"."/perlbox-voice") or die "ERROR: COULD NOT FIND NEEDED BINARY FILE\n";
     

     my $line;
     while($line=<IN>){

        if($line=~/INSERT LIB PATH/){
           print OUT "use constant LIB_PATH => \"$installLibDir\";\n";
           print "FOUND\n";
        }
        else{
           print OUT $line;
        }

     }

     close IN;
     close OUT;
     #make executable
     chmod (0777 ,$installBinDir."/perlbox-voice");
     chmod (0755 ,$installLibDir."/bin/*");

     my $d = $mw->pSimpleDialog(-title => "perlbox",-text =>"Installation is complete. Run with $installBinDir"."/perlbox-voice",-OKonly=>'yes');
     my $button = $d->Show;
     print "Thank you for installing Perlbox voice for TK\nRun by typing\n$installBinDir"."/perlbox-voice \nat the prompt\n";
     exit;
 }

 sub myBrowseLib(){
     $installLibDir = $start_libinstall;
     $mw->pFileSel(-var=>\$installLibDir);
 }
 sub myBrowseBin(){
     $installBinDir = $start_bininstall;
     $mw->pFileSel(-var=>\$installBinDir);
 }

 sub show_dialog(){
     my $text=shift;
     my $d = $mw->pSimpleDialog(-title => "perlbox",-text =>$text);
     my $button = $d->Show;
     if(!$button){
        &myCANCEL;
     }
     else{
        return;
     }

 }
 

