/*
* This file is part of QTGZManager, an open-source GUI for Slackware pkgtools.
* Copyright (C) 2006  Alexandre Albuquerque Arnt
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail : Alexandre Albuquerque Arnt <aaarnt@gmail.com>
* Program URL   : http://jtgzmanager.sf.net
*
*/

#ifndef FINDDIALOGIMPL_H
#define FINDDIALOGIMPL_H

#include "ui_finddialog.h"
#include <QDialog>
#include <QThread>
#include <QPointer>

const int MIN_LENGTH_SEARCH_STRING(2);

class MainWindowImpl;
class ThreadFind;
class CPUIntensiveComputing;

class FindDialogImpl : public QDialog, public Ui::Dialog
{
	Q_OBJECT
	
	private:
		MainWindowImpl* w;
		CPUIntensiveComputing* m_ri;
		QPointer<ThreadFind> m_tf;
		void setEnableFindButton(bool enableFindButton);

	private slots:
		void execFind();
		void stopFind();
		void resetDialog();
		void positionInInstalledPkgList(QTreeWidgetItem*, int);
		void finishedSearch();

	public:
    FindDialogImpl(QWidget *parent);
    ~FindDialogImpl();

	public slots:
		void terminated(); 

	protected:
		virtual void showEvent(QShowEvent *);
		virtual void closeEvent(QCloseEvent *);
		void keyReleaseEvent(QKeyEvent* ke);
		void keyPressEvent(QKeyEvent* ke);
};

class ThreadFind : public QThread
{
	private:
		QMap<QString, QStringList> m_map;
		QString m_stringToSearch;

	public:
		ThreadFind(QString& stringToSearch):m_stringToSearch(stringToSearch){};
		void run();
		QMap<QString, QStringList>& getResultMap();
};

#endif
