/*
* This file is part of QTGZManager, an open-source GUI for Slackware pkgtools.
* Copyright (C) 2006  Alexandre Albuquerque Arnt
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail : Alexandre Albuquerque Arnt <aaarnt@gmail.com>
* Program URL   : http://jtgzmanager.sf.net
*
*/
#ifndef PACKAGE_H
#define PACKAGE_H

#include <QString>
#include <QStringList>
#include <QSettings>
#include <QDir>

const char* const DIR          	= "/var/log/packages/";
const char* const FILELIST    	= "FILE LIST:\n";
const QString er  				   	  = "([\\w._+]+[-])+";
const QString er3 				  	  = "[\\w._+]+[-]";
const QString STRING_RELEASES   = "(alfa|beta|rc|pre|patch|^[0-9]{8}$|(^[rR][0-9]*)|[0-9]*[uU][0-9]*)";
const QString DATE_RELEASE      = "^[0-9]{8}$";
const QString DUMP_FILE					= "installed_packages_list_";
const QString PACKAGES_DIR   	  = "/var/log/packages";
const QString NO_MATCH      	  = "not found!";
const QString TGZ_PACKAGE_EXTENSION = ".tgz";
const QString RPM_PACKAGE_EXTENSION = ".rpm";
const QString KNOWN_ARCHS[]     = {"noarch", "i386", "i486", "i586", "i686", "i786", "i886", "i986", "x86_64"};      
const QString KEY_FROZEN_PACKAGES_LIST ( "Frozen_Packages" );
const QString KNOWN_NAMES[]   	= {"cdparanoia", "libjpeg", "slib"};
const int KNOWN_ARCHS_LEN = 8;
const int KNOWN_NAMES_LEN = 3;

enum Classification { NOT_INSTALLED, 
	INSTALLED, INFERIOR_VERSION, SUPERIOR_VERSION, OTHER_VERSION, INTERNAL_ERROR, FROZEN, RPM };

class Result;
class Package{  
	private:

		QDir* scanPackages;
		QStringList m_lPackages;
		QString targetDir;
		
		QString showRegExp( const QString&, const QString& );		
		Result verifyPreReleasePackage(const QStringList &versao1, const QStringList &versao2, const QString &pacote);
		static QString makeURLClickable( const QString & information );

	public:

		Package();
		~Package();
		
		static QMap<QString, QStringList> findFile( const QString& name );
		static QString getBaseName( const QString& pkgName );    
		static QString getInformation( QString pkgName, bool installed = false );
		static QStringList getContents( const QString& pkgName, bool installed = false );	
		static bool isValid( const QString& pkgName );
		
		QString dumpInstalledPackageList();	
		Result getStatus( const QString& pkgName );
		void setTargetDir( const QString& );
};

class Result{
	private:
		Classification classification; 
		QString installedPackage;
	
	public:
		Result( Classification c, const QString& p ){
			classification = c;
			installedPackage = p;
		}
	
		Classification getClassification(){
			return classification;
		}
	
		QString getInstalledPackage(){
			return installedPackage;
		}
};

class FrozenPkgListSingleton : public QStringList {
	private:
		static FrozenPkgListSingleton *m_pinstance;
		QSettings *m_SYSsettings;
		
		FrozenPkgListSingleton():QStringList(){
			m_SYSsettings = new QSettings(QSettings::UserScope, "QTGZManager", "QTGZManager");
			QVariant v = m_SYSsettings->value( KEY_FROZEN_PACKAGES_LIST, QVariant(QStringList()) );
			*this << v.toStringList();
		}	
		FrozenPkgListSingleton(const FrozenPkgListSingleton&);
    FrozenPkgListSingleton& operator= (const FrozenPkgListSingleton&);

	public:
		void save(){ m_SYSsettings->setValue( KEY_FROZEN_PACKAGES_LIST, QVariant( static_cast<QStringList>(*this)) );}
		
		static FrozenPkgListSingleton* instance(){
		 if (m_pinstance == 0) m_pinstance = new FrozenPkgListSingleton(); 
		 return m_pinstance;	
		}		
};

#endif
