/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */

#include <ccm-action-pointer-motion.h>
#include <float.h>
#include <math.h>
#include <ccm-action.h>




enum  {
	CCM_ACTION_POINTER_MOTION_DUMMY_PROPERTY,
	CCM_ACTION_POINTER_MOTION_EVENT
};
static char* ccm_action_pointer_motion_real_to_string (CCMAction* base, const char* format);
static gpointer ccm_action_pointer_motion_parent_class = NULL;



CCMActionPointerMotion* ccm_action_pointer_motion_construct (GType object_type, CCMScreen* screen, XMotionEvent* event, glong time) {
	CCMActionPointerMotion * self;
	g_return_val_if_fail (screen != NULL, NULL);
	g_return_val_if_fail (event != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	ccm_action_pointer_motion_set_event (self, event);
	ccm_action_set_time ((CCMAction*) self, (glong) ((gint) (((double) time) / ((double) 1000))));
	return self;
}


CCMActionPointerMotion* ccm_action_pointer_motion_new (CCMScreen* screen, XMotionEvent* event, glong time) {
	return ccm_action_pointer_motion_construct (CCM_TYPE_ACTION_POINTER_MOTION, screen, event, time);
}


static char* ccm_action_pointer_motion_real_to_string (CCMAction* base, const char* format) {
	CCMActionPointerMotion * self;
	char* _tmp10;
	char* _tmp9;
	char* _tmp8;
	char* _tmp7;
	char* _tmp6;
	char* _tmp5;
	char* _tmp4;
	char* _tmp3;
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	char* _tmp11;
	char* val;
	self = (CCMActionPointerMotion*) base;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp11 = NULL;
	val = (_tmp11 = g_strconcat (_tmp10 = g_strconcat (_tmp8 = g_strconcat (_tmp7 = g_strconcat (_tmp5 = g_strconcat (_tmp4 = g_strconcat (_tmp2 = g_strconcat (_tmp1 = g_strconcat ("<pointer-motion button=\"", _tmp0 = g_strdup_printf ("%u", ccm_action_pointer_get_button ((CCMActionPointer*) self)), NULL), "\" x=\"", NULL), _tmp3 = g_strdup_printf ("%i", ccm_action_pointer_get_x ((CCMActionPointer*) self)), NULL), "\" y=\"", NULL), _tmp6 = g_strdup_printf ("%i", ccm_action_pointer_get_y ((CCMActionPointer*) self)), NULL), "\" time=\"", NULL), _tmp9 = g_strdup_printf ("%li", ccm_action_get_time ((CCMAction*) self)), NULL), "\"/>", NULL), _tmp10 = (g_free (_tmp10), NULL), _tmp9 = (g_free (_tmp9), NULL), _tmp8 = (g_free (_tmp8), NULL), _tmp7 = (g_free (_tmp7), NULL), _tmp6 = (g_free (_tmp6), NULL), _tmp5 = (g_free (_tmp5), NULL), _tmp4 = (g_free (_tmp4), NULL), _tmp3 = (g_free (_tmp3), NULL), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp11);
	return val;
}


void ccm_action_pointer_motion_set_event (CCMActionPointerMotion* self, XMotionEvent* value) {
	g_return_if_fail (self != NULL);
	ccm_action_pointer_set_button ((CCMActionPointer*) self, ((guint) value->state) >> 8);
	ccm_action_pointer_set_x ((CCMActionPointer*) self, value->y_root);
	ccm_action_pointer_set_y ((CCMActionPointer*) self, value->x_root);
	g_object_notify ((GObject *) self, "event");
}


static void ccm_action_pointer_motion_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CCMActionPointerMotion * self;
	self = CCM_ACTION_POINTER_MOTION (object);
	switch (property_id) {
		case CCM_ACTION_POINTER_MOTION_EVENT:
		ccm_action_pointer_motion_set_event (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ccm_action_pointer_motion_class_init (CCMActionPointerMotionClass * klass) {
	ccm_action_pointer_motion_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->set_property = ccm_action_pointer_motion_set_property;
	CCM_ACTION_CLASS (klass)->to_string = ccm_action_pointer_motion_real_to_string;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CCM_ACTION_POINTER_MOTION_EVENT, g_param_spec_pointer ("event", "event", "event", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
}


static void ccm_action_pointer_motion_instance_init (CCMActionPointerMotion * self) {
}


static GType ccm_action_pointer_motion_type_id = 0;
GType ccm_action_pointer_motion_get_type (void) {
	return ccm_action_pointer_motion_type_id;
}


GType ccm_action_pointer_motion_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMActionPointerMotionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_action_pointer_motion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMActionPointerMotion), 0, (GInstanceInitFunc) ccm_action_pointer_motion_instance_init, NULL };
	ccm_action_pointer_motion_type_id = g_type_module_register_type (module, CCM_TYPE_ACTION_POINTER, "CCMActionPointerMotion", &g_define_type_info, 0);
	return ccm_action_pointer_motion_type_id;
}




