/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */

#include <ccm-action-pointer-press.h>
#include <ccm-window.h>
#include <ccm-window-plugin.h>
#include <float.h>
#include <math.h>
#include <ccm-action.h>




enum  {
	CCM_ACTION_POINTER_PRESS_DUMMY_PROPERTY
};
static char* ccm_action_pointer_press_real_to_string (CCMAction* base, const char* format);
static gpointer ccm_action_pointer_press_parent_class = NULL;



CCMActionPointerPress* ccm_action_pointer_press_construct (GType object_type, CCMScreen* screen, XButtonEvent* event, glong time, GList* ignore, GError** error) {
	GError * inner_error;
	CCMActionPointerPress * self;
	CCMWindow* _tmp0;
	CCMWindow* window;
	g_return_val_if_fail (screen != NULL, NULL);
	g_return_val_if_fail (event != NULL, NULL);
	g_return_val_if_fail (ignore != NULL, NULL);
	inner_error = NULL;
	self = g_object_newv (object_type, 0, NULL);
	_tmp0 = NULL;
	window = (_tmp0 = ccm_screen_find_window_at_pos (screen, event->y_root, event->x_root), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	if (window != NULL) {
		gboolean found;
		found = FALSE;
		{
			GList* item_collection;
			GList* item_it;
			item_collection = ignore;
			for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
				CCMWindow* _tmp1;
				CCMWindow* item;
				_tmp1 = NULL;
				item = (_tmp1 = (CCMWindow*) item_it->data, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
				{
					found = found | (CCM_WINDOW_XWINDOW (item) == CCM_WINDOW_XWINDOW (window));
					(item == NULL) ? NULL : (item = (g_object_unref (item), NULL));
				}
			}
		}
		if (!found) {
			ccm_action_pointer_set_button ((CCMActionPointer*) self, ((guint) event->state) >> 8);
			ccm_action_pointer_set_x ((CCMActionPointer*) self, event->y_root);
			ccm_action_pointer_set_y ((CCMActionPointer*) self, event->x_root);
			ccm_action_set_time ((CCMAction*) self, (glong) (((double) time) / ((double) 1000)));
		} else {
			g_object_unref ((GObject*) self);
			inner_error = g_error_new (CCM_ACTION_ERROR, CCM_ACTION_ERROR_WINDOW_IGNORE, "Window is ignored at pos %i,%i", event->y_root, event->x_root);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				(window == NULL) ? NULL : (window = (g_object_unref (window), NULL));
				return;
			}
		}
	} else {
		g_object_unref ((GObject*) self);
		inner_error = g_error_new (CCM_ACTION_ERROR, CCM_ACTION_ERROR_WINDOW_NOT_FOUND, "Window not found at pos %i,%i", event->y_root, event->x_root);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(window == NULL) ? NULL : (window = (g_object_unref (window), NULL));
			return;
		}
	}
	return self;
}


CCMActionPointerPress* ccm_action_pointer_press_new (CCMScreen* screen, XButtonEvent* event, glong time, GList* ignore, GError** error) {
	return ccm_action_pointer_press_construct (CCM_TYPE_ACTION_POINTER_PRESS, screen, event, time, ignore, error);
}


static char* ccm_action_pointer_press_real_to_string (CCMAction* base, const char* format) {
	CCMActionPointerPress * self;
	char* _tmp10;
	char* _tmp9;
	char* _tmp8;
	char* _tmp7;
	char* _tmp6;
	char* _tmp5;
	char* _tmp4;
	char* _tmp3;
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	char* _tmp11;
	char* val;
	self = (CCMActionPointerPress*) base;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp11 = NULL;
	val = (_tmp11 = g_strconcat (_tmp10 = g_strconcat (_tmp8 = g_strconcat (_tmp7 = g_strconcat (_tmp5 = g_strconcat (_tmp4 = g_strconcat (_tmp2 = g_strconcat (_tmp1 = g_strconcat ("<pointer-press button=\"", _tmp0 = g_strdup_printf ("%u", ccm_action_pointer_get_button ((CCMActionPointer*) self)), NULL), "\" x=\"", NULL), _tmp3 = g_strdup_printf ("%i", ccm_action_pointer_get_x ((CCMActionPointer*) self)), NULL), "\" y=\"", NULL), _tmp6 = g_strdup_printf ("%i", ccm_action_pointer_get_y ((CCMActionPointer*) self)), NULL), "\" time=\"", NULL), _tmp9 = g_strdup_printf ("%li", ccm_action_get_time ((CCMAction*) self)), NULL), "\"/>", NULL), _tmp10 = (g_free (_tmp10), NULL), _tmp9 = (g_free (_tmp9), NULL), _tmp8 = (g_free (_tmp8), NULL), _tmp7 = (g_free (_tmp7), NULL), _tmp6 = (g_free (_tmp6), NULL), _tmp5 = (g_free (_tmp5), NULL), _tmp4 = (g_free (_tmp4), NULL), _tmp3 = (g_free (_tmp3), NULL), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp11);
	return val;
}


static void ccm_action_pointer_press_class_init (CCMActionPointerPressClass * klass) {
	ccm_action_pointer_press_parent_class = g_type_class_peek_parent (klass);
	CCM_ACTION_CLASS (klass)->to_string = ccm_action_pointer_press_real_to_string;
}


static void ccm_action_pointer_press_instance_init (CCMActionPointerPress * self) {
}


static GType ccm_action_pointer_press_type_id = 0;
GType ccm_action_pointer_press_get_type (void) {
	return ccm_action_pointer_press_type_id;
}


GType ccm_action_pointer_press_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMActionPointerPressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_action_pointer_press_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMActionPointerPress), 0, (GInstanceInitFunc) ccm_action_pointer_press_instance_init, NULL };
	ccm_action_pointer_press_type_id = g_type_module_register_type (module, CCM_TYPE_ACTION_POINTER, "CCMActionPointerPress", &g_define_type_info, 0);
	return ccm_action_pointer_press_type_id;
}




